/*
 * Decompiled with CFR 0.152.
 */
package com.clevertap.android.sdk;

import android.os.Parcel;
import android.os.Parcelable;
import java.util.ArrayList;
import java.util.Arrays;

public class CTInboxStyleConfig
implements Parcelable {
    private static final int MAX_TABS = 2;
    private String titleColor;
    private String bodyColor;
    private String ctaColor;
    private String layoutColor;
    private String navBarColor;
    private String navBarTitle;
    private String navBarTitleColor;
    private String inboxBackgroundColor;
    private boolean usingTabs;
    private String backButtonColor;
    private String selectedTabColor;
    private String unselectedTabColor;
    private String selectedTabIndicatorColor;
    private String tabBackgroundColor;
    private String[] tabs;
    public static final Parcelable.Creator<CTInboxStyleConfig> CREATOR = new Parcelable.Creator<CTInboxStyleConfig>(){

        public CTInboxStyleConfig createFromParcel(Parcel in) {
            return new CTInboxStyleConfig(in);
        }

        public CTInboxStyleConfig[] newArray(int size) {
            return new CTInboxStyleConfig[size];
        }
    };

    public CTInboxStyleConfig() {
        this.navBarColor = "#FFFFFF";
        this.navBarTitle = "App Inbox";
        this.navBarTitleColor = "#333333";
        this.inboxBackgroundColor = "#D3D4DA";
        this.backButtonColor = "#333333";
        this.selectedTabColor = "#1C84FE";
        this.unselectedTabColor = "#808080";
        this.selectedTabIndicatorColor = "#1C84FE";
        this.tabBackgroundColor = "#FFFFFF";
        this.tabs = new String[0];
    }

    CTInboxStyleConfig(CTInboxStyleConfig config) {
        this.navBarColor = config.navBarColor;
        this.navBarTitle = config.navBarTitle;
        this.navBarTitleColor = config.navBarTitleColor;
        this.inboxBackgroundColor = config.inboxBackgroundColor;
        this.backButtonColor = config.backButtonColor;
        this.selectedTabColor = config.selectedTabColor;
        this.unselectedTabColor = config.unselectedTabColor;
        this.selectedTabIndicatorColor = config.selectedTabIndicatorColor;
        this.tabBackgroundColor = config.tabBackgroundColor;
        this.tabs = config.tabs == null ? new String[]{} : Arrays.copyOf(config.tabs, config.tabs.length);
    }

    protected CTInboxStyleConfig(Parcel in) {
        this.titleColor = in.readString();
        this.bodyColor = in.readString();
        this.ctaColor = in.readString();
        this.layoutColor = in.readString();
        this.navBarColor = in.readString();
        this.navBarTitle = in.readString();
        this.navBarTitleColor = in.readString();
        this.inboxBackgroundColor = in.readString();
        this.tabs = in.createStringArray();
        this.usingTabs = in.readByte() != 0;
        this.backButtonColor = in.readString();
        this.selectedTabColor = in.readString();
        this.unselectedTabColor = in.readString();
        this.selectedTabIndicatorColor = in.readString();
        this.tabBackgroundColor = in.readString();
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeString(this.titleColor);
        dest.writeString(this.bodyColor);
        dest.writeString(this.ctaColor);
        dest.writeString(this.layoutColor);
        dest.writeString(this.navBarColor);
        dest.writeString(this.navBarTitle);
        dest.writeString(this.navBarTitleColor);
        dest.writeString(this.inboxBackgroundColor);
        dest.writeStringArray(this.tabs);
        dest.writeByte((byte)(this.usingTabs ? 1 : 0));
        dest.writeString(this.backButtonColor);
        dest.writeString(this.selectedTabColor);
        dest.writeString(this.unselectedTabColor);
        dest.writeString(this.selectedTabIndicatorColor);
        dest.writeString(this.tabBackgroundColor);
    }

    String getTitleColor() {
        return this.titleColor;
    }

    void setTitleColor(String titleColor) {
        this.titleColor = titleColor;
    }

    String getBodyColor() {
        return this.bodyColor;
    }

    void setBodyColor(String bodyColor) {
        this.bodyColor = bodyColor;
    }

    String getCtaColor() {
        return this.ctaColor;
    }

    void setCtaColor(String ctaColor) {
        this.ctaColor = ctaColor;
    }

    String getLayoutColor() {
        return this.layoutColor;
    }

    void setLayoutColor(String layoutColor) {
        this.layoutColor = layoutColor;
    }

    public String getNavBarColor() {
        return this.navBarColor;
    }

    public void setNavBarColor(String navBarColor) {
        this.navBarColor = navBarColor;
    }

    public String getNavBarTitle() {
        return this.navBarTitle;
    }

    public void setNavBarTitle(String navBarTitle) {
        this.navBarTitle = navBarTitle;
    }

    public String getNavBarTitleColor() {
        return this.navBarTitleColor;
    }

    public void setNavBarTitleColor(String navBarTitleColor) {
        this.navBarTitleColor = navBarTitleColor;
    }

    public String getInboxBackgroundColor() {
        return this.inboxBackgroundColor;
    }

    public void setInboxBackgroundColor(String inboxBackgroundColor) {
        this.inboxBackgroundColor = inboxBackgroundColor;
    }

    public void setTabs(ArrayList<String> tabs) {
        if (tabs == null || tabs.size() <= 0) {
            return;
        }
        ArrayList<String> toAdd = tabs.size() > 2 ? new ArrayList<String>(tabs.subList(0, 2)) : tabs;
        this.tabs = toAdd.toArray(new String[0]);
    }

    public ArrayList<String> getTabs() {
        return this.tabs == null ? new ArrayList<String>() : new ArrayList<String>(Arrays.asList(this.tabs));
    }

    boolean isUsingTabs() {
        return this.tabs != null && this.tabs.length > 0;
    }

    public String getBackButtonColor() {
        return this.backButtonColor;
    }

    public void setBackButtonColor(String backButtonColor) {
        this.backButtonColor = backButtonColor;
    }

    public String getSelectedTabColor() {
        return this.selectedTabColor;
    }

    public void setSelectedTabColor(String selectedTabColor) {
        this.selectedTabColor = selectedTabColor;
    }

    public String getUnselectedTabColor() {
        return this.unselectedTabColor;
    }

    public void setUnselectedTabColor(String unselectedTabColor) {
        this.unselectedTabColor = unselectedTabColor;
    }

    public String getSelectedTabIndicatorColor() {
        return this.selectedTabIndicatorColor;
    }

    public void setSelectedTabIndicatorColor(String selectedTabIndicatorColor) {
        this.selectedTabIndicatorColor = selectedTabIndicatorColor;
    }

    public String getTabBackgroundColor() {
        return this.tabBackgroundColor;
    }

    public void setTabBackgroundColor(String tabBackgroundColor) {
        this.tabBackgroundColor = tabBackgroundColor;
    }
}

