/*
 * Decompiled with CFR 0.152.
 */
package com.clevertap.android.sdk;

import android.app.IntentService;
import android.app.NotificationManager;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.Bundle;
import com.clevertap.android.sdk.Logger;

public class CTNotificationIntentService
extends IntentService {
    public static final String MAIN_ACTION = "com.clevertap.PUSH_EVENT";
    public static final String TYPE_BUTTON_CLICK = "com.clevertap.ACTION_BUTTON_CLICK";

    public CTNotificationIntentService() {
        super("CTNotificationIntentService");
    }

    protected void onHandleIntent(Intent intent) {
        Bundle extras = intent.getExtras();
        if (extras == null) {
            return;
        }
        String type = extras.getString("ct_type");
        if (type != null && TYPE_BUTTON_CLICK.equals(type)) {
            Logger.v("CTNotificationIntentService handling com.clevertap.ACTION_BUTTON_CLICK");
            this.handleActionButtonClick(extras);
        } else {
            Logger.v("CTNotificationIntentService: unhandled intent " + intent.getAction());
        }
    }

    private void handleActionButtonClick(Bundle extras) {
        try {
            NotificationManager notificationManager;
            boolean autoCancel = extras.getBoolean("autoCancel", false);
            int notificationId = extras.getInt("notificationId", -1);
            String dl = extras.getString("dl");
            Context context = this.getApplicationContext();
            Intent launchIntent = dl != null ? new Intent("android.intent.action.VIEW", Uri.parse((String)dl)) : context.getPackageManager().getLaunchIntentForPackage(context.getPackageName());
            if (launchIntent == null) {
                Logger.v("CTNotificationService: create launch intent.");
                return;
            }
            launchIntent.setFlags(0x34000000);
            launchIntent.putExtras(extras);
            launchIntent.removeExtra("dl");
            if (autoCancel && notificationId > -1 && (notificationManager = (NotificationManager)this.getApplicationContext().getSystemService("notification")) != null) {
                notificationManager.cancel(notificationId);
            }
            this.sendBroadcast(new Intent("android.intent.action.CLOSE_SYSTEM_DIALOGS"));
            this.startActivity(launchIntent);
        }
        catch (Throwable t) {
            Logger.v("CTNotificationService: unable to process action button click:  " + t.getLocalizedMessage());
        }
    }
}

