/*
 * Decompiled with CFR 0.152.
 */
package com.clevertap.android.sdk;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.app.Fragment;
import android.content.Context;
import android.content.Intent;
import android.content.res.Configuration;
import android.graphics.Point;
import android.net.Uri;
import android.os.Bundle;
import android.support.annotation.Nullable;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import android.view.GestureDetector;
import android.view.LayoutInflater;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.AlphaAnimation;
import android.view.animation.Animation;
import android.view.animation.AnimationSet;
import android.view.animation.TranslateAnimation;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import android.widget.FrameLayout;
import com.clevertap.android.sdk.CTInAppNotification;
import com.clevertap.android.sdk.CTInAppType;
import com.clevertap.android.sdk.CleverTapAPI;
import com.clevertap.android.sdk.CleverTapInstanceConfig;
import com.clevertap.android.sdk.Logger;
import com.clevertap.android.sdk.R;
import com.clevertap.android.sdk.UriHelper;
import java.net.URLDecoder;

public class InAppFragment
extends Fragment
implements View.OnTouchListener,
View.OnLongClickListener {
    private CTInAppNotification inAppNotification;
    private InAppWebView webView;
    private final Point dim = new Point();
    private CleverTapInstanceConfig config;
    private CleverTapAPI cleverTapAPI;
    private final GestureDetector gd = new GestureDetector((GestureDetector.OnGestureListener)new GestureListener());

    public void onAttach(Activity activity) {
        super.onAttach(activity);
        Bundle bundle = this.getArguments();
        this.inAppNotification = (CTInAppNotification)bundle.getParcelable("inApp");
        this.config = (CleverTapInstanceConfig)bundle.getParcelable("config");
        this.cleverTapAPI = CleverTapAPI.instanceWithConfig(this.getActivity().getBaseContext(), this.config);
    }

    @Nullable
    public View onCreateView(LayoutInflater inflater, @Nullable ViewGroup container, Bundle savedInstanceState) {
        View inAppView = null;
        try {
            FrameLayout fl = null;
            if (this.inAppNotification.getInAppType().equals((Object)CTInAppType.CTInAppTypeHeaderHTML)) {
                inAppView = inflater.inflate(R.layout.header, container, false);
                fl = (FrameLayout)inAppView.findViewById(R.id.header_frame_layout);
            } else if (this.inAppNotification.getInAppType().equals((Object)CTInAppType.CTInAppTypeFooterHTML)) {
                inAppView = inflater.inflate(R.layout.footer, container, false);
                fl = (FrameLayout)inAppView.findViewById(R.id.footer_frame_layout);
            }
            this.webView = new InAppWebView(this.getActivity().getBaseContext());
            InAppWebViewClient webViewClient = new InAppWebViewClient();
            this.webView.setWebViewClient(webViewClient);
            if (fl != null) {
                fl.addView((View)this.webView);
            }
        }
        catch (Throwable t) {
            this.config.getLogger().verbose(this.config.getAccountId(), "Fragment view not created", t);
            return null;
        }
        return inAppView;
    }

    public void onViewCreated(View view, @Nullable Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
        this.reDrawInApp();
    }

    public void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
    }

    private int getScaledPixels(int raw) {
        return (int)TypedValue.applyDimension((int)1, (float)raw, (DisplayMetrics)this.getResources().getDisplayMetrics());
    }

    private void fireUrlThroughIntent(String url, Bundle formData) {
        try {
            Intent intent = new Intent("android.intent.action.VIEW", Uri.parse((String)url));
            this.startActivity(intent);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.removeFragment(formData);
    }

    private void updateDimension() {
        DisplayMetrics metrics;
        if (this.inAppNotification.getWidth() != 0) {
            this.dim.x = (int)TypedValue.applyDimension((int)1, (float)this.inAppNotification.getWidth(), (DisplayMetrics)this.getResources().getDisplayMetrics());
        } else {
            metrics = this.getResources().getDisplayMetrics();
            this.dim.x = (int)((float)(metrics.widthPixels * this.inAppNotification.getWidthPercentage()) / 100.0f);
        }
        if (this.inAppNotification.getHeight() != 0) {
            this.dim.y = (int)TypedValue.applyDimension((int)1, (float)this.inAppNotification.getHeight(), (DisplayMetrics)this.getResources().getDisplayMetrics());
        } else {
            metrics = this.getResources().getDisplayMetrics();
            this.dim.y = (int)((float)(metrics.heightPixels * this.inAppNotification.getHeightPercentage()) / 100.0f);
        }
    }

    private void reDrawInApp() {
        this.updateDimension();
        int mHeight = this.dim.y;
        int mWidth = this.dim.x;
        float d = this.getResources().getDisplayMetrics().density;
        mHeight = (int)((float)mHeight / d);
        mWidth = (int)((float)mWidth / d);
        String html = this.inAppNotification.getHtml();
        String style = "<style>body{width:" + mWidth + "px; height: " + mHeight + "px}</style>";
        html = html.replaceFirst("<head>", "<head>" + style);
        Logger.v("Density appears to be " + d);
        this.webView.setInitialScale((int)(d * 100.0f));
        this.webView.loadDataWithBaseURL(null, html, "text/html", "utf-8", null);
    }

    public void onDestroy() {
        super.onDestroy();
    }

    public boolean onLongClick(View v) {
        return true;
    }

    @SuppressLint(value={"ClickableViewAccessibility"})
    public boolean onTouch(View v, MotionEvent event) {
        return this.gd.onTouchEvent(event) || event.getAction() == 2;
    }

    public void onConfigurationChanged(Configuration newConfig) {
        super.onConfigurationChanged(newConfig);
        this.reDrawInApp();
    }

    private void removeFragment(Bundle formData) {
        this.getActivity().getFragmentManager().beginTransaction().remove((Fragment)this).setCustomAnimations(0x10B0000, 0x10B0001).commit();
        this.cleverTapAPI.notificationDidDismiss(this.getActivity().getBaseContext(), this.inAppNotification, formData);
    }

    private class GestureListener
    extends GestureDetector.SimpleOnGestureListener {
        private final int SWIPE_MIN_DISTANCE = 120;
        private final int SWIPE_THRESHOLD_VELOCITY = 200;

        private GestureListener() {
        }

        public boolean onFling(MotionEvent e1, MotionEvent e2, float velocityX, float velocityY) {
            if (e1.getX() - e2.getX() > 120.0f && Math.abs(velocityX) > 200.0f) {
                return this.remove(e1, e2, false);
            }
            if (e2.getX() - e1.getX() > 120.0f && Math.abs(velocityX) > 200.0f) {
                return this.remove(e1, e2, true);
            }
            return false;
        }

        private boolean remove(MotionEvent e1, MotionEvent e2, boolean ltr) {
            AnimationSet animSet = new AnimationSet(true);
            TranslateAnimation anim = ltr ? new TranslateAnimation(0.0f, (float)InAppFragment.this.getScaledPixels(50), 0.0f, 0.0f) : new TranslateAnimation(0.0f, (float)(-InAppFragment.this.getScaledPixels(50)), 0.0f, 0.0f);
            animSet.addAnimation((Animation)anim);
            animSet.addAnimation((Animation)new AlphaAnimation(1.0f, 0.0f));
            animSet.setDuration(300L);
            animSet.setFillAfter(true);
            animSet.setFillEnabled(true);
            animSet.setAnimationListener(new Animation.AnimationListener(){

                public void onAnimationStart(Animation animation) {
                }

                public void onAnimationEnd(Animation animation) {
                    InAppFragment.this.removeFragment(null);
                }

                public void onAnimationRepeat(Animation animation) {
                }
            });
            InAppFragment.this.webView.startAnimation((Animation)animSet);
            return true;
        }
    }

    private class InAppWebViewClient
    extends WebViewClient {
        InAppWebViewClient() {
        }

        public boolean shouldOverrideUrlLoading(WebView view, String url) {
            try {
                String[] parts;
                String c2a;
                Bundle formData = UriHelper.getAllKeyValuePairs(url, false);
                if (formData != null && formData.containsKey("wzrk_c2a") && (c2a = formData.getString("wzrk_c2a")) != null && (parts = c2a.split("__dl__")).length == 2) {
                    formData.putString("wzrk_c2a", URLDecoder.decode(parts[0], "UTF-8"));
                    url = parts[1];
                }
                InAppFragment.this.cleverTapAPI.pushInAppNotificationStateEvent(true, InAppFragment.this.inAppNotification, formData);
                Logger.d("Executing call to action for in-app: " + url);
                InAppFragment.this.fireUrlThroughIntent(url, formData);
            }
            catch (Throwable t) {
                Logger.v("Error parsing the in-app notification action!", t);
            }
            return true;
        }
    }

    private class InAppWebView
    extends WebView {
        @SuppressLint(value={"ResourceType"})
        public InAppWebView(Context context) {
            super(context);
            this.setHorizontalScrollBarEnabled(false);
            this.setVerticalScrollBarEnabled(false);
            this.setHorizontalFadingEdgeEnabled(false);
            this.setVerticalFadingEdgeEnabled(false);
            this.setOverScrollMode(2);
            this.setBackgroundColor(0);
            this.setOnTouchListener(InAppFragment.this);
            this.setOnLongClickListener(InAppFragment.this);
            this.setId(188293);
        }

        protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
            super.onMeasure(widthMeasureSpec, heightMeasureSpec);
            InAppFragment.this.updateDimension();
            this.setMeasuredDimension(((InAppFragment)InAppFragment.this).dim.x, ((InAppFragment)InAppFragment.this).dim.y);
        }
    }
}

