/*
 * Decompiled with CFR 0.152.
 */
package com.clevertap.android.sdk;

import android.content.Context;
import android.content.SharedPreferences;
import com.clevertap.android.sdk.CTInAppNotification;
import com.clevertap.android.sdk.CleverTapInstanceConfig;
import com.clevertap.android.sdk.Logger;
import com.clevertap.android.sdk.StorageHelper;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONObject;

class InAppFCManager {
    private Context context;
    private CleverTapInstanceConfig config;
    private static final SimpleDateFormat ddMMyyyy = new SimpleDateFormat("ddMMyyyy", Locale.US);
    private final ArrayList<String> mDismissedThisSession = new ArrayList();
    private final HashMap<String, Integer> mShownThisSession = new HashMap();
    private int mShownThisSessionCount = 0;

    InAppFCManager(Context context, CleverTapInstanceConfig config) {
        this.config = config;
        this.context = context;
        this.init();
    }

    private Logger getConfigLogger() {
        return this.config.getLogger();
    }

    private String getConfigAccountId() {
        return this.config.getAccountId();
    }

    private void init() {
        String lastUpdated;
        String today = ddMMyyyy.format(new Date());
        if (!today.equals(lastUpdated = this.getStringFromPrefs("ict_date", "20140428"))) {
            StorageHelper.putString(this.context, this.storageKeyWithSuffix("ict_date"), today);
            StorageHelper.putInt(this.context, this.storageKeyWithSuffix("istc_inapp"), 0);
            SharedPreferences prefs = StorageHelper.getPreferences(this.context, "counts_per_inapp");
            SharedPreferences.Editor editor = prefs.edit();
            Map all = prefs.getAll();
            for (String inapp : all.keySet()) {
                Object ov = all.get(inapp);
                if (!(ov instanceof String)) {
                    editor.remove(inapp);
                    continue;
                }
                String[] oldValues = ((String)ov).split(",");
                if (oldValues.length != 2) {
                    editor.remove(inapp);
                    continue;
                }
                try {
                    editor.putString(inapp, "0," + oldValues[1]);
                }
                catch (Throwable t) {
                    this.getConfigLogger().verbose(this.getConfigAccountId(), "Failed to reset todayCount for inapp " + inapp, t);
                }
            }
            StorageHelper.persist(editor);
        }
    }

    boolean canShow(CTInAppNotification inapp) {
        try {
            if (inapp == null) {
                return false;
            }
            String id2 = this.getInAppID(inapp);
            if (id2 == null) {
                return true;
            }
            if (inapp.isExcludeFromCaps()) {
                return true;
            }
            if (this.hasSessionCapacityMaxedOut(inapp)) break block7;
            if (this.hasLifetimeCapacityMaxedOut(inapp)) break block8;
            if (!this.hasDailyCapacityMaxedOut(inapp)) {
                return true;
            }
        }
        finally {
            return false;
        }
        {
            block7: {
                block8: {
                }
            }
        }
    }

    void didShow(Context context, CTInAppNotification inapp) {
        String id2 = this.getInAppID(inapp);
        if (id2 == null) {
            return;
        }
        ++this.mShownThisSessionCount;
        Integer count = this.mShownThisSession.get(id2);
        if (count == null) {
            count = 1;
        }
        count = count + 1;
        this.mShownThisSession.put(id2, count);
        this.incrementInAppCountsInPersistentStore(id2);
        int shownToday = this.getIntFromPrefs("istc_inapp", 0);
        StorageHelper.putInt(context, this.storageKeyWithSuffix("istc_inapp"), ++shownToday);
    }

    void didDismiss(CTInAppNotification inapp) {
        String id2 = inapp.getId();
        if (id2 != null) {
            this.mDismissedThisSession.add(id2.toString());
        }
    }

    private String getInAppID(CTInAppNotification inapp) {
        if (!inapp.getId().isEmpty()) {
            try {
                return inapp.getId();
            }
            catch (Throwable ignored) {
                return null;
            }
        }
        return null;
    }

    private boolean hasSessionCapacityMaxedOut(CTInAppNotification inapp) {
        String id2 = this.getInAppID(inapp);
        if (id2 == null) {
            return false;
        }
        if (this.mDismissedThisSession.contains(id2)) {
            return true;
        }
        try {
            int maxPerSession = inapp.getMaxPerSession() >= 0 ? inapp.getMaxPerSession() : 1000;
            Integer c = this.mShownThisSession.get(id2);
            if (c != null && c >= maxPerSession) {
                return true;
            }
        }
        catch (Throwable t) {
            return true;
        }
        int c = this.getIntFromPrefs("imc", 1);
        return this.mShownThisSessionCount >= c;
    }

    private boolean hasLifetimeCapacityMaxedOut(CTInAppNotification inapp) {
        String id2 = this.getInAppID(inapp);
        if (id2 == null) {
            return false;
        }
        if (inapp.getTotalLifetimeCount() == -1) {
            return false;
        }
        try {
            int[] counts = this.getInAppCountsFromPersistentStore(id2);
            if (counts[1] >= inapp.getTotalLifetimeCount()) {
                return true;
            }
        }
        catch (Exception e) {
            return true;
        }
        return false;
    }

    private boolean hasDailyCapacityMaxedOut(CTInAppNotification inapp) {
        int maxPerDayCount;
        String id2 = this.getInAppID(inapp);
        if (id2 == null) {
            return false;
        }
        int shownTodayCount = this.getIntFromPrefs("istc_inapp", 0);
        if (shownTodayCount >= (maxPerDayCount = this.getIntFromPrefs("istmcd_inapp", 1))) {
            return true;
        }
        try {
            int maxPerDay = inapp.getTotalDailyCount();
            if (maxPerDay == -1) {
                return false;
            }
            int[] counts = this.getInAppCountsFromPersistentStore(id2);
            if (counts[0] >= maxPerDay) {
                return true;
            }
        }
        catch (Throwable t) {
            return true;
        }
        return false;
    }

    synchronized void updateLimits(Context context, int perDay, int perSession) {
        StorageHelper.putInt(context, this.storageKeyWithSuffix("istmcd_inapp"), perDay);
        StorageHelper.putInt(context, this.storageKeyWithSuffix("imc"), perSession);
    }

    private void incrementInAppCountsInPersistentStore(String inappID) {
        int[] current = this.getInAppCountsFromPersistentStore(inappID);
        current[0] = current[0] + 1;
        current[1] = current[1] + 1;
        SharedPreferences prefs = StorageHelper.getPreferences(this.context, "counts_per_inapp");
        SharedPreferences.Editor editor = prefs.edit();
        editor.putString(inappID, current[0] + "," + current[1]);
        StorageHelper.persist(editor);
    }

    private int[] getInAppCountsFromPersistentStore(String inappID) {
        SharedPreferences prefs = StorageHelper.getPreferences(this.context, "counts_per_inapp");
        String str = prefs.getString(inappID, null);
        if (str == null) {
            return new int[]{0, 0};
        }
        try {
            String[] parts = str.split(",");
            if (parts.length != 2) {
                return new int[]{0, 0};
            }
            return new int[]{Integer.parseInt(parts[0]), Integer.parseInt(parts[1])};
        }
        catch (Throwable t) {
            return new int[]{0, 0};
        }
    }

    void attachToHeader(Context context, JSONObject header) {
        try {
            header.put("imp", this.getIntFromPrefs("istc_inapp", 0));
            JSONArray arr = new JSONArray();
            SharedPreferences prefs = StorageHelper.getPreferences(context, "counts_per_inapp");
            Map all = prefs.getAll();
            for (String inapp : all.keySet()) {
                String[] parts;
                Object o = all.get(inapp);
                if (!(o instanceof String) || (parts = ((String)o).split(",")).length != 2) continue;
                JSONArray a = new JSONArray();
                a.put(0, (Object)inapp);
                a.put(1, Integer.parseInt(parts[0]));
                a.put(2, Integer.parseInt(parts[1]));
                arr.put((Object)a);
            }
            header.put("tlc", (Object)arr);
        }
        catch (Throwable t) {
            Logger.v("Failed to attach FC to header", t);
        }
    }

    void processResponse(Context context, JSONObject response) {
        try {
            if (!response.has("inapp_stale")) {
                return;
            }
            JSONArray arr = response.getJSONArray("inapp_stale");
            SharedPreferences prefs = StorageHelper.getPreferences(context, "counts_per_inapp");
            SharedPreferences.Editor editor = prefs.edit();
            for (int i = 0; i < arr.length(); ++i) {
                Object o = arr.get(i);
                if (o instanceof Integer) {
                    editor.remove("" + o);
                    Logger.d("Purged stale in-app - " + o);
                    continue;
                }
                if (!(o instanceof String)) continue;
                editor.remove((String)o);
                Logger.d("Purged stale in-app - " + o);
            }
            StorageHelper.persist(editor);
        }
        catch (Throwable t) {
            Logger.v("Failed to purge out stale targets", t);
        }
    }

    void changeUser(Context context) {
        StorageHelper.putInt(context, "istc_inapp", 0);
        this.mShownThisSession.clear();
        this.mShownThisSessionCount = 0;
        this.mDismissedThisSession.clear();
        SharedPreferences prefs = StorageHelper.getPreferences(context, "counts_per_inapp");
        SharedPreferences.Editor editor = prefs.edit();
        editor.clear();
        StorageHelper.persist(editor);
    }

    private String getStringFromPrefs(String rawKey, String defaultValue) {
        if (this.config.isDefaultInstance()) {
            String _new = StorageHelper.getString(this.context, this.storageKeyWithSuffix(rawKey), defaultValue);
            return _new != null ? _new : StorageHelper.getString(this.context, rawKey, defaultValue);
        }
        return StorageHelper.getString(this.context, this.storageKeyWithSuffix(rawKey), defaultValue);
    }

    private int getIntFromPrefs(String rawKey, int defaultValue) {
        if (this.config.isDefaultInstance()) {
            int dummy = -1000;
            int _new = StorageHelper.getInt(this.context, this.storageKeyWithSuffix(rawKey), dummy);
            return _new != dummy ? _new : StorageHelper.getInt(this.context, rawKey, defaultValue);
        }
        return StorageHelper.getInt(this.context, this.storageKeyWithSuffix(rawKey), defaultValue);
    }

    private String storageKeyWithSuffix(String key) {
        return key + ":" + this.getConfigAccountId();
    }
}

