/*
 * Decompiled with CFR 0.152.
 */
package com.clevertap.android.sdk;

import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import com.clevertap.android.sdk.CTInAppType;
import com.clevertap.android.sdk.Logger;
import java.util.Iterator;
import org.json.JSONException;
import org.json.JSONObject;

class CTInAppNotification
implements Parcelable {
    private String id;
    private String campaignId;
    private CTInAppType inAppType;
    private String html;
    private boolean excludeFromCaps;
    private boolean showClose;
    private boolean darkenScreen;
    private int maxPerSession;
    private int totalLifetimeCount;
    private int totalDailyCount;
    private char position;
    private int height;
    private int heightPercentage;
    private int width;
    private int widthPercentage;
    private JSONObject jsonDescription;
    private String error;
    private JSONObject customExtras;
    private JSONObject actionExtras;
    CTInAppNotificationListener listener;
    public static final Parcelable.Creator<CTInAppNotification> CREATOR = new Parcelable.Creator<CTInAppNotification>(){

        public CTInAppNotification createFromParcel(Parcel in) {
            return new CTInAppNotification(in);
        }

        public CTInAppNotification[] newArray(int size) {
            return new CTInAppNotification[size];
        }
    };

    CTInAppNotification() {
    }

    CTInAppNotification initWithJSON(JSONObject jsonObject) {
        this.jsonDescription = jsonObject;
        Bundle b = CTInAppNotification.getBundleFromJsonObject(jsonObject);
        if (!this.validateNotifBundle(b)) {
            this.error = "Invalid JSON";
            return this;
        }
        try {
            JSONObject data;
            this.id = jsonObject.has("ti") ? jsonObject.getString("ti") : "";
            this.campaignId = jsonObject.has("wzrk_id") ? jsonObject.getString("wzrk_id") : "";
            this.excludeFromCaps = jsonObject.has("efc") && jsonObject.getInt("efc") == 1;
            this.totalLifetimeCount = jsonObject.has("tlc") ? jsonObject.getInt("tlc") : -1;
            this.totalDailyCount = jsonObject.has("tdc") ? jsonObject.getInt("tdc") : -1;
            JSONObject jSONObject = data = jsonObject.has("d") ? jsonObject.getJSONObject("d") : null;
            if (data != null) {
                JSONObject displayParams;
                this.html = data.getString("html");
                JSONObject jSONObject2 = this.customExtras = data.has("kv") ? data.getJSONObject("kv") : null;
                if (this.customExtras == null) {
                    this.customExtras = new JSONObject();
                }
                if ((displayParams = jsonObject.getJSONObject("w")) != null) {
                    this.darkenScreen = displayParams.getBoolean("dk");
                    this.showClose = displayParams.getBoolean("sc");
                    this.position = displayParams.getString("pos").charAt(0);
                    this.width = displayParams.has("xdp") ? displayParams.getInt("xdp") : 0;
                    this.widthPercentage = displayParams.has("xp") ? displayParams.getInt("xp") : 0;
                    this.height = displayParams.has("ydp") ? displayParams.getInt("ydp") : 0;
                    this.heightPercentage = displayParams.has("yp") ? displayParams.getInt("yp") : 0;
                    int n = this.maxPerSession = displayParams.has("mdc") ? displayParams.getInt("mdc") : -1;
                }
                if (this.html != null) {
                    if (this.position == 't' && this.widthPercentage == 100 && this.heightPercentage == 30) {
                        this.inAppType = CTInAppType.CTInAppTypeHeaderHTML;
                    } else if (this.position == 'b' && this.widthPercentage == 100 && this.heightPercentage == 30) {
                        this.inAppType = CTInAppType.CTInAppTypeFooterHTML;
                    } else if (this.position == 'c' && this.widthPercentage == 90 && this.heightPercentage == 85) {
                        this.inAppType = CTInAppType.CTInAppTypeInterstitialHTML;
                    } else if (this.position == 'c' && this.widthPercentage == 100 && this.heightPercentage == 100) {
                        this.inAppType = CTInAppType.CTInAppTypeCoverHTML;
                    } else if (this.position == 'c' && this.widthPercentage == 90 && this.heightPercentage == 50) {
                        this.inAppType = CTInAppType.CTInAppTypeHalfInterstitialHTML;
                    }
                }
            }
        }
        catch (JSONException e) {
            this.error = "Invalid JSON";
        }
        return this;
    }

    void prepareForDisplay() {
        this.listener.notificationReady(this);
    }

    private boolean validateNotifBundle(Bundle notif) {
        try {
            Bundle w = notif.getBundle("w");
            Bundle d = notif.getBundle("d");
            if (w == null || d == null) {
                return false;
            }
            if (!this.isKeyValid(w, "xdp", Integer.class) && !this.isKeyValid(w, "xp", Integer.class)) {
                return false;
            }
            if (!this.isKeyValid(w, "ydp", Integer.class) && !this.isKeyValid(w, "yp", Integer.class)) {
                return false;
            }
            if (!this.isKeyValid(w, "dk", Boolean.class)) {
                return false;
            }
            if (!this.isKeyValid(w, "sc", Boolean.class)) {
                return false;
            }
            if (!this.isKeyValid(d, "html", String.class)) {
                return false;
            }
            if (this.isKeyValid(w, "pos", String.class)) {
                char pos = w.getString("pos").charAt(0);
                switch (pos) {
                    case 't': {
                        break;
                    }
                    case 'r': {
                        break;
                    }
                    case 'b': {
                        break;
                    }
                    case 'l': {
                        break;
                    }
                    case 'c': {
                        break;
                    }
                    default: {
                        return false;
                    }
                }
            } else {
                return false;
            }
            return true;
        }
        catch (Throwable t) {
            Logger.v("Failed to parse in-app notification!", t);
            return false;
        }
    }

    private boolean isKeyValid(Bundle b, String key, Class<?> type) {
        return b.containsKey(key) && b.get(key).getClass().equals(type);
    }

    private static Bundle getBundleFromJsonObject(JSONObject notif) {
        Bundle b = new Bundle();
        Iterator iterator = notif.keys();
        while (iterator.hasNext()) {
            String key = (String)iterator.next();
            try {
                Object value = notif.get(key);
                if (value instanceof String) {
                    b.putString(key, (String)value);
                    continue;
                }
                if (value instanceof Character) {
                    b.putChar(key, ((Character)value).charValue());
                    continue;
                }
                if (value instanceof Integer) {
                    b.putInt(key, ((Integer)value).intValue());
                    continue;
                }
                if (value instanceof Float) {
                    b.putFloat(key, ((Float)value).floatValue());
                    continue;
                }
                if (value instanceof Double) {
                    b.putDouble(key, ((Double)value).doubleValue());
                    continue;
                }
                if (value instanceof Long) {
                    b.putLong(key, ((Long)value).longValue());
                    continue;
                }
                if (value instanceof Boolean) {
                    b.putBoolean(key, ((Boolean)value).booleanValue());
                    continue;
                }
                if (!(value instanceof JSONObject)) continue;
                b.putBundle(key, CTInAppNotification.getBundleFromJsonObject((JSONObject)value));
            }
            catch (JSONException e) {
                Logger.v("Key had unknown object. Discarding");
            }
        }
        return b;
    }

    public String getId() {
        return this.id;
    }

    public String getCampaignId() {
        return this.campaignId;
    }

    public CTInAppType getInAppType() {
        return this.inAppType;
    }

    public String getHtml() {
        return this.html;
    }

    public boolean isExcludeFromCaps() {
        return this.excludeFromCaps;
    }

    public boolean isShowClose() {
        return this.showClose;
    }

    public boolean isDarkenScreen() {
        return this.darkenScreen;
    }

    public int getMaxPerSession() {
        return this.maxPerSession;
    }

    public int getTotalLifetimeCount() {
        return this.totalLifetimeCount;
    }

    public int getTotalDailyCount() {
        return this.totalDailyCount;
    }

    public char getPosition() {
        return this.position;
    }

    public int getHeight() {
        return this.height;
    }

    public int getHeightPercentage() {
        return this.heightPercentage;
    }

    public int getWidth() {
        return this.width;
    }

    public int getWidthPercentage() {
        return this.widthPercentage;
    }

    public JSONObject getJsonDescription() {
        return this.jsonDescription;
    }

    public String getError() {
        return this.error;
    }

    public JSONObject getCustomExtras() {
        return this.customExtras;
    }

    public JSONObject getActionExtras() {
        return this.actionExtras;
    }

    private CTInAppNotification(Parcel in) {
        try {
            this.id = in.readString();
            this.campaignId = in.readString();
            this.inAppType = (CTInAppType)((Object)in.readValue(CTInAppType.class.getClassLoader()));
            this.html = in.readString();
            this.excludeFromCaps = in.readByte() != 0;
            this.showClose = in.readByte() != 0;
            this.darkenScreen = in.readByte() != 0;
            this.maxPerSession = in.readInt();
            this.totalLifetimeCount = in.readInt();
            this.totalDailyCount = in.readInt();
            this.position = ((Character)in.readValue(Character.TYPE.getClassLoader())).charValue();
            this.height = in.readInt();
            this.heightPercentage = in.readInt();
            this.width = in.readInt();
            this.widthPercentage = in.readInt();
            this.jsonDescription = in.readByte() == 0 ? null : new JSONObject(in.readString());
            this.error = in.readString();
            this.customExtras = in.readByte() == 0 ? null : new JSONObject(in.readString());
            this.actionExtras = in.readByte() == 0 ? null : new JSONObject(in.readString());
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeString(this.id);
        dest.writeString(this.campaignId);
        dest.writeValue((Object)this.inAppType);
        dest.writeString(this.html);
        dest.writeByte((byte)(this.excludeFromCaps ? 1 : 0));
        dest.writeByte((byte)(this.showClose ? 1 : 0));
        dest.writeByte((byte)(this.darkenScreen ? 1 : 0));
        dest.writeInt(this.maxPerSession);
        dest.writeInt(this.totalLifetimeCount);
        dest.writeInt(this.totalDailyCount);
        dest.writeValue((Object)Character.valueOf(this.position));
        dest.writeInt(this.height);
        dest.writeInt(this.heightPercentage);
        dest.writeInt(this.width);
        dest.writeInt(this.widthPercentage);
        if (this.jsonDescription == null) {
            dest.writeByte((byte)0);
        } else {
            dest.writeByte((byte)1);
            dest.writeString(this.jsonDescription.toString());
        }
        dest.writeString(this.error);
        if (this.customExtras == null) {
            dest.writeByte((byte)0);
        } else {
            dest.writeByte((byte)1);
            dest.writeString(this.customExtras.toString());
        }
        if (this.actionExtras == null) {
            dest.writeByte((byte)0);
        } else {
            dest.writeByte((byte)1);
            dest.writeString(this.actionExtras.toString());
        }
    }

    static interface CTInAppNotificationListener {
        public void notificationReady(CTInAppNotification var1);
    }
}

