/*
 * Decompiled with CFR 0.152.
 */
package com.clevertap.android.sdk;

import android.annotation.SuppressLint;
import android.bluetooth.BluetoothAdapter;
import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.os.Build;
import android.support.v4.content.ContextCompat;
import android.telephony.TelephonyManager;
import com.clevertap.android.sdk.CleverTapAPI;
import com.clevertap.android.sdk.Logger;
import com.clevertap.android.sdk.ManifestMetaData;
import com.clevertap.android.sdk.PushType;
import com.clevertap.android.sdk.StorageHelper;
import com.clevertap.android.sdk.ValidationResult;
import com.clevertap.android.sdk.Validator;
import com.clevertap.android.sdk.exceptions.CleverTapPermissionsNotSatisfied;
import com.google.android.gms.ads.identifier.AdvertisingIdClient;
import com.google.android.gms.common.GoogleApiAvailability;
import java.util.ArrayList;
import java.util.UUID;

final class DeviceInfo {
    private static final String GUID_PREFIX = "__";
    private static String provisionalGUID = null;
    private static final Object deviceIDLock = new Object();
    private static final Object adIDLock = new Object();
    private static Context context = null;
    private static String googleAdID = null;
    private static boolean limitAdTracking = false;
    private static ArrayList<PushType> enabledPushTypes = null;
    private static String GCMSenderID = null;
    private static Boolean isFirebasePresent = null;
    private static Boolean areGoogleServicesAvailable = null;
    private static final String FIREBASE_CLASS_NAME = "com.google.firebase.messaging.FirebaseMessaging";

    DeviceInfo() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static String getGoogleAdID() {
        Object object = adIDLock;
        synchronized (object) {
            return googleAdID;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static boolean isLimitAdTrackingEnabled() {
        Object object = adIDLock;
        synchronized (object) {
            return limitAdTracking;
        }
    }

    static void initializeWithContext(Context context) {
        DeviceInfo.context = context;
        DeviceInfo.initDeviceIDAsync();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void generateProvisionalGUID() {
        Object object = deviceIDLock;
        synchronized (object) {
            if (provisionalGUID == null) {
                provisionalGUID = DeviceInfo.generateGUID();
            }
        }
    }

    private static boolean useGoogleAdID() {
        return "1".equals(ManifestMetaData.getMetaData(context, "CLEVERTAP_USE_GOOGLE_AD_ID"));
    }

    private static void initDeviceIDAsync() {
        DeviceInfo.generateProvisionalGUID();
        CleverTapAPI.postAsyncSafely("DeviceInfo#generateDeviceID", new Runnable(){

            @Override
            public void run() {
                DeviceInfo.cacheGoogleAdID();
                String deviceID = DeviceInfo.getDeviceID();
                if (deviceID != null && deviceID.trim().length() > 2) {
                    DeviceInfo.notifyNewDeviceID(deviceID);
                } else {
                    DeviceInfo.generateDeviceID();
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void cacheGoogleAdID() {
        if (DeviceInfo.useGoogleAdID()) {
            String advertisingID;
            try {
                AdvertisingIdClient.Info adInfo = AdvertisingIdClient.getAdvertisingIdInfo((Context)context);
                Object object = adIDLock;
                synchronized (object) {
                    limitAdTracking = adInfo.isLimitAdTrackingEnabled();
                    if (limitAdTracking) {
                        return;
                    }
                }
                advertisingID = adInfo.getId();
            }
            catch (Throwable t) {
                advertisingID = null;
            }
            if (advertisingID != null && advertisingID.trim().length() > 2) {
                Object object = adIDLock;
                synchronized (object) {
                    googleAdID = advertisingID.replace("-", "");
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void generateDeviceID() {
        String generatedDeviceID;
        if (googleAdID != null) {
            Object object = adIDLock;
            synchronized (object) {
                generatedDeviceID = "__g" + googleAdID;
            }
        }
        Logger.v("Failed with Advertising ID");
        Object object = deviceIDLock;
        synchronized (object) {
            generatedDeviceID = provisionalGUID;
            Logger.v("Made provisional ID permanent");
        }
        if (generatedDeviceID != null && generatedDeviceID.trim().length() > 2) {
            DeviceInfo.forceUpdateDeviceId(generatedDeviceID);
        } else {
            Logger.v("Unable to generate device ID");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static String getAttributionID() {
        String deviceID = DeviceInfo.getDeviceID();
        Object object = deviceIDLock;
        synchronized (object) {
            return deviceID != null && deviceID.trim().length() > 2 ? deviceID : provisionalGUID;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static String getDeviceID() {
        Object object = deviceIDLock;
        synchronized (object) {
            return StorageHelper.getString(context, "deviceId", null);
        }
    }

    private static void notifyNewDeviceID(final String deviceID) {
        CleverTapAPI.postAsyncSafely("DeviceInfo#notifyNewDeviceID", new Runnable(){

            @Override
            public void run() {
                try {
                    CleverTapAPI.notifyUserProfileInitialized(deviceID);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        });
    }

    private static String generateGUID() {
        return GUID_PREFIX + UUID.randomUUID().toString().replace("-", "");
    }

    static void forceNewDeviceID() {
        String deviceID = DeviceInfo.generateGUID();
        DeviceInfo.forceUpdateDeviceId(deviceID);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SuppressLint(value={"CommitPrefEdits"})
    static void forceUpdateDeviceId(String id) {
        Logger.v("Force updating the device ID to " + id);
        Object object = deviceIDLock;
        synchronized (object) {
            StorageHelper.putString(context, "deviceId", id);
        }
        DeviceInfo.notifyNewDeviceID(id);
    }

    static void testPermission(Context context, String permission2) throws CleverTapPermissionsNotSatisfied {
        if (!DeviceInfo.hasPermission(context, permission2)) {
            throw new CleverTapPermissionsNotSatisfied("Permission required: " + permission2);
        }
        Logger.v("Permissions added");
    }

    static boolean hasPermission(Context context, String permission2) {
        try {
            return 0 == ContextCompat.checkSelfPermission((Context)context, (String)permission2);
        }
        catch (Throwable t) {
            return false;
        }
    }

    static int getAppIconAsIntId(Context context) {
        ApplicationInfo ai = context.getApplicationInfo();
        return ai.icon;
    }

    private static boolean isGCMAvailable() {
        return DeviceInfo.isGooglePlayServicesAvailable() && DeviceInfo.getGCMSenderID() != null;
    }

    private static boolean isFCMAvailable() {
        if (isFirebasePresent == null) {
            try {
                Class.forName(FIREBASE_CLASS_NAME);
                isFirebasePresent = true;
                Logger.v("FCM installed");
            }
            catch (ClassNotFoundException e) {
                isFirebasePresent = false;
                Logger.v("FCM unavailable");
            }
        }
        return DeviceInfo.isGooglePlayServicesAvailable() && isFirebasePresent != false;
    }

    static ArrayList<PushType> getEnabledPushTypes() {
        if (enabledPushTypes == null) {
            enabledPushTypes = new ArrayList();
            boolean fcmAvail = DeviceInfo.isFCMAvailable();
            if (fcmAvail) {
                enabledPushTypes.add(PushType.FCM);
            }
            if (!fcmAvail && DeviceInfo.isGCMAvailable()) {
                enabledPushTypes.add(PushType.GCM);
            }
        }
        return enabledPushTypes;
    }

    static boolean isGooglePlayServicesAvailable() {
        if (areGoogleServicesAvailable == null) {
            try {
                GoogleApiAvailability googleAPI = GoogleApiAvailability.getInstance();
                int result = googleAPI.isGooglePlayServicesAvailable(context);
                areGoogleServicesAvailable = result == 0;
                if (areGoogleServicesAvailable.booleanValue()) {
                    Logger.v("Google Play services availabile");
                } else {
                    Logger.d("Google Play services not available");
                }
            }
            catch (Throwable t) {
                Logger.d("Error checking Google Play services availability", t);
                areGoogleServicesAvailable = false;
            }
        }
        return areGoogleServicesAvailable;
    }

    static String getGCMSenderID() {
        if (GCMSenderID == null) {
            String senderID = null;
            try {
                senderID = ManifestMetaData.getMetaData(context, "GCM_SENDER_ID");
                if (senderID != null) {
                    senderID = senderID.replace("id:", "");
                } else {
                    Logger.v("GCM sender ID not found");
                }
            }
            catch (Throwable t) {
                Logger.v("Error retrieving GCM sender ID", t);
            }
            GCMSenderID = senderID;
        }
        return GCMSenderID;
    }

    static String getCarrier() {
        try {
            TelephonyManager tm = (TelephonyManager)context.getSystemService("phone");
            String carrier = tm.getSimOperatorName();
            ValidationResult vr = Validator.cleanObjectValue(carrier, Validator.ValidationContext.Profile);
            if (vr.getErrorCode() == 0) {
                return (String)vr.getObject();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return "";
    }

    static String getCountryCode() {
        try {
            TelephonyManager tm = (TelephonyManager)context.getSystemService("phone");
            return tm.getSimCountryIso();
        }
        catch (Throwable ignore) {
            return "";
        }
    }

    static Boolean isWifiConnected() {
        Boolean ret = null;
        if (0 == context.checkCallingOrSelfPermission("android.permission.ACCESS_NETWORK_STATE")) {
            ConnectivityManager connManager = (ConnectivityManager)context.getSystemService("connectivity");
            NetworkInfo networkInfo = connManager.getActiveNetworkInfo();
            ret = networkInfo != null && networkInfo.getType() == 1 && networkInfo.isConnected();
        }
        return ret;
    }

    @SuppressLint(value={"MissingPermission"})
    static Boolean isBluetoothEnabled() {
        Boolean isBluetoothEnabled = null;
        try {
            BluetoothAdapter bluetoothAdapter;
            PackageManager pm = context.getPackageManager();
            int hasBluetoothPermission = pm.checkPermission("android.permission.BLUETOOTH", context.getPackageName());
            if (hasBluetoothPermission == 0 && (bluetoothAdapter = BluetoothAdapter.getDefaultAdapter()) != null) {
                isBluetoothEnabled = bluetoothAdapter.isEnabled();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return isBluetoothEnabled;
    }

    static String getBluetoothVersion() {
        String bluetoothVersion = null;
        if (Build.VERSION.SDK_INT >= 8) {
            bluetoothVersion = "none";
            if (Build.VERSION.SDK_INT >= 18 && context.getPackageManager().hasSystemFeature("android.hardware.bluetooth_le")) {
                bluetoothVersion = "ble";
            } else if (context.getPackageManager().hasSystemFeature("android.hardware.bluetooth")) {
                bluetoothVersion = "classic";
            }
        }
        return bluetoothVersion;
    }

    static String getNetworkType() {
        TelephonyManager mTelephonyManager = (TelephonyManager)context.getSystemService("phone");
        int networkType = mTelephonyManager.getNetworkType();
        switch (networkType) {
            case 1: 
            case 2: 
            case 4: 
            case 7: 
            case 11: {
                return "2G";
            }
            case 3: 
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 14: 
            case 15: {
                return "3G";
            }
            case 13: {
                return "4G";
            }
        }
        return null;
    }
}

