/*
 * Decompiled with CFR 0.152.
 */
package com.clevertap.android.sdk;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.app.Notification;
import android.app.NotificationChannel;
import android.app.NotificationChannelGroup;
import android.app.NotificationManager;
import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.content.SharedPreferences;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.graphics.Bitmap;
import android.location.Location;
import android.location.LocationManager;
import android.media.RingtoneManager;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.support.v4.app.NotificationCompat;
import com.clevertap.android.sdk.BuildInfo;
import com.clevertap.android.sdk.CTNotificationIntentService;
import com.clevertap.android.sdk.CTPushNotificationReceiver;
import com.clevertap.android.sdk.CommsManager;
import com.clevertap.android.sdk.Constants;
import com.clevertap.android.sdk.DataHandler;
import com.clevertap.android.sdk.DeviceInfo;
import com.clevertap.android.sdk.EventHandler;
import com.clevertap.android.sdk.FcmManager;
import com.clevertap.android.sdk.GcmManager;
import com.clevertap.android.sdk.InAppFCManager;
import com.clevertap.android.sdk.InAppManager;
import com.clevertap.android.sdk.InAppNotificationListener;
import com.clevertap.android.sdk.LocalDataStore;
import com.clevertap.android.sdk.Logger;
import com.clevertap.android.sdk.ManifestMetaData;
import com.clevertap.android.sdk.ManifestValidator;
import com.clevertap.android.sdk.NotificationInfo;
import com.clevertap.android.sdk.ProfileHandler;
import com.clevertap.android.sdk.PushType;
import com.clevertap.android.sdk.QueueManager;
import com.clevertap.android.sdk.SessionHandler;
import com.clevertap.android.sdk.SessionManager;
import com.clevertap.android.sdk.StorageHelper;
import com.clevertap.android.sdk.SyncListener;
import com.clevertap.android.sdk.UriHelper;
import com.clevertap.android.sdk.Utils;
import com.clevertap.android.sdk.ValidationResult;
import com.clevertap.android.sdk.exceptions.CleverTapMetaDataNotFoundException;
import com.clevertap.android.sdk.exceptions.CleverTapPermissionsNotSatisfied;
import java.lang.ref.WeakReference;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public final class CleverTapAPI {
    public static final String CHARGED_EVENT = "Charged";
    public static final String NOTIFICATION_TAG = "wzrk_pn";
    private static final String CACHED_GUIDS_KEY = "cachedGUIDsKey";
    private static final String MULTI_USER_PREFIX = "mt_";
    private static final Handler handlerUsingMainLooper = new Handler(Looper.getMainLooper());
    private static final ExecutorService es = Executors.newFixedThreadPool(1);
    private static int debugLevel = LogLevel.INFO.intValue();
    private static boolean appForeground = false;
    private static CleverTapAPI ourInstance = null;
    static Runnable pendingInappRunnable = null;
    private static int lastLocationPingTime = 0;
    private InAppNotificationListener inAppNotificationListener;
    static int activityCount = 0;
    private static ArrayList<ValidationResult> pendingValidationResults = new ArrayList();
    private static final Boolean pendingValidationResultsLock = true;
    private static String parseInstallationId = null;
    private static boolean appLaunchPushed = false;
    private static final Object appLaunchPushedLock = new Object();
    private static final int EMPTY_NOTIFICATION_ID = -1000;
    static String localAccountID = null;
    static String localToken = null;
    static String localRegion = null;
    private static WeakReference<Activity> currentActivity;
    public final EventHandler event;
    public final DataHandler data;
    public final ProfileHandler profile;
    public final SessionHandler session;
    private Runnable sessionTimeoutRunnable = null;
    private final Context context;
    private long appLastSeen;
    private SyncListener syncListener = null;
    private Location locationFromUser = null;
    private static long EXECUTOR_THREAD_ID;
    private static String processingUserLoginIdentifier;
    private static final Boolean processingUserLoginLock;
    private static HashSet<String> inappActivityExclude;
    private static ArrayList<PushType> enabledPushTypes;
    private static final HashMap<String, Integer> installReferrerMap;
    private DevicePushTokenRefreshListener tokenRefreshListener;

    static String getAccountID(Context context) {
        if (localAccountID == null) {
            localAccountID = ManifestMetaData.getMetaData(context, "CLEVERTAP_ACCOUNT_ID");
        }
        return localAccountID;
    }

    static String getAccountToken(Context context) {
        if (localToken == null) {
            localToken = ManifestMetaData.getMetaData(context, "CLEVERTAP_TOKEN");
        }
        return localToken;
    }

    static String getAccountRegion(Context context) {
        if (localRegion == null) {
            localRegion = ManifestMetaData.getMetaData(context, "CLEVERTAP_REGION");
        }
        return localRegion;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static boolean isAppLaunchPushed() {
        Object object = appLaunchPushedLock;
        synchronized (object) {
            return appLaunchPushed;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void setAppLaunchPushed(boolean pushed) {
        Object object = appLaunchPushedLock;
        synchronized (object) {
            appLaunchPushed = pushed;
        }
    }

    static Activity getCurrentActivity() {
        return currentActivity == null ? null : (Activity)currentActivity.get();
    }

    static void setCurrentActivity(Activity activity) {
        currentActivity = activity == null ? null : new WeakReference<Activity>(activity);
    }

    static String getCurrentActivityName() {
        Activity current = CleverTapAPI.getCurrentActivity();
        return current != null ? current.getLocalClassName() : null;
    }

    static String getParseInstallationId() {
        return parseInstallationId;
    }

    private static String getGoogleAdID() {
        return DeviceInfo.getGoogleAdID();
    }

    private static boolean isLimitAdTrackingEnabled() {
        return DeviceInfo.isLimitAdTrackingEnabled();
    }

    Context getContext() {
        return this.context;
    }

    public void setInAppNotificationListener(InAppNotificationListener inAppNotificationListener) {
        this.inAppNotificationListener = inAppNotificationListener;
    }

    public InAppNotificationListener getInAppNotificationListener() {
        return this.inAppNotificationListener;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static ValidationResult popValidationResult() {
        ValidationResult vr = null;
        Boolean bl = pendingValidationResultsLock;
        synchronized (bl) {
            try {
                if (!pendingValidationResults.isEmpty()) {
                    vr = pendingValidationResults.remove(0);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return vr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void pushValidationResult(ValidationResult vr) {
        Boolean bl = pendingValidationResultsLock;
        synchronized (bl) {
            try {
                int len = pendingValidationResults.size();
                if (len > 50) {
                    ArrayList<ValidationResult> trimmed = new ArrayList<ValidationResult>();
                    for (int i = 10; i < len; ++i) {
                        trimmed.add(pendingValidationResults.get(i));
                    }
                    trimmed.add(vr);
                    pendingValidationResults = trimmed;
                } else {
                    pendingValidationResults.add(vr);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    static Handler getHandlerUsingMainLooper() {
        return handlerUsingMainLooper;
    }

    static void postAsyncSafely(String name, final Runnable runnable) {
        try {
            boolean executeSync;
            boolean bl = executeSync = Thread.currentThread().getId() == EXECUTOR_THREAD_ID;
            if (executeSync) {
                runnable.run();
            } else {
                es.submit(new Runnable(){

                    @Override
                    public void run() {
                        EXECUTOR_THREAD_ID = Thread.currentThread().getId();
                        try {
                            runnable.run();
                        }
                        catch (Throwable t) {
                            Logger.v("Executor service: Failed to complete the scheduled task", t);
                        }
                    }
                });
            }
        }
        catch (Throwable t) {
            Logger.v("Failed to submit task to the executor service", t);
        }
    }

    static boolean isAppForeground() {
        return appForeground;
    }

    public static void setAppForeground(boolean appForeground) {
        CleverTapAPI.appForeground = appForeground;
    }

    public void setSyncListener(SyncListener syncListener) {
        this.syncListener = syncListener;
    }

    public SyncListener getSyncListener() {
        return this.syncListener;
    }

    public static void changeCredentials(String accountID, String token) {
        CleverTapAPI.changeCredentials(accountID, token, null);
    }

    public static void changeCredentials(String accountID, String token, String region) {
        if (localAccountID != null && localToken != null) {
            Logger.i("CleverTap SDK already initialized with accountID: " + localAccountID + " accountToken: " + localToken + ". Subsequent call to changeCredentials is ignored");
            return;
        }
        if (accountID != null && accountID.trim().length() > 0) {
            localAccountID = accountID;
        }
        if (token != null && token.trim().length() > 0) {
            localToken = token;
        }
        if (region != null && region.trim().length() > 0) {
            localRegion = region;
        }
    }

    public static synchronized CleverTapAPI getInstance(Context context) throws CleverTapMetaDataNotFoundException, CleverTapPermissionsNotSatisfied {
        if (ourInstance == null && context != null) {
            LocalDataStore.initializeWithContext(context);
            DeviceInfo.initializeWithContext(context);
            ourInstance = new CleverTapAPI(context.getApplicationContext());
        }
        return ourInstance;
    }

    private SharedPreferences getPreferences(Context context) {
        return StorageHelper.getPreferences(context);
    }

    private void testPermissions(Context context) throws CleverTapPermissionsNotSatisfied {
        DeviceInfo.testPermission(context, "android.permission.INTERNET");
    }

    private CleverTapAPI(Context context) throws CleverTapMetaDataNotFoundException, CleverTapPermissionsNotSatisfied {
        this.context = context;
        this.event = new EventHandler(context);
        this.profile = new ProfileHandler(context);
        this.data = new DataHandler(context);
        this.session = new SessionHandler(context);
        String accountID = CleverTapAPI.getAccountID(context);
        if (accountID == null) {
            Logger.i("CleverTap SDK cannot be initialized: accountID is missing");
            throw new CleverTapMetaDataNotFoundException("CleverTap accountID is missing");
        }
        String accountToken = CleverTapAPI.getAccountToken(context);
        if (accountToken == null) {
            Logger.i("CleverTap SDK cannot be initialized: account Token is missing");
            throw new CleverTapMetaDataNotFoundException("CleverTap account Token is missing");
        }
        this.testPermissions(context);
        String accountRegion = CleverTapAPI.getAccountRegion(context);
        if (accountRegion == null) {
            accountRegion = "Default";
        }
        Logger.i("CleverTap SDK initialized with accountId: " + accountID + " accountToken: " + accountToken + " accountRegion: " + accountRegion);
        this.manifestAsyncValidation();
    }

    private void manifestAsyncValidation() {
        CleverTapAPI.postAsyncSafely("Manifest Validation", new Runnable(){

            @Override
            public void run() {
                ManifestValidator.validate(CleverTapAPI.this.context);
            }
        });
    }

    private JSONObject getCachedGUIDs() {
        JSONObject cache = null;
        String json = StorageHelper.getString(this.context, CACHED_GUIDS_KEY, null);
        if (json != null) {
            try {
                cache = new JSONObject(json);
            }
            catch (Throwable t) {
                Logger.v("Error reading guid cache: " + t.toString());
            }
        }
        return cache != null ? cache : new JSONObject();
    }

    private void setCachedGUIDs(JSONObject cachedGUIDs) {
        if (cachedGUIDs == null) {
            return;
        }
        try {
            StorageHelper.putString(this.context, CACHED_GUIDS_KEY, cachedGUIDs.toString());
        }
        catch (Throwable t) {
            Logger.v("Error persisting guid cache: " + t.toString());
        }
    }

    private String getGUIDForIdentifier(String key, String identifier) {
        if (key == null || identifier == null) {
            return null;
        }
        String cacheKey = key + "_" + identifier;
        JSONObject cache = this.getCachedGUIDs();
        try {
            return cache.getString(cacheKey);
        }
        catch (Throwable t) {
            Logger.v("Error reading guid cache: " + t.toString());
            return null;
        }
    }

    void cacheGUIDForIdentifier(String guid, String key, String identifier) {
        if (guid == null || key == null || identifier == null) {
            return;
        }
        String cacheKey = key + "_" + identifier;
        JSONObject cache = this.getCachedGUIDs();
        try {
            cache.put(cacheKey, (Object)guid);
            this.setCachedGUIDs(cache);
        }
        catch (Throwable t) {
            Logger.v("Error caching guid: " + t.toString());
        }
    }

    private boolean isAnonymousDevice() {
        JSONObject cachedGUIDs = this.getCachedGUIDs();
        return cachedGUIDs.length() <= 0;
    }

    private boolean deviceIsMultiUser() {
        JSONObject cachedGUIDs = this.getCachedGUIDs();
        return cachedGUIDs.length() > 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isProcessUserLoginWithIdentifier(String identifier) {
        Boolean bl = processingUserLoginLock;
        synchronized (bl) {
            return processingUserLoginIdentifier != null && processingUserLoginIdentifier.equals(identifier);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onUserLogin(final Map<String, Object> profile) {
        if (profile == null) {
            return;
        }
        try {
            String currentGUID = this.getCleverTapID();
            if (currentGUID == null) {
                return;
            }
            boolean haveIdentifier = false;
            String cachedGUID = null;
            for (String string : profile.keySet()) {
                Object value = profile.get(string);
                if (!Constants.PROFILE_IDENTIFIER_KEYS.contains(string)) continue;
                try {
                    String identifier = value.toString();
                    if (identifier == null || identifier.length() <= 0) continue;
                    haveIdentifier = true;
                    cachedGUID = this.getGUIDForIdentifier(string, identifier);
                    if (cachedGUID == null) continue;
                    break;
                }
                catch (Throwable throwable) {
                }
            }
            if (!haveIdentifier || this.isAnonymousDevice()) {
                Logger.d("onUserLogin: no identifier provided or device is anonymous, pushing on current user profile");
                this.profile.push(profile);
                return;
            }
            if (cachedGUID != null && cachedGUID.equals(currentGUID)) {
                Logger.d("onUserLogin: " + profile.toString() + " maps to current device id " + currentGUID + " pushing on current profile");
                this.profile.push(profile);
                return;
            }
            String profileToString = profile.toString();
            if (this.isProcessUserLoginWithIdentifier(profileToString)) {
                Logger.d("Already processing onUserLogin for " + profileToString);
                return;
            }
            Boolean bl = processingUserLoginLock;
            synchronized (bl) {
                processingUserLoginIdentifier = profileToString;
            }
            Logger.v("onUserLogin: queuing reset profile for " + profileToString + " with Cached GUID " + (cachedGUID != null ? cachedGUID : "NULL"));
            final ProfileHandler profileHandler = this.profile;
            final String guid = cachedGUID;
            CleverTapAPI.postAsyncSafely("resetProfile", new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    try {
                        CleverTapAPI.this.forcePushDeviceToken(false);
                        CommsManager.flushQueueSync(CleverTapAPI.this.context);
                        QueueManager.clearQueues(CleverTapAPI.this.context);
                        LocalDataStore.changeUser(CleverTapAPI.this.context);
                        InAppFCManager.changeUser(CleverTapAPI.this.context);
                        activityCount = 1;
                        CleverTapAPI.this.forceDestroySession();
                        if (guid != null) {
                            DeviceInfo.forceUpdateDeviceId(guid);
                        } else {
                            DeviceInfo.forceNewDeviceID();
                        }
                        CleverTapAPI.this.forcePushAppLaunchedEvent("onLoginUser");
                        profileHandler.push(profile);
                        CleverTapAPI.this.forcePushDeviceToken(true);
                        Boolean bl = processingUserLoginLock;
                        synchronized (bl) {
                            processingUserLoginIdentifier = null;
                        }
                    }
                    catch (Throwable t) {
                        Logger.v("Reset Profile error", t);
                    }
                }
            });
        }
        catch (Throwable t) {
            Logger.v("onUserLogin failed", t);
        }
    }

    static void notifyUserProfileInitialized(String deviceID) {
        if (ourInstance == null) {
            return;
        }
        ourInstance._notifyProfileInitialized(deviceID);
    }

    private void _notifyProfileInitialized(String deviceID) {
        String string = deviceID = deviceID != null ? deviceID : this.getCleverTapID();
        if (deviceID == null) {
            return;
        }
        try {
            SyncListener sl = this.getSyncListener();
            if (sl != null) {
                sl.profileDidInitialize(deviceID);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    @SuppressLint(value={"CommitPrefEdits"})
    private void pushDailyEventsAsync() {
        CleverTapAPI.postAsyncSafely("CleverTapAPI#pushDailyEventsAsync", new Runnable(){

            @Override
            public void run() {
                try {
                    Logger.v("Queuing daily events");
                    CleverTapAPI.this.profile.pushBasicProfile(null);
                }
                catch (Throwable t) {
                    Logger.v("Daily profile sync failed", t);
                }
            }
        });
    }

    public static void setDebugLevel(int level) {
        debugLevel = level;
    }

    public static void setDebugLevel(LogLevel level) {
        debugLevel = level.intValue();
    }

    public static int getDebugLevel() {
        return debugLevel;
    }

    public void activityPaused(Activity activity) {
        CleverTapAPI.setAppForeground(false);
        CleverTapAPI.setCurrentActivity(activity);
        this.appLastSeen = System.currentTimeMillis();
        if (this.sessionTimeoutRunnable == null) {
            this.sessionTimeoutRunnable = new Runnable(){

                @Override
                public void run() {
                    CleverTapAPI.this.checkTimeoutSession();
                }
            };
        }
        CleverTapAPI.getHandlerUsingMainLooper().removeCallbacks(this.sessionTimeoutRunnable);
        CleverTapAPI.getHandlerUsingMainLooper().postDelayed(this.sessionTimeoutRunnable, 1200000L);
        Logger.v("Foreground activity gone to background");
    }

    boolean canShowInAppOnActivity() {
        this.updateBlacklistedActivitySet();
        for (String blacklistedActivity : inappActivityExclude) {
            String currentActivityName = CleverTapAPI.getCurrentActivityName();
            if (currentActivityName == null || !currentActivityName.contains(blacklistedActivity)) continue;
            return false;
        }
        return true;
    }

    private void updateBlacklistedActivitySet() {
        if (inappActivityExclude == null) {
            inappActivityExclude = new HashSet();
            try {
                String activities = ManifestMetaData.getMetaData(this.context, "CLEVERTAP_INAPP_EXCLUDE");
                if (activities != null) {
                    String[] split;
                    for (String a : split = activities.split(",")) {
                        inappActivityExclude.add(a.trim());
                    }
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            Logger.d("In-app notifications will not be shown on " + Arrays.toString(inappActivityExclude.toArray()));
        }
    }

    private void notifyActivityChanged(Activity activity) {
        boolean canShow;
        CleverTapAPI.setCurrentActivity(activity);
        ++activityCount;
        if (activity != null) {
            Logger.v("Activity changed: " + activity.getLocalClassName());
        }
        if (canShow = this.canShowInAppOnActivity()) {
            if (pendingInappRunnable != null) {
                Logger.v("Found a pending inapp runnable. Scheduling it");
                CleverTapAPI.getHandlerUsingMainLooper().postDelayed(pendingInappRunnable, 200L);
                pendingInappRunnable = null;
            } else {
                InAppManager.showNotificationIfAvailable(this.context);
            }
        } else {
            Logger.d("In-app notifications will not be shown for this activity (" + (activity != null ? activity.getLocalClassName() : "") + ")");
        }
        this.pushDailyEventsAsync();
        this.event.pushDeviceDetails();
        SessionManager.activityChanged(CleverTapAPI.getCurrentActivityName());
    }

    public void activityResumed(Activity activity) {
        CleverTapAPI.setAppForeground(true);
        Activity current = CleverTapAPI.getCurrentActivity();
        boolean newLaunch = current == null;
        String currentActivityName = CleverTapAPI.getCurrentActivityName();
        if (currentActivityName == null || !currentActivityName.equals(activity.getLocalClassName())) {
            this.notifyActivityChanged(activity);
        }
        Logger.v("Background activity in foreground");
        if (newLaunch) {
            this.initPush();
            CleverTapAPI.getHandlerUsingMainLooper().postDelayed(new Runnable(){

                @Override
                public void run() {
                    CleverTapAPI.this.pushAppLaunchedEvent("delayed generic handler");
                }
            }, 500L);
        }
    }

    JSONObject getAppLaunchedFields() {
        try {
            JSONObject evtData = new JSONObject();
            PackageInfo pInfo = this.context.getPackageManager().getPackageInfo(this.context.getPackageName(), 0);
            evtData.put("Build", (Object)(pInfo.versionCode + ""));
            evtData.put("Version", (Object)pInfo.versionName);
            evtData.put("OS Version", (Object)Build.VERSION.RELEASE);
            evtData.put("SDK Version", BuildInfo.SDK_VERSION);
            if (this.locationFromUser != null) {
                evtData.put("Latitude", this.locationFromUser.getLatitude());
                evtData.put("Longitude", this.locationFromUser.getLongitude());
            }
            if (CleverTapAPI.getGoogleAdID() != null) {
                String baseAdIDKey = "GoogleAdID";
                String adIDKey = this.deviceIsMultiUser() ? MULTI_USER_PREFIX + baseAdIDKey : baseAdIDKey;
                evtData.put(adIDKey, (Object)CleverTapAPI.getGoogleAdID());
                evtData.put("GoogleAdIDLimit", CleverTapAPI.isLimitAdTrackingEnabled());
            }
            try {
                String radio;
                String bluetoothVersion;
                Boolean isBluetoothEnabled;
                String make = Build.MANUFACTURER;
                String model = Build.MODEL;
                model = model.replace(make, "");
                evtData.put("Make", (Object)make.trim());
                evtData.put("Model", (Object)model.trim());
                evtData.put("Carrier", (Object)DeviceInfo.getCarrier());
                Boolean isWifi = DeviceInfo.isWifiConnected();
                if (isWifi != null) {
                    evtData.put("wifi", (Object)isWifi);
                }
                if ((isBluetoothEnabled = DeviceInfo.isBluetoothEnabled()) != null) {
                    evtData.put("BluetoothEnabled", (Object)isBluetoothEnabled);
                }
                if ((bluetoothVersion = DeviceInfo.getBluetoothVersion()) != null) {
                    evtData.put("BluetoothVersion", (Object)bluetoothVersion);
                }
                if ((radio = DeviceInfo.getNetworkType()) != null) {
                    evtData.put("Radio", (Object)radio);
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            return evtData;
        }
        catch (Throwable t) {
            Logger.v("Failed to construct App Launched event", t);
            return new JSONObject();
        }
    }

    private void checkTimeoutSession() {
        long now = System.currentTimeMillis();
        if (!CleverTapAPI.isAppForeground() && now - this.appLastSeen > 1200000L) {
            Logger.v("Session Timed Out");
            this.forceDestroySession();
            CleverTapAPI.setCurrentActivity(null);
        }
    }

    private void forceDestroySession() {
        CleverTapAPI.setAppLaunchPushed(false);
        SessionManager.destroySession();
    }

    private void forcePushAppLaunchedEvent(String source) {
        CleverTapAPI.setAppLaunchPushed(false);
        this.pushAppLaunchedEvent(source);
    }

    synchronized void pushAppLaunchedEvent(String source) {
        if (CleverTapAPI.isAppLaunchPushed()) {
            Logger.v("App Launched has already been triggered. Will not trigger it; source = " + source);
            return;
        }
        Logger.v("Firing App Launched event; source = " + source);
        CleverTapAPI.setAppLaunchPushed(true);
        JSONObject event = new JSONObject();
        try {
            event.put("evtName", (Object)"App Launched");
            event.put("evtData", (Object)this.getAppLaunchedFields());
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        QueueManager.queueEvent(this.context, event, 4);
    }

    public void flush() {
        CommsManager.flushQueueAsync(this.context);
    }

    private void initPush() {
        enabledPushTypes = DeviceInfo.getEnabledPushTypes();
        if (enabledPushTypes == null) {
            return;
        }
        for (PushType pushType : enabledPushTypes) {
            switch (pushType) {
                case GCM: {
                    GcmManager.initializeWithContext(this.context);
                    break;
                }
                case FCM: {
                    FcmManager.initializeWithContext(this.context);
                    break;
                }
            }
        }
    }

    private void forcePushDeviceToken(boolean register) {
        this.pushDeviceToken(register, true);
    }

    private void pushDeviceToken(boolean register, boolean force) {
        if (enabledPushTypes == null) {
            return;
        }
        for (PushType pushType : enabledPushTypes) {
            switch (pushType) {
                case GCM: {
                    GcmManager.pushDeviceToken(null, register, force);
                    break;
                }
                case FCM: {
                    FcmManager.pushDeviceToken(null, register, force);
                    break;
                }
            }
        }
    }

    public static NotificationInfo getNotificationInfo(Bundle extras) {
        if (extras == null) {
            return new NotificationInfo(false, false);
        }
        boolean fromCleverTap = extras.containsKey(NOTIFICATION_TAG);
        boolean shouldRender = fromCleverTap && extras.containsKey("nm");
        return new NotificationInfo(fromCleverTap, shouldRender);
    }

    public static void createNotificationChannel(final Context context, final String channelId, final CharSequence channelName, final String channelDescription, final int importance, final boolean showBadge) {
        try {
            if (Build.VERSION.SDK_INT >= 26) {
                CleverTapAPI.postAsyncSafely("createNotificationChannel", new Runnable(){

                    @Override
                    public void run() {
                        NotificationManager notificationManager = (NotificationManager)context.getSystemService("notification");
                        NotificationChannel notificationChannel = new NotificationChannel(channelId, channelName, importance);
                        notificationChannel.setDescription(channelDescription);
                        notificationChannel.setShowBadge(showBadge);
                        notificationManager.createNotificationChannel(notificationChannel);
                        Logger.i("Notification channel " + channelName.toString() + " has been created");
                    }
                });
            }
        }
        catch (Throwable t) {
            Logger.v("Failure creating Notification Channel", t);
        }
    }

    public static void createNotificationChannel(final Context context, final String channelId, final CharSequence channelName, final String channelDescription, final int importance, final String groupId, final boolean showBadge) {
        try {
            if (Build.VERSION.SDK_INT >= 26) {
                CleverTapAPI.postAsyncSafely("creatingNotificationChannel", new Runnable(){

                    @Override
                    public void run() {
                        NotificationManager notificationManager = (NotificationManager)context.getSystemService("notification");
                        NotificationChannel notificationChannel = new NotificationChannel(channelId, channelName, importance);
                        notificationChannel.setDescription(channelDescription);
                        notificationChannel.setGroup(groupId);
                        notificationChannel.setShowBadge(showBadge);
                        notificationManager.createNotificationChannel(notificationChannel);
                        Logger.i("Notification channel " + channelName.toString() + " has been created");
                    }
                });
            }
        }
        catch (Throwable t) {
            Logger.v("Failure creating Notification Channel", t);
        }
    }

    public static void createNotificationChannelGroup(final Context context, final String groupId, final CharSequence groupName) {
        try {
            if (Build.VERSION.SDK_INT >= 26) {
                CleverTapAPI.postAsyncSafely("creatingNotificationChannelGroup", new Runnable(){

                    @Override
                    public void run() {
                        NotificationManager notificationManager = (NotificationManager)context.getSystemService("notification");
                        notificationManager.createNotificationChannelGroup(new NotificationChannelGroup(groupId, groupName));
                        Logger.i("Notification channel group " + groupName.toString() + " has been created");
                    }
                });
            }
        }
        catch (Throwable t) {
            Logger.v("Failure creating Notification Channel Group", t);
        }
    }

    public static void deleteNotificationChannel(final Context context, final String channelId) {
        try {
            if (Build.VERSION.SDK_INT >= 26) {
                CleverTapAPI.postAsyncSafely("deletingNotificationChannel", new Runnable(){

                    @Override
                    public void run() {
                        NotificationManager notificationManager = (NotificationManager)context.getSystemService("notification");
                        notificationManager.deleteNotificationChannel(channelId);
                        Logger.i("Notification channel " + channelId.toString() + " has been deleted");
                    }
                });
            }
        }
        catch (Throwable t) {
            Logger.v("Failure deleting Notification Channel", t);
        }
    }

    public static void deleteNotificationChannelGroup(final Context context, final String groupId) {
        try {
            if (Build.VERSION.SDK_INT >= 26) {
                CleverTapAPI.postAsyncSafely("deletingNotificationChannelGroup", new Runnable(){

                    @Override
                    public void run() {
                        NotificationManager notificationManager = (NotificationManager)context.getSystemService("notification");
                        notificationManager.deleteNotificationChannelGroup(groupId);
                        Logger.i("Notification channel group " + groupId.toString() + " has been deleted");
                    }
                });
            }
        }
        catch (Throwable t) {
            Logger.v("Failure deleting Notification Channel Group", t);
        }
    }

    public static void createNotification(Context context, Bundle extras) {
        CleverTapAPI.createNotification(context, extras, -1000);
    }

    public static void createNotification(final Context context, final Bundle extras, final int notificationId) {
        if (extras == null || extras.get(NOTIFICATION_TAG) == null) {
            return;
        }
        try {
            CleverTapAPI.postAsyncSafely("CleverTapAPI#createNotification", new Runnable(){

                @Override
                public void run() {
                    try {
                        Logger.d("Handling notification: " + extras.toString());
                        if (extras.containsKey("d") && "y".equals(extras.getString("d"))) {
                            int r = (int)(Math.random() * 10.0);
                            if (r != 8) {
                                return;
                            }
                            JSONObject event = new JSONObject();
                            try {
                                JSONObject actions = new JSONObject();
                                for (String x : extras.keySet()) {
                                    Object value = extras.get(x);
                                    actions.put(x, value);
                                }
                                event.put("evtName", (Object)"wzrk_d");
                                event.put("evtData", (Object)actions);
                                QueueManager.queueEvent(context, event, 4);
                            }
                            catch (JSONException actions) {
                                // empty catch block
                            }
                            return;
                        }
                        String silent = extras.getString("wzrk_sn");
                        silent = silent != null ? silent : "";
                        String notifTitle = extras.getString("nt");
                        notifTitle = notifTitle != null ? notifTitle : "";
                        String notifMessage = extras.getString("nm");
                        String string = notifMessage = notifMessage != null ? notifMessage : "";
                        if (silent.equals("true")) {
                            if (notifMessage.isEmpty() && notifTitle.isEmpty()) {
                                CleverTapAPI.triggerSilentNotification(context, extras);
                            } else {
                                CleverTapAPI.triggerSilentNotification(context, extras);
                                CleverTapAPI.triggerNotification(context, extras, notifMessage, notifTitle, notificationId);
                            }
                        } else if (silent.equals("false") || silent.isEmpty()) {
                            if (notifMessage.isEmpty()) {
                                return;
                            }
                            if (notifTitle.isEmpty()) {
                                notifTitle = context.getApplicationInfo().name;
                                CleverTapAPI.triggerNotification(context, extras, notifMessage, notifTitle, notificationId);
                            } else {
                                CleverTapAPI.triggerNotification(context, extras, notifMessage, notifTitle, notificationId);
                            }
                        }
                    }
                    catch (Throwable t) {
                        Logger.d("Couldn't render notification: ", t);
                    }
                }
            });
        }
        catch (Throwable t) {
            Logger.d("Failed to process push notification", t);
        }
    }

    public static void triggerSilentNotification(Context context, Bundle extras) {
        Logger.d("Handling silent notification: " + extras.toString());
        Intent broadcast = new Intent("com.clevertap.android.sdk.SilentNotificationReceiver");
        broadcast.putExtras(extras);
        context.sendBroadcast(broadcast);
    }

    public static void triggerNotification(Context context, Bundle extras, String notifMessage, String notifTitle, int notificationId) {
        NotificationCompat.Builder nb;
        int priorityInt;
        int smallIcon;
        NotificationCompat.BigTextStyle style;
        PendingIntent pIntent;
        String icoPath;
        block58: {
            icoPath = extras.getString("ico");
            Intent launchIntent = new Intent(context, CTPushNotificationReceiver.class);
            launchIntent.putExtras(extras);
            launchIntent.removeExtra("wzrk_acts");
            launchIntent.setFlags(0x24000000);
            pIntent = PendingIntent.getBroadcast((Context)context, (int)((int)System.currentTimeMillis()), (Intent)launchIntent, (int)0x8000000);
            String bigPictureUrl = extras.getString("wzrk_bp");
            if (bigPictureUrl != null && bigPictureUrl.startsWith("http")) {
                try {
                    Bitmap bpMap = Utils.getNotificationBitmap(bigPictureUrl, false, context);
                    if (bpMap == null) {
                        throw new Exception("Failed to fetch big picture!");
                    }
                    style = new NotificationCompat.BigPictureStyle().setSummaryText((CharSequence)notifMessage).bigPicture(bpMap);
                }
                catch (Throwable t) {
                    style = new NotificationCompat.BigTextStyle().bigText((CharSequence)notifMessage);
                    Logger.v("Falling back to big text notification, couldn't fetch big picture", t);
                }
            } else {
                style = new NotificationCompat.BigTextStyle().bigText((CharSequence)notifMessage);
            }
            try {
                String x = ManifestMetaData.getMetaData(context, "CLEVERTAP_NOTIFICATION_ICON");
                if (x == null) {
                    throw new IllegalArgumentException();
                }
                smallIcon = context.getResources().getIdentifier(x, "drawable", context.getPackageName());
                if (smallIcon == 0) {
                    throw new IllegalArgumentException();
                }
            }
            catch (Throwable t) {
                smallIcon = DeviceInfo.getAppIconAsIntId(context);
            }
            priorityInt = 0;
            String priority = extras.getString("pr");
            if (priority != null) {
                if (priority.equals("high")) {
                    priorityInt = 1;
                }
                if (priority.equals("max")) {
                    priorityInt = 2;
                }
            }
            if (notificationId == -1000) {
                try {
                    Object collapse_key = extras.get("wzrk_ck");
                    if (collapse_key == null) break block58;
                    if (collapse_key instanceof Number) {
                        notificationId = ((Number)collapse_key).intValue();
                        break block58;
                    }
                    if (!(collapse_key instanceof String)) break block58;
                    try {
                        notificationId = Integer.parseInt(collapse_key.toString());
                        Logger.d("Converting collapse_key: " + collapse_key + " to notificationId int: " + notificationId);
                    }
                    catch (NumberFormatException e) {
                        notificationId = collapse_key.toString().hashCode();
                        Logger.d("Converting collapse_key: " + collapse_key + " to notificationId int: " + notificationId);
                    }
                }
                catch (NumberFormatException collapse_key) {}
            } else {
                Logger.d("Have user provided notificationId: " + notificationId + " won't use collapse_key (if any) as basis for notificationId");
            }
        }
        if (notificationId == -1000) {
            notificationId = (int)(Math.random() * 100.0);
            Logger.d("Setting random notificationId: " + notificationId);
        }
        if (context.getApplicationInfo().targetSdkVersion >= 26) {
            String badgeCountParam;
            String channelId = extras.getString("wzrk_cid", "");
            if (channelId.isEmpty()) {
                Logger.d("ChannelId is empty for notification: " + extras.toString());
            }
            nb = new NotificationCompat.Builder(context, channelId);
            String badgeIconParam = extras.getString("wzrk_bi", null);
            if (badgeIconParam != null) {
                try {
                    int badgeIconType = Integer.parseInt(badgeIconParam);
                    if (badgeIconType >= 0) {
                        nb.setBadgeIconType(badgeIconType);
                    }
                }
                catch (Throwable badgeIconType) {
                    // empty catch block
                }
            }
            if ((badgeCountParam = extras.getString("wzrk_bc", null)) != null) {
                try {
                    int badgeCount = Integer.parseInt(badgeCountParam);
                    if (badgeCount >= 0) {
                        nb.setNumber(badgeCount);
                    }
                }
                catch (Throwable badgeCount) {}
            }
        } else {
            nb = new NotificationCompat.Builder(context);
        }
        nb.setContentTitle((CharSequence)notifTitle).setContentText((CharSequence)notifMessage).setContentIntent(pIntent).setAutoCancel(true).setStyle((NotificationCompat.Style)style).setPriority(priorityInt).setSmallIcon(smallIcon);
        try {
            nb.setLargeIcon(Utils.getNotificationBitmap(icoPath, true, context));
        }
        catch (PackageManager.NameNotFoundException e) {
            Logger.d("Error setting large notification icon: ", e);
        }
        try {
            if (extras.containsKey("wzrk_sound")) {
                Uri soundUri = null;
                Object o = extras.get("wzrk_sound");
                if (o instanceof Boolean && ((Boolean)o).booleanValue()) {
                    soundUri = RingtoneManager.getDefaultUri((int)2);
                } else if (o instanceof String) {
                    String s = (String)o;
                    if (s.equals("true")) {
                        soundUri = RingtoneManager.getDefaultUri((int)2);
                    } else if (!s.isEmpty()) {
                        if (s.contains(".mp3") || s.contains(".ogg") || s.contains(".wav")) {
                            s = s.substring(0, s.length() - 4);
                        }
                        soundUri = Uri.parse((String)("android.resource://" + context.getPackageName() + "/raw/" + s));
                    }
                }
                if (soundUri != null) {
                    nb.setSound(soundUri);
                }
            }
        }
        catch (Throwable t) {
            Logger.d("Could not process sound parameter", t);
        }
        JSONArray actions = null;
        String actionsString = extras.getString("wzrk_acts");
        if (actionsString != null) {
            try {
                actions = new JSONArray(actionsString);
            }
            catch (Throwable t) {
                Logger.d("error parsing notification actions: " + t.getLocalizedMessage());
            }
        }
        boolean isCTIntentServiceAvailable = CleverTapAPI.isServiceAvailable(context, "com.clevertap.PUSH_EVENT", CTNotificationIntentService.class);
        if (actions != null && actions.length() > 0) {
            for (int i = 0; i < actions.length(); ++i) {
                try {
                    Intent actionLaunchIntent;
                    boolean sendToCTIntentService;
                    JSONObject action = actions.getJSONObject(i);
                    String label = action.optString("l");
                    String dl = action.optString("dl");
                    String ico = action.optString("ico");
                    String id = action.optString("id");
                    boolean autoCancel = action.optBoolean("ac", true);
                    if (label.isEmpty() || id.isEmpty()) {
                        Logger.d("not adding push notification action: action label or id missing");
                        continue;
                    }
                    int icon = 0;
                    if (!ico.isEmpty()) {
                        try {
                            icon = context.getResources().getIdentifier(ico, "drawable", context.getPackageName());
                        }
                        catch (Throwable t) {
                            Logger.d("unable to add notification action icon: " + t.getLocalizedMessage());
                        }
                    }
                    boolean bl = sendToCTIntentService = autoCancel && isCTIntentServiceAvailable;
                    if (sendToCTIntentService) {
                        actionLaunchIntent = new Intent("com.clevertap.PUSH_EVENT");
                        actionLaunchIntent.putExtra("ct_type", "com.clevertap.ACTION_BUTTON_CLICK");
                        if (!dl.isEmpty()) {
                            actionLaunchIntent.putExtra("dl", dl);
                        }
                    } else {
                        actionLaunchIntent = !dl.isEmpty() ? new Intent("android.intent.action.VIEW", Uri.parse((String)dl)) : context.getPackageManager().getLaunchIntentForPackage(context.getPackageName());
                    }
                    actionLaunchIntent.putExtras(extras);
                    actionLaunchIntent.removeExtra("wzrk_acts");
                    actionLaunchIntent.putExtra("actionId", id);
                    actionLaunchIntent.putExtra("autoCancel", autoCancel);
                    actionLaunchIntent.putExtra("wzrk_c2a", id);
                    actionLaunchIntent.putExtra("notificationId", notificationId);
                    actionLaunchIntent.setFlags(0x24000000);
                    int requestCode = (int)System.currentTimeMillis() + i;
                    PendingIntent actionIntent = sendToCTIntentService ? PendingIntent.getService((Context)context, (int)requestCode, (Intent)actionLaunchIntent, (int)0x8000000) : PendingIntent.getActivity((Context)context, (int)requestCode, (Intent)actionLaunchIntent, (int)0x8000000);
                    nb.addAction(icon, (CharSequence)label, actionIntent);
                    continue;
                }
                catch (Throwable t) {
                    Logger.d("error adding notification action : " + t.getLocalizedMessage());
                }
            }
        }
        Notification n = nb.build();
        Logger.d("Building notification: " + n.toString() + ", with notificationId: " + String.valueOf(notificationId));
        NotificationManager notificationManager = (NotificationManager)context.getSystemService("notification");
        notificationManager.notify(notificationId, n);
    }

    public void pushDeepLink(Uri uri) {
        this.pushDeepLink(uri, false);
    }

    synchronized void pushDeepLink(Uri uri, boolean install) {
        if (uri == null) {
            return;
        }
        try {
            JSONObject referrer = UriHelper.getUrchinFromUri(uri);
            referrer.put("referrer", (Object)uri.toString());
            if (install) {
                referrer.put("install", true);
            }
            this.event.pushDeviceDetailsWithExtras(referrer);
        }
        catch (Throwable t) {
            Logger.v("Failed to push deep link", t);
        }
    }

    public synchronized void pushInstallReferrer(String source, String medium, String campaign) {
        if (source == null && medium == null && campaign == null) {
            return;
        }
        try {
            int status = StorageHelper.getInt(this.context, "app_install_status", 0);
            if (status != 0) {
                Logger.d("Install referrer has already been set. Will not override it");
                return;
            }
            StorageHelper.putInt(this.context, "app_install_status", 1);
            if (source != null) {
                source = Uri.encode((String)source);
            }
            if (medium != null) {
                medium = Uri.encode((String)medium);
            }
            if (campaign != null) {
                campaign = Uri.encode((String)campaign);
            }
            String uriStr = "wzrk://track?install=true";
            if (source != null) {
                uriStr = uriStr + "&utm_source=" + source;
            }
            if (medium != null) {
                uriStr = uriStr + "&utm_medium=" + medium;
            }
            if (campaign != null) {
                uriStr = uriStr + "&utm_campaign=" + campaign;
            }
            Uri uri = Uri.parse((String)uriStr);
            this.pushDeepLink(uri, true);
        }
        catch (Throwable t) {
            Logger.v("Failed to push install referrer", t);
        }
    }

    public void enablePersonalization() {
        LocalDataStore.setPersonalisationEnabled(this.context, true);
    }

    public void disablePersonalization() {
        LocalDataStore.setPersonalisationEnabled(this.context, false);
    }

    public void pushInstallReferrer(Intent intent) {
        try {
            String url;
            Bundle extras = intent.getExtras();
            if (extras == null || !extras.containsKey("referrer")) {
                return;
            }
            try {
                url = URLDecoder.decode(extras.getString("referrer"), "UTF-8");
                Logger.v("Referrer received: " + url);
            }
            catch (Throwable e) {
                return;
            }
            if (url == null) {
                return;
            }
            int now = (int)(System.currentTimeMillis() / 1000L);
            if (installReferrerMap.containsKey(url) && now - installReferrerMap.get(url) < 10) {
                Logger.v("Skipping install referrer due to duplicate within 10 seconds");
                return;
            }
            installReferrerMap.put(url, now);
            Uri uri = Uri.parse((String)("wzrk://track?install=true&" + url));
            this.pushDeepLink(uri, true);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public Location getLocation() {
        return this._getLocation();
    }

    public void setLocation(Location location) {
        this._setLocation(location);
    }

    @Deprecated
    public void updateLocation(Location location) {
        this._setLocation(location);
    }

    private void _setLocation(Location location) {
        if (location == null) {
            return;
        }
        this.locationFromUser = location;
        Logger.v("Location updated (" + location.getLatitude() + ", " + location.getLongitude() + ")");
        if (!CleverTapAPI.isAppForeground()) {
            return;
        }
        int now = (int)(System.currentTimeMillis() / 1000L);
        if (now > lastLocationPingTime + 10) {
            QueueManager.queueEvent(this.context, new JSONObject(), 2);
            lastLocationPingTime = now;
            Logger.v("Queuing location ping event for location (" + location.getLatitude() + ", " + location.getLongitude() + ")");
        }
    }

    private Location _getLocation() {
        try {
            LocationManager lm = (LocationManager)this.context.getSystemService("location");
            List providers = lm.getProviders(true);
            Location bestLocation = null;
            Location l = null;
            for (String provider : providers) {
                try {
                    l = lm.getLastKnownLocation(provider);
                }
                catch (SecurityException e) {
                    Logger.v("Location security exception", e);
                }
                if (l == null || bestLocation != null && !(l.getAccuracy() < bestLocation.getAccuracy())) continue;
                bestLocation = l;
            }
            return bestLocation;
        }
        catch (Throwable t) {
            Logger.v("Couldn't get user's location", t);
            return null;
        }
    }

    public String getCleverTapID() {
        return DeviceInfo.getDeviceID();
    }

    public String getCleverTapAttributionIdentifier() {
        return DeviceInfo.getAttributionID();
    }

    public String getDevicePushToken(PushType type) {
        switch (type) {
            case GCM: {
                return GcmManager.getDeviceToken();
            }
            case FCM: {
                return FcmManager.getDeviceToken();
            }
        }
        return null;
    }

    void deviceTokenDidRefresh(String token, PushType type) {
        if (this.tokenRefreshListener != null) {
            Logger.d("Notifying devicePushTokenDidRefresh: " + token);
            this.tokenRefreshListener.devicePushTokenDidRefresh(token, type);
        }
    }

    public void setDevicePushTokenRefreshListener(DevicePushTokenRefreshListener listener) {
        this.tokenRefreshListener = listener;
    }

    private static boolean isServiceAvailable(Context context, String action, Class clazz) {
        Intent intent;
        PackageManager packageManager = context.getPackageManager();
        List resolveInfo = packageManager.queryIntentServices(intent = new Intent(action), 0);
        if (resolveInfo.size() > 0) {
            Logger.v("" + clazz.getName() + " is available");
            return true;
        }
        Logger.v("" + clazz.getName() + " is NOT available");
        return false;
    }

    static {
        EXECUTOR_THREAD_ID = 0L;
        processingUserLoginIdentifier = null;
        processingUserLoginLock = true;
        inappActivityExclude = null;
        enabledPushTypes = null;
        installReferrerMap = new HashMap(8);
    }

    public static interface DevicePushTokenRefreshListener {
        public void devicePushTokenDidRefresh(String var1, PushType var2);
    }

    public static enum LogLevel {
        OFF(-1),
        INFO(0),
        DEBUG(2);

        private final int value;

        private LogLevel(int newValue) {
            this.value = newValue;
        }

        public int intValue() {
            return this.value;
        }
    }
}

