package com.clevertap.android.sdk;

import android.content.Context;

import org.json.JSONObject;

/**
 * User: Jude Pereira
 * Date: 07/07/2015
 * Time: 14:53
 */
public final class SessionHandler {
    private final Context context;
    private int lastVisitTime;
    private static String source = null, medium = null, campaign = null;
    private static JSONObject wzrkParams = null;


    // only set if not already set during the session
    synchronized static void setSource(String source) {
        if (SessionHandler.source == null) {
            SessionHandler.source = source;
        }
    }

    // only set if not already set during the session
    synchronized static void setMedium(String medium) {
        if (SessionHandler.medium == null) {
            SessionHandler.medium = medium;
        }
    }

    synchronized static void setCampaign(String campaign) {
        if (SessionHandler.campaign == null) {
            SessionHandler.campaign = campaign;
        }
    }

    synchronized static void setWzrkParams(JSONObject wzrkParams) {
        if (SessionHandler.wzrkParams == null) {
            SessionHandler.wzrkParams = wzrkParams;
        }
    }

    synchronized static void clearSource() {
        SessionHandler.source = null;
    }

    synchronized static void clearMedium() {
        SessionHandler.medium = null;
    }

    synchronized static void clearCampaign() {
        SessionHandler.campaign = null;
    }

    synchronized static void clearWzrkParams() {
        SessionHandler.wzrkParams = null;
    }

    synchronized static String getSource() {
        return SessionHandler.source;
    }

    synchronized static String getMedium() {
        return SessionHandler.medium;
    }

    synchronized static String getCampaign() {
        return SessionHandler.campaign;
    }

    synchronized static JSONObject getWzrkParams() {
        return SessionHandler.wzrkParams;
    }

    SessionHandler(final Context context) {
        this.context = context;

        CleverTapAPI.postAsyncSafely("SessionHandler#setLastVisitTime", new Runnable() {
            @Override
            public void run() {
                setLastVisitTime(context);
            }
        });
    }

    private void setLastVisitTime(final Context context) {
        EventDetail ed = LocalDataStore.getEventDetail(context, Constants.APP_LAUNCHED_EVENT);
        if (ed == null) {
            lastVisitTime = -1;
        } else {
            lastVisitTime = ed.getLastTime();
        }
    }

    public int getTotalVisits() {
        EventDetail ed = LocalDataStore.getEventDetail(context, Constants.APP_LAUNCHED_EVENT);
        if (ed != null) return ed.getCount();

        return 0;
    }

    public int getScreenCount() {
        return CleverTapAPI.activityCount;
    }

    public int getTimeElapsed() {
        int currentSession = SessionManager.getCurrentSession();
        if (currentSession == 0) return -1;

        int now = (int) (System.currentTimeMillis() / 1000);
        return now - currentSession;
    }

    public int getPreviousVisitTime() {
        return lastVisitTime;
    }


    public UTMDetail getUTMDetails() {
        UTMDetail ud = new UTMDetail();
        ud.setSource(source);
        ud.setMedium(medium);
        ud.setCampaign(campaign);
        return ud;
    }
}
