/*
 * Author: Jude Pereira
 * Copyright (c) 2014
 */

package com.clevertap.android.sdk;

import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.support.v4.content.WakefulBroadcastReceiver;
import com.google.android.gms.gcm.GoogleCloudMessaging;

/**
 * Receives the GCM message.
 * <p/>
 * Used when the implementing app does not provide a broadcast listener
 * of it's own.
 */

@Deprecated
public final class GcmBroadcastReceiver extends WakefulBroadcastReceiver {
    /**
     * Receives the broadcast from the OS, and creates the necessary notification.
     *
     * @param context The Android context
     * @param intent  The intent containing the extras
     */
    public void onReceive(Context context, Intent intent) {
        Bundle extras = intent.getExtras();
        GoogleCloudMessaging gcm = GoogleCloudMessaging.getInstance(context);
        String messageType = gcm.getMessageType(intent);
        if (GoogleCloudMessaging.
                MESSAGE_TYPE_MESSAGE.equals(messageType)) {
            Logger.logFine(CleverTapAPI.getNotificationInfo(extras).toString());
            CleverTapAPI.createNotification(context, extras);
        }
    }
}
