package com.clevertap.android.sdk;

import android.content.Context;

/**
 * User: Jude Pereira
 * Date: 07/07/2015
 * Time: 14:53
 */
public final class SessionHandler {
    private final Context context;
    private int lastVisitTime;
    private static String source = null, medium = null, campaign = null;

    static void setSource(String source) {
        SessionHandler.source = source;
    }

    static void setMedium(String medium) {
        SessionHandler.medium = medium;
    }

    static void setCampaign(String campaign) {
        SessionHandler.campaign = campaign;
    }

    SessionHandler(final Context context) {
        this.context = context;

        CleverTapAPI.postAsyncSafely("SessionHandler#setLastVisitTime", new Runnable() {
            @Override
            public void run() {
                setLastVisitTime(context);
            }
        });
    }

    private void setLastVisitTime(final Context context) {
        EventDetail ed = LocalDataStore.getEventDetail(context, Constants.APP_LAUNCHED_EVENT);
        if (ed == null) {
            lastVisitTime = -1;
        } else {
            lastVisitTime = ed.getLastTime();
        }
    }

    public int getTotalVisits() {
        EventDetail ed = LocalDataStore.getEventDetail(context, Constants.APP_LAUNCHED_EVENT);
        if (ed != null) return ed.getCount();

        return 0;
    }

    public int getScreenCount() {
        return CleverTapAPI.activityCount;
    }

    public int getTimeElapsed() {
        int currentSession = SessionManager.getCurrentSession();
        if (currentSession == 0) return -1;

        int now = (int) (System.currentTimeMillis() / 1000);
        return now - currentSession;
    }

    public int getPreviousVisitTime() {
        return lastVisitTime;
    }


    public UTMDetail getUTMDetails() {
        UTMDetail ud = new UTMDetail();
        ud.setSource(source);
        ud.setMedium(medium);
        ud.setCampaign(campaign);
        return ud;
    }
}
