package com.clevertap.android.sdk;

import android.annotation.TargetApi;
import android.app.Activity;
import android.content.Intent;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import com.clevertap.android.sdk.exceptions.CleverTapException;

/**
 * User: Jude Pereira
 * Date: 22/06/2015
 * Time: 14:36
 */
public final class ActivityLifecycleCallback {
    private static boolean registered = false;

    @TargetApi(Build.VERSION_CODES.ICE_CREAM_SANDWICH)
    public static synchronized void register(android.app.Application application) {
        if (application == null || Build.VERSION.SDK_INT < 14) {
            Logger.error("Application instance is null/system API is too old");
            return;
        }

        if (registered) {
            Logger.error("Lifecycle callbacks have already been registered");
            return;
        }

        final CleverTapAPI wr;

        try {
            wr = CleverTapAPI.getInstance(application.getApplicationContext());
        } catch (CleverTapException e) {
            Logger.error("Credentials not available/permissions not satisfied. Refer to the SDK documentation for more details");
            return;
        }

        registered = true;
        application.registerActivityLifecycleCallbacks(
                new android.app.Application.ActivityLifecycleCallbacks() {

                    @Override
                    public void onActivityCreated(Activity activity, Bundle bundle) {
                        CleverTapAPI.setAppForeground(true);
                        try {
                            wr.event.pushNotificationEvent(activity.getIntent().getExtras());
                        } catch (Throwable t) {
                            // Ignore
                        }
                        try {
                            Intent intent = activity.getIntent();
                            Uri data = intent.getData();
                            wr.pushDeepLink(data);
                        } catch (Throwable t) {
                            // Ignore
                        }
                    }

                    @Override
                    public void onActivityStarted(Activity activity) {
                    }

                    @Override
                    public void onActivityResumed(Activity activity) {
                        try {
                            wr.activityResumed(activity);
                        } catch (Throwable t) {
                            // Ignore
                        }
                    }

                    @Override
                    public void onActivityPaused(Activity activity) {
                        try {
                            wr.activityPaused(activity);
                        } catch (Throwable t) {
                            // Ignore
                        }
                    }

                    @Override
                    public void onActivityStopped(Activity activity) {

                    }

                    @Override
                    public void onActivitySaveInstanceState(Activity activity, Bundle bundle) {

                    }

                    @Override
                    public void onActivityDestroyed(Activity activity) {

                    }
                }

        );
        Logger.logFine("Activity lifecycle callback successfully registered");
    }
}
