package com.clevertap.android.sdk;

import android.os.Bundle;
import com.google.android.gms.gcm.GcmListenerService;

public class GcmMessageListenerService  extends GcmListenerService {
    @Override
    public void onMessageReceived(String from, Bundle extras){
        try {
            NotificationInfo info = CleverTapAPI.getNotificationInfo(extras);
            Logger.logFine("GcmMessageListenerService: "+ info.toString());
            if (info.fromCleverTap) {
                CleverTapAPI.createNotification(getApplicationContext(), extras);
            }
        } catch (Throwable t) {
            Logger.logFine("Error handling GCM message", t);
        }
    }
}
