/*
 * Decompiled with CFR 0.152.
 */
package com.clevertap.android.sdk;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.SharedPreferences;
import com.clevertap.android.sdk.CleverTapAPI;
import com.clevertap.android.sdk.DBAdapter;
import com.clevertap.android.sdk.EventDetail;
import com.clevertap.android.sdk.Logger;
import com.clevertap.android.sdk.StorageHelper;
import com.clevertap.android.sdk.SyncListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

final class LocalDataStore {
    private static final String eventNamespace = "local_events";
    private static final String PERSONALISATION_ENABLED = "personalisationEnabledBool";
    private static final HashMap<String, Object> PROFILE_FIELDS_IN_THIS_SESSION = new HashMap();
    private static boolean personalizationEnabled = false;
    private static final Object personalizationEnabledLock = new Object();
    private static final HashMap<String, Integer> PROFILE_EXPIRY_MAP = new HashMap();
    private static DBAdapter dbAdapter;

    LocalDataStore() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void setPersonalisationEnabled(final Context context, final boolean enable) {
        Object object = personalizationEnabledLock;
        synchronized (object) {
            personalizationEnabled = enable;
        }
        CleverTapAPI.postAsyncSafely("LocalDataStore#persistPersonalizationEnabled", new Runnable(){

            @Override
            public void run() {
                StorageHelper.putBoolean(context, LocalDataStore.PERSONALISATION_ENABLED, enable);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static boolean isPersonalisationEnabled(Context context) {
        Object object = personalizationEnabledLock;
        synchronized (object) {
            return personalizationEnabled;
        }
    }

    static void initializeWithContext(Context context) {
        dbAdapter = new DBAdapter(context);
        LocalDataStore.inflateLocalProfileAsync(context);
    }

    static void changeUser(Context context) {
        LocalDataStore.resetLocalProfileSync(context);
    }

    static void setDataSyncFlag(Context context, JSONObject event) {
        try {
            String evtName;
            boolean enablePersonalisation = StorageHelper.getBoolean(context, PERSONALISATION_ENABLED, false);
            if (!enablePersonalisation) {
                event.put("dsync", false);
                return;
            }
            String eventType = event.getString("type");
            if ("event".equals(eventType) && "App Launched".equals(evtName = event.getString("evtName"))) {
                Logger.logFine("Local cache needs to be updated (triggered by App Launched)");
                event.put("dsync", true);
                return;
            }
            if ("profile".equals(eventType)) {
                event.put("dsync", true);
                Logger.logFine("Local cache needs to be updated (profile event)");
                return;
            }
            int now = (int)(System.currentTimeMillis() / 1000L);
            int expiresIn = LocalDataStore.getLocalCacheExpiryInterval(context, 1200);
            int lastUpdate = StorageHelper.getInt(context, "local_cache_last_update", now);
            if (lastUpdate + expiresIn < now) {
                event.put("dsync", true);
                Logger.logFine("Local cache needs to be updated");
            } else {
                event.put("dsync", false);
                Logger.logFine("Local cache doesn't need to be updated");
            }
        }
        catch (Throwable t) {
            Logger.error("Failed to sync with upstream", t);
        }
    }

    static void persistEvent(Context context, JSONObject event, int type) {
        if (event == null) {
            return;
        }
        try {
            if (type == 4) {
                LocalDataStore.persistEvent(context, event);
            }
        }
        catch (Throwable t) {
            Logger.error("Failed to sync with upstream", t);
        }
    }

    static void syncWithUpstream(Context context, JSONObject response) {
        try {
            JSONObject eventUpdates = null;
            JSONObject profileUpdates = null;
            if (!response.has("evpr")) {
                return;
            }
            JSONObject evpr = response.getJSONObject("evpr");
            if (evpr.has("profile")) {
                JSONObject profile = evpr.getJSONObject("profile");
                if (profile.has("_custom")) {
                    JSONObject custom = profile.getJSONObject("_custom");
                    profile.remove("_custom");
                    Iterator keys = custom.keys();
                    while (keys.hasNext()) {
                        String next = keys.next().toString();
                        Object value = null;
                        try {
                            value = custom.getJSONArray(next);
                        }
                        catch (Throwable t) {
                            try {
                                value = custom.get(next);
                            }
                            catch (JSONException e) {
                                // empty catch block
                            }
                        }
                        if (value == null) continue;
                        profile.put(next, value);
                    }
                }
                profileUpdates = LocalDataStore.syncProfile(context, profile);
            }
            if (evpr.has("events")) {
                eventUpdates = LocalDataStore.syncEventsFromUpstream(context, evpr.getJSONObject("events"));
            }
            if (evpr.has("expires_in")) {
                int expiresIn = evpr.getInt("expires_in");
                LocalDataStore.setLocalCacheExpiryInterval(context, expiresIn);
            }
            StorageHelper.putInt(context, "local_cache_last_update", (int)(System.currentTimeMillis() / 1000L));
            Boolean profileUpdatesNotEmpty = profileUpdates != null && profileUpdates.length() > 0;
            Boolean eventsUpdatesNotEmpty = eventUpdates != null && eventUpdates.length() > 0;
            if (profileUpdatesNotEmpty.booleanValue() || eventsUpdatesNotEmpty.booleanValue()) {
                SyncListener syncListener;
                JSONObject updates = new JSONObject();
                if (profileUpdatesNotEmpty.booleanValue()) {
                    updates.put("profile", (Object)profileUpdates);
                }
                if (eventsUpdatesNotEmpty.booleanValue()) {
                    updates.put("events", (Object)eventUpdates);
                }
                if ((syncListener = CleverTapAPI.getInstance(context).getSyncListener()) != null) {
                    try {
                        syncListener.profileDataUpdated(updates);
                    }
                    catch (Throwable t) {
                        Logger.error("Execution of sync listener failed", t);
                    }
                }
            }
        }
        catch (Throwable t) {
            Logger.error("Failed to sync with upstream", t);
        }
    }

    @SuppressLint(value={"CommitPrefEdits"})
    private static JSONObject syncEventsFromUpstream(Context context, JSONObject events) {
        try {
            JSONObject eventUpdates = null;
            SharedPreferences prefs = StorageHelper.getPreferences(context, eventNamespace);
            Iterator keys = events.keys();
            SharedPreferences.Editor editor = prefs.edit();
            while (keys.hasNext()) {
                int last;
                int first;
                int upstreamCount;
                String event = keys.next().toString();
                String encoded = prefs.getString(event, LocalDataStore.encodeEventDetails(0, 0, 0));
                EventDetail ed = LocalDataStore.decodeEventDetails(event, encoded);
                JSONArray upstream = events.getJSONArray(event);
                if (upstream == null || upstream.length() < 3) {
                    Logger.error("Corrupted upstream event detail");
                    continue;
                }
                try {
                    upstreamCount = upstream.getInt(0);
                    first = upstream.getInt(1);
                    last = upstream.getInt(2);
                }
                catch (Throwable t) {
                    Logger.error("Failed to parse upstream event message: " + upstream.toString());
                    continue;
                }
                if (upstreamCount > ed.getCount()) {
                    editor.putString(event, LocalDataStore.encodeEventDetails(first, last, upstreamCount));
                    Logger.logFine("Accepted update for event " + event + " from upstream");
                    try {
                        if (eventUpdates == null) {
                            eventUpdates = new JSONObject();
                        }
                        JSONObject evUpdate = new JSONObject();
                        JSONObject countUpdate = new JSONObject();
                        countUpdate.put("oldValue", ed.getCount());
                        countUpdate.put("newValue", upstreamCount);
                        evUpdate.put("count", (Object)countUpdate);
                        JSONObject firstUpdate = new JSONObject();
                        firstUpdate.put("oldValue", ed.getFirstTime());
                        firstUpdate.put("newValue", upstream.getInt(1));
                        evUpdate.put("firstTime", (Object)firstUpdate);
                        JSONObject lastUpdate = new JSONObject();
                        lastUpdate.put("oldValue", ed.getLastTime());
                        lastUpdate.put("newValue", upstream.getInt(2));
                        evUpdate.put("lastTime", (Object)lastUpdate);
                        eventUpdates.put(event, (Object)evUpdate);
                    }
                    catch (Throwable t) {
                        Logger.error("Couldn't set event updates", t);
                    }
                    continue;
                }
                Logger.logFine("Rejected update for event " + event + " from upstream");
            }
            StorageHelper.persist(editor);
            return eventUpdates;
        }
        catch (Throwable t) {
            Logger.error("Couldn't sync events from upstream", t);
            return null;
        }
    }

    @SuppressLint(value={"CommitPrefEdits"})
    private static JSONObject syncProfile(Context context, JSONObject remoteProfile) {
        JSONObject profileUpdates = new JSONObject();
        if (remoteProfile == null || remoteProfile.length() <= 0) {
            return profileUpdates;
        }
        try {
            JSONObject fieldsToUpdateLocally = new JSONObject();
            int now = (int)(System.currentTimeMillis() / 1000L);
            Iterator keys = remoteProfile.keys();
            while (keys.hasNext()) {
                try {
                    String key = keys.next().toString();
                    if (LocalDataStore.shouldPreferLocalProfileUpdateForKeyForTime(key, now).booleanValue()) {
                        Logger.logFine("Rejecting upstream value for key " + key + " " + "because our local cache prohibits it");
                        continue;
                    }
                    Object localValue = LocalDataStore.getProfileValueForKey(key);
                    Object remoteValue = remoteProfile.get(key);
                    if (LocalDataStore.profileValueIsEmpty(remoteValue).booleanValue()) {
                        remoteValue = null;
                    }
                    if (LocalDataStore.profileValuesAreEqual(remoteValue, localValue).booleanValue()) continue;
                    try {
                        JSONObject changesObject;
                        if (remoteValue != null) {
                            fieldsToUpdateLocally.put(key, remoteValue);
                        } else {
                            LocalDataStore.removeProfileField(context, key, true);
                        }
                        if ((changesObject = LocalDataStore.buildChangeFromOldValueToNewValue(localValue, remoteValue)) == null) continue;
                        profileUpdates.put(key, (Object)changesObject);
                    }
                    catch (Throwable t) {
                        Logger.logFine("Failed to set profile updates", t);
                    }
                }
                catch (Throwable t) {
                    Logger.logFine("Failed to update profile field", t);
                }
            }
            if (fieldsToUpdateLocally.length() > 0) {
                LocalDataStore.setProfileFields(context, fieldsToUpdateLocally, true);
            }
            return profileUpdates;
        }
        catch (Throwable t) {
            Logger.error("Failed to sync remote profile", t);
            return null;
        }
    }

    @SuppressLint(value={"CommitPrefEdits"})
    private static void persistEvent(Context context, JSONObject event) {
        try {
            String evtName = event.getString("evtName");
            if (evtName == null) {
                return;
            }
            SharedPreferences prefs = StorageHelper.getPreferences(context, eventNamespace);
            int now = (int)(System.currentTimeMillis() / 1000L);
            String encoded = prefs.getString(evtName, LocalDataStore.encodeEventDetails(now, now, 0));
            EventDetail ed = LocalDataStore.decodeEventDetails(evtName, encoded);
            String updateEncoded = LocalDataStore.encodeEventDetails(ed.getFirstTime(), now, ed.getCount() + 1);
            SharedPreferences.Editor editor = prefs.edit();
            editor.putString(evtName, updateEncoded);
            StorageHelper.persist(editor);
        }
        catch (Throwable t) {
            Logger.error("Failed to persist event locally", t);
        }
    }

    private static String encodeEventDetails(int first, int last, int count) {
        return count + "|" + first + "|" + last;
    }

    private static EventDetail decodeEventDetails(String name, String encoded) {
        if (encoded == null) {
            return null;
        }
        String[] parts = encoded.split("\\|");
        return new EventDetail(Integer.parseInt(parts[0]), Integer.parseInt(parts[1]), Integer.parseInt(parts[2]), name);
    }

    static Map<String, EventDetail> getEventHistory(Context context) {
        try {
            SharedPreferences prefs = StorageHelper.getPreferences(context, eventNamespace);
            Map all = prefs.getAll();
            HashMap<String, EventDetail> out = new HashMap<String, EventDetail>();
            for (String eventName : all.keySet()) {
                out.put(eventName, LocalDataStore.decodeEventDetails(eventName, all.get(eventName).toString()));
            }
            return out;
        }
        catch (Throwable t) {
            Logger.error("Failed to retrieve local event history", t);
            return null;
        }
    }

    static EventDetail getEventDetail(Context context, String eventName) {
        try {
            if (!LocalDataStore.isPersonalisationEnabled(context)) {
                return null;
            }
            SharedPreferences prefs = StorageHelper.getPreferences(context, eventNamespace);
            return LocalDataStore.decodeEventDetails(eventName, prefs.getString(eventName, null));
        }
        catch (Throwable t) {
            Logger.error("Failed to retrieve local event detail", t);
            return null;
        }
    }

    static Object getProfileProperty(Context context, String key) {
        return LocalDataStore.getProfileValueForKey(key);
    }

    static Object getProfileValueForKey(String key) {
        return LocalDataStore._getProfileProperty(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Object _getProfileProperty(String key) {
        if (key == null) {
            return null;
        }
        HashMap<String, Object> hashMap = PROFILE_FIELDS_IN_THIS_SESSION;
        synchronized (hashMap) {
            try {
                return PROFILE_FIELDS_IN_THIS_SESSION.get(key);
            }
            catch (Throwable t) {
                Logger.error("Failed to retrieve local profile property", t);
                return null;
            }
        }
    }

    static void setProfileFields(Context context, JSONObject fields) {
        LocalDataStore.setProfileFields(context, fields, false);
    }

    static void setProfileFields(Context context, JSONObject fields, Boolean fromUpstream) {
        if (fields == null) {
            return;
        }
        try {
            Iterator keys = fields.keys();
            while (keys.hasNext()) {
                String key = keys.next().toString();
                LocalDataStore.setProfileField(context, key, fields.get(key), fromUpstream);
            }
        }
        catch (Throwable t) {
            Logger.error("Failed to set profile fields", t);
        }
    }

    static void setProfileField(Context context, String key, Object value) {
        LocalDataStore.setProfileField(context, key, value, false);
    }

    static void setProfileField(Context context, String key, Object value, Boolean fromUpstream) {
        if (key == null || value == null) {
            return;
        }
        try {
            LocalDataStore._setProfileField(key, value);
            if (!fromUpstream.booleanValue()) {
                LocalDataStore.updateLocalProfileKeyExpiryTime(context, key);
            }
        }
        catch (Throwable t) {
            // empty catch block
        }
        LocalDataStore.persistLocalProfileAsync(context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void _setProfileField(String key, Object value) {
        if (key == null || value == null) {
            return;
        }
        HashMap<String, Object> hashMap = PROFILE_FIELDS_IN_THIS_SESSION;
        synchronized (hashMap) {
            PROFILE_FIELDS_IN_THIS_SESSION.put(key, value);
        }
    }

    static void removeProfileFields(Context context, ArrayList<String> fields) {
        if (fields == null) {
            return;
        }
        LocalDataStore.removeProfileFields(context, fields, false);
    }

    static void removeProfileFields(Context context, ArrayList<String> fields, Boolean fromUpstream) {
        if (fields == null) {
            return;
        }
        for (String key : fields) {
            LocalDataStore.removeProfileField(context, key, fromUpstream);
        }
    }

    static void removeProfileField(Context context, String key) {
        LocalDataStore.removeProfileField(context, key, false);
    }

    static void removeProfileField(Context context, String key, Boolean fromUpstream) {
        if (key == null) {
            return;
        }
        try {
            LocalDataStore._removeProfileField(key);
            if (!fromUpstream.booleanValue()) {
                LocalDataStore.updateLocalProfileKeyExpiryTime(context, key);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        LocalDataStore.persistLocalProfileAsync(context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void _removeProfileField(String key) {
        if (key == null) {
            return;
        }
        HashMap<String, Object> hashMap = PROFILE_FIELDS_IN_THIS_SESSION;
        synchronized (hashMap) {
            try {
                PROFILE_FIELDS_IN_THIS_SESSION.remove(key);
            }
            catch (Throwable t) {
                Logger.error("Failed to remove local profile value for key " + key, t);
            }
        }
    }

    private static String getUserProfileID(Context context) {
        return CleverTapAPI.getAccountID(context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void resetLocalProfileSync(Context context) {
        HashMap<String, Object> hashMap = PROFILE_EXPIRY_MAP;
        synchronized (hashMap) {
            PROFILE_EXPIRY_MAP.clear();
        }
        hashMap = PROFILE_FIELDS_IN_THIS_SESSION;
        synchronized (hashMap) {
            PROFILE_FIELDS_IN_THIS_SESSION.clear();
        }
        String accountID = LocalDataStore.getUserProfileID(context);
        dbAdapter.removeUserProfile(accountID);
    }

    private static void inflateLocalProfileAsync(final Context context) {
        final String accountID = LocalDataStore.getUserProfileID(context);
        CleverTapAPI.postAsyncSafely("LocalDataStore#inflateLocalProfileAsync", new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Object object = PROFILE_FIELDS_IN_THIS_SESSION;
                synchronized (object) {
                    try {
                        JSONObject profile = dbAdapter.fetchUserProfileById(accountID);
                        if (profile == null) {
                            return;
                        }
                        Iterator keys = profile.keys();
                        while (keys.hasNext()) {
                            try {
                                String key = (String)keys.next();
                                Object value = profile.get(key);
                                if (value instanceof JSONObject) {
                                    JSONObject jsonObject = profile.getJSONObject(key);
                                    PROFILE_FIELDS_IN_THIS_SESSION.put(key, jsonObject);
                                    continue;
                                }
                                if (value instanceof JSONArray) {
                                    JSONArray jsonArray = profile.getJSONArray(key);
                                    PROFILE_FIELDS_IN_THIS_SESSION.put(key, jsonArray);
                                    continue;
                                }
                                PROFILE_FIELDS_IN_THIS_SESSION.put(key, value);
                            }
                            catch (JSONException e) {}
                        }
                        Logger.logFine("Inflated local profile " + PROFILE_FIELDS_IN_THIS_SESSION.toString());
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
                object = personalizationEnabledLock;
                synchronized (object) {
                    personalizationEnabled = StorageHelper.getBoolean(context, LocalDataStore.PERSONALISATION_ENABLED, false);
                }
            }
        });
    }

    private static void persistLocalProfileAsync(Context context) {
        final String profileID = LocalDataStore.getUserProfileID(context);
        CleverTapAPI.postAsyncSafely("LocalDataStore#persistLocalProfileAsync", new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                HashMap hashMap = PROFILE_FIELDS_IN_THIS_SESSION;
                synchronized (hashMap) {
                    long status = dbAdapter.storeUserProfile(profileID, new JSONObject((Map)PROFILE_FIELDS_IN_THIS_SESSION));
                    Logger.logFine("Persist Local Profile complete with status " + status + " for id " + profileID);
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void updateLocalProfileKeyExpiryTime(Context context, String key) {
        if (key == null) {
            return;
        }
        HashMap<String, Integer> hashMap = PROFILE_EXPIRY_MAP;
        synchronized (hashMap) {
            PROFILE_EXPIRY_MAP.put(key, LocalDataStore.calculateLocalKeyExpiryTime(context));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void removeLocalProfileKeyExpiryTime(String key) {
        if (key == null) {
            return;
        }
        HashMap<String, Integer> hashMap = PROFILE_EXPIRY_MAP;
        synchronized (hashMap) {
            PROFILE_EXPIRY_MAP.remove(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Integer getLocalProfileKeyExpiryTimeForKey(String key) {
        if (key == null) {
            return 0;
        }
        HashMap<String, Integer> hashMap = PROFILE_EXPIRY_MAP;
        synchronized (hashMap) {
            return PROFILE_EXPIRY_MAP.get(key);
        }
    }

    private static int getLocalCacheExpiryInterval(Context context, int defaultInterval) {
        return StorageHelper.getInt(context, "local_cache_expires_in", defaultInterval);
    }

    private static void setLocalCacheExpiryInterval(Context context, int ttl) {
        StorageHelper.putInt(context, "local_cache_expires_in", ttl);
    }

    private static int calculateLocalKeyExpiryTime(Context context) {
        int now = (int)(System.currentTimeMillis() / 1000L);
        return now + LocalDataStore.getLocalCacheExpiryInterval(context, 0);
    }

    private static Boolean shouldPreferLocalProfileUpdateForKeyForTime(String key, int time) {
        int now = time <= 0 ? (int)(System.currentTimeMillis() / 1000L) : time;
        Integer keyValidUntil = LocalDataStore.getLocalProfileKeyExpiryTimeForKey(key);
        return keyValidUntil != null && keyValidUntil > now;
    }

    private static JSONObject buildChangeFromOldValueToNewValue(Object oldValue, Object newValue) {
        if (oldValue == null && newValue == null) {
            return null;
        }
        JSONObject keyUpdates = new JSONObject();
        try {
            Object _newVal = newValue != null ? newValue : Integer.valueOf(-1);
            keyUpdates.put("newValue", _newVal);
            if (oldValue != null) {
                keyUpdates.put("oldValue", oldValue);
            }
        }
        catch (Throwable t) {
            Logger.logFine("Failed to create profile changed values object", t);
            return null;
        }
        return keyUpdates;
    }

    private static Boolean profileValueIsEmpty(Object value) {
        if (value == null) {
            return true;
        }
        Boolean isEmpty = false;
        if (value instanceof String) {
            isEmpty = ((String)value).trim().length() == 0;
        }
        if (value instanceof JSONArray) {
            isEmpty = ((JSONArray)value).length() <= 0;
        }
        return isEmpty;
    }

    private static Boolean profileValuesAreEqual(Object value1, Object value2) {
        return LocalDataStore.stringify(value1).equals(LocalDataStore.stringify(value2));
    }

    private static String stringify(Object value) {
        return value == null ? "" : value.toString();
    }
}

