/*
 * Decompiled with CFR 0.152.
 */
package com.clevertap.android.sdk;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.support.v4.content.ContextCompat;
import com.clevertap.android.sdk.CleverTapAPI;
import com.clevertap.android.sdk.Logger;
import com.clevertap.android.sdk.StorageHelper;
import com.clevertap.android.sdk.SyncListener;
import com.clevertap.android.sdk.exceptions.CleverTapException;
import com.clevertap.android.sdk.exceptions.CleverTapPermissionsNotSatisfied;
import java.util.UUID;

final class DeviceInfo {
    private static String tmpProfileID = null;
    private static final Object deviceIDLock = new Object();
    private static boolean notifiedAboutPermanentGUID = false;

    DeviceInfo() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static String getDeviceID(final Context context, boolean autoGenerateIfRequired, boolean makeAutoGeneratedGUIDPermanent) {
        Object object = deviceIDLock;
        synchronized (object) {
            String trueID = StorageHelper.getString(context, "deviceId", null);
            if (autoGenerateIfRequired && (trueID == null || trueID.trim().equals(""))) {
                if (tmpProfileID == null) {
                    tmpProfileID = UUID.randomUUID().toString().replace("-", "");
                    tmpProfileID = "__" + tmpProfileID;
                }
                trueID = tmpProfileID;
                if (makeAutoGeneratedGUIDPermanent) {
                    DeviceInfo.forceUpdateDeviceId(context, trueID);
                }
            }
            if (!notifiedAboutPermanentGUID && makeAutoGeneratedGUIDPermanent) {
                notifiedAboutPermanentGUID = true;
                final String finalTrueID = trueID;
                CleverTapAPI.postAsyncSafely("DeviceInfo#getDeviceID-notify-listener", new Runnable(){

                    @Override
                    public void run() {
                        try {
                            SyncListener sl = CleverTapAPI.getInstance(context).getSyncListener();
                            if (sl != null) {
                                sl.profileDidInitialize(finalTrueID);
                            }
                        }
                        catch (CleverTapException cleverTapException) {
                            // empty catch block
                        }
                    }
                });
            }
            return trueID;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SuppressLint(value={"CommitPrefEdits"})
    static void updateDeviceIdIfRequired(Context context) {
        String deviceID = DeviceInfo.getDeviceID(context, false, false);
        if (deviceID != null) {
            return;
        }
        String foundDeviceID = null;
        String adID = CleverTapAPI.getGoogleAdID();
        if (adID != null && adID.trim().length() > 2) {
            foundDeviceID = "__g" + adID;
        }
        if (foundDeviceID != null) {
            Object object = deviceIDLock;
            synchronized (object) {
                String currentGUID = DeviceInfo.getDeviceID(context, false, false);
                if (currentGUID != null && currentGUID.trim().length() > 2) {
                    Logger.error("The SDK has found an existing device ID, but wasn't able to use it as one has already been set!");
                    return;
                }
                DeviceInfo.forceUpdateDeviceId(context, foundDeviceID);
                Logger.logExtraFine("Retrieved a GUID for this installation - " + foundDeviceID);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SuppressLint(value={"CommitPrefEdits"})
    static void forceUpdateDeviceId(Context context, String id) {
        Logger.logExtraFine("Force updating the device ID to " + id);
        Object object = deviceIDLock;
        synchronized (object) {
            StorageHelper.putString(context, "deviceId", id);
        }
    }

    static void testPermission(Context context, String permission) throws CleverTapPermissionsNotSatisfied {
        if (!DeviceInfo.hasPermission(context, permission)) {
            throw new CleverTapPermissionsNotSatisfied("Permission required: " + permission);
        }
    }

    static boolean hasPermission(Context context, String permission) {
        try {
            return 0 == ContextCompat.checkSelfPermission((Context)context, (String)permission);
        }
        catch (Throwable t) {
            return false;
        }
    }

    static int getAppIconAsIntId(Context context) {
        ApplicationInfo ai = context.getApplicationInfo();
        return ai.icon;
    }
}

