/*
 * Decompiled with CFR 0.152.
 */
package com.clevertap.android.sdk;

import android.content.Context;
import android.content.SharedPreferences;
import android.net.Uri;
import android.util.Base64;
import com.clevertap.android.sdk.BuildInfo;
import com.clevertap.android.sdk.Logger;
import com.clevertap.android.sdk.ManifestMetaData;
import com.clevertap.android.sdk.StorageHelper;
import com.clevertap.android.sdk.exceptions.CleverTapMetaDataNotFoundException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.json.JSONObject;

final class Constants {
    static final boolean ENABLE_INAPP = true;
    static final String LABEL_ACCOUNT_ID = "CLEVERTAP_ACCOUNT_ID";
    static final String LABEL_PRIVACY_MODE = "CLEVERTAP_PRIVACY_MODE";
    static final String LABEL_TOKEN = "CLEVERTAP_TOKEN";
    static final String LABEL_PARSE = "CLEVERTAP_PARSE";
    static final String LABEL_NOTIFICATION_ICON = "CLEVERTAP_NOTIFICATION_ICON";
    static final String LABEL_INAPP_EXCLUDE = "CLEVERTAP_INAPP_EXCLUDE";
    static final String PRIVACY_MODE_DISABLE_EMAIL = "DE";
    static final String PRIVACY_MODE_DISABLE_LOCATION = "DL";
    static final String CLEVERTAP_STORAGE_TAG = "WizRocket";
    static final String CLEVERTAP_LOG_TAG = "CleverTap";
    static final int SESSION_LENGTH_MINS = 20;
    static final String DEVICE_ID_TAG = "deviceId";
    static final SimpleDateFormat FB_DOB_DATE_FORMAT = new SimpleDateFormat("MM/dd/yyyy", Locale.US);
    static final SimpleDateFormat GP_DOB_DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd", Locale.US);
    static final SimpleDateFormat DOB_DATE_FORMAT = new SimpleDateFormat("yyyyMMdd", Locale.US);
    static final int PAGE_EVENT = 1;
    static final int PING_EVENT = 2;
    static final int PROFILE_EVENT = 3;
    static final int RAISED_EVENT = 4;
    static final int DATA_EVENT = 5;
    static final int META_EVENT = 6;
    static final String ICON_BASE_URL = "http://static.wizrocket.com/android/ico/";
    static final String GCM_PROPERTY_REG_ID = "registration_id";
    static final String NOTIFICATION_CLICKED_EVENT_NAME = "Notification Clicked";
    static final String NOTIFICATION_VIEWED_EVENT_NAME = "Notification Viewed";
    static final String APP_LAUNCHED_EVENT = "App Launched";
    static final String ERROR_KEY = "wzrk_error";
    static final int PUSH_DELAY_MS = 1000;
    static final String GCM_ENABLE = "gcm_enable";
    static final int PING_TICK_INTERVAL = 1000;
    static final String INAPP_PREVIEW_PUSH_PAYLOAD_KEY = "wzrk_inapp";
    static final String INAPP_DATA_TAG = "html";
    static final String INAPP_X_PERCENT = "xp";
    static final String INAPP_Y_PERCENT = "yp";
    static final String INAPP_X_DP = "xdp";
    static final String INAPP_Y_DP = "ydp";
    static final String INAPP_POSITION = "pos";
    static final char INAPP_POSITION_TOP = 't';
    static final char INAPP_POSITION_RIGHT = 'r';
    static final char INAPP_POSITION_BOTTOM = 'b';
    static final char INAPP_POSITION_LEFT = 'l';
    static final char INAPP_POSITION_CENTER = 'c';
    static final String INAPP_NOTIF_DARKEN_SCREEN = "dk";
    static final String INAPP_NOTIF_SHOW_CLOSE = "sc";
    static final String INAPP_JSON_RESPONSE_KEY = "inapp_notifs";
    static final String INAPP_MAX_DISPLAY_COUNT = "mdc";
    static final String INAPP_MAX_PER_SESSION = "imc";
    static final String INAPP_WINDOW = "w";
    static final String PREFS_INAPP_KEY = "inApp";
    static final int INAPP_CLOSE_IV_WIDTH = 40;
    static final String DEBUG_KEY = "d";
    static final String NOTIFICATION_ID_TAG = "wzrk_id";
    static final String DEEP_LINK_KEY = "wzrk_dl";
    static final String WZRK_PREFIX = "wzrk_";
    static final String NOTIFICATION_RECEIVED_EPOCH_TAG = "wzrk_rts";
    static final String NOTIFICATION_CLICKED_INTERVAL_TAG = "wzrk_dts";
    static final int DEBUG_FINEST = 1277182231;
    static final int PING_INTERVAL_IN_SECONDS = 20;
    static final int PING_INTERVAL_FIRST_SESSION_IN_SECONDS = 5;
    static final int LOCATION_PING_INTERVAL_IN_SECONDS = 10;
    static final String GP_NAME = "gpName";
    static final String GP_RELATIONSHIP_STATUS = "gpRS";
    static final String GP_DOB = "gpDOB";
    static final String GP_EMPLOYED = "gpEmployed";
    static final String GP_ID = "gpID";
    static final String GP_GENDER = "gpGender";
    static final String FB_NAME = "fbName";
    static final String FB_EMAIL = "fbEmail";
    static final String FB_EDUCATION = "fbEducation";
    static final String FB_RELATIONSHIP_STATUS = "fbRS";
    static final String FB_DOB = "fbDOB";
    static final String FB_EMPLOYED = "fbEmployed";
    static final String FB_ID = "fbID";
    static final String FB_GENDER = "fbGender";
    static final String USER_NAME = "userName";
    static final String USER_EMAIL = "userEmail";
    static final String USER_EDUCATION = "userEducation";
    static final String USER_RELATIONSHIP_STATUS = "userRS";
    static final String USER_DOB = "userDOB";
    static final String USER_EMPLOYED = "userEmployed";
    static final String USER_GENDER = "userGender";
    static final String USER_PHONE = "userPhone";
    static final String USER_AGE = "userAge";
    static final String SYSTEM_EMAIL = "systemEmail";
    static final String SYSTEM_CARRIER = "systemCarrier";
    static final String SYSTEM_COUNTRY_CODE = "systemCountryCode";
    static final String SYSTEM_TIMEZONE = "systemTimezone";
    static final String ADVERTISER_ID = "adid";
    static final String SESSION_ID_LAST = "lastSessionId";
    static final String SESSION_LAST_PING_EPOCH = "sexe";
    static final String SESSION_LAST_ACTIVITY_TRAIL = "slat";
    static final String LABEL_SENDER_ID = "GCM_SENDER_ID";
    static final String COMMAND_SET = "$set";
    static final String COMMAND_ADD = "$add";
    static final String COMMAND_REMOVE = "$remove";
    static final Set<String> MULTI_VALUE_COMMANDS = new HashSet<String>(Arrays.asList("$set", "$add", "$remove"));
    static final String COMMAND_DELETE = "$delete";
    static final String GUID_PREFIX_GOOGLE_AD_ID = "__g";

    Constants() {
    }

    static String getEndpoint(Context context) {
        String endpoint = "https://wzrkt.com/a1?os=Android&t=" + BuildInfo.SDK_SVN_REVISION;
        try {
            endpoint = endpoint + "&z=" + ManifestMetaData.getMetaData(context, LABEL_ACCOUNT_ID);
        }
        catch (CleverTapMetaDataNotFoundException ignore) {
            // empty catch block
        }
        try {
            String encoded;
            JSONObject arp = Constants.getAdditionalRequestParameters(context);
            if (arp != null && arp.length() > 0 && (encoded = Uri.encode((String)Base64.encodeToString((byte[])arp.toString().getBytes("UTF-8"), (int)0))) != null && encoded.length() > 1) {
                endpoint = endpoint + "&arp=" + encoded;
            }
        }
        catch (Throwable t) {
            Logger.error("Failed to attach ARP", t);
        }
        endpoint = endpoint + "&ts=" + (int)(System.currentTimeMillis() / 1000L);
        Logger.logFine("Using endpoint " + endpoint);
        return endpoint;
    }

    static JSONObject getAdditionalRequestParameters(Context context) {
        try {
            SharedPreferences prefs = StorageHelper.getPreferences(context, "ARP");
            Map all = prefs.getAll();
            Iterator iter = all.entrySet().iterator();
            while (iter.hasNext()) {
                Map.Entry kv = iter.next();
                Object o = kv.getValue();
                if (!(o instanceof Number) || ((Number)o).intValue() != -1) continue;
                iter.remove();
            }
            return new JSONObject(all);
        }
        catch (Throwable t) {
            Logger.logFine("Failed to construct ARP object", t);
            return null;
        }
    }
}

