/*
 * Decompiled with CFR 0.152.
 */
package com.clevertap.android.sdk;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.Intent;
import android.content.SharedPreferences;
import android.os.Bundle;
import com.clevertap.android.sdk.CleverTapAPI;
import com.clevertap.android.sdk.InAppFCManager;
import com.clevertap.android.sdk.InAppNotificationActivity;
import com.clevertap.android.sdk.Logger;
import com.clevertap.android.sdk.StorageHelper;
import java.util.ArrayList;
import java.util.Iterator;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

@SuppressLint(value={"CommitPrefEdits"})
public final class InAppManager {
    private InAppManager() {
    }

    private static void createAndShow(Context context, JSONObject inapp, Bundle notif) {
        if (!CleverTapAPI.isAppForeground()) {
            Logger.error("Cannot show in-app notification. App isn't in foreground. Please check your integration if your app is actually in foreground.");
            return;
        }
        if (!InAppFCManager.canShow(context, inapp)) {
            Logger.logFine("InAppFCManager rejected an inapp");
            return;
        }
        InAppFCManager.didShow(context, inapp);
        Logger.logFine("Will show new notification shortly: " + notif.toString());
        if (!InAppManager.validateNotifBundle(notif)) {
            Logger.logFine("Notification was not formatted correctly. Discarding");
            return;
        }
        Intent i = new Intent(context, InAppNotificationActivity.class);
        i.putExtras(notif);
        try {
            if (CleverTapAPI.currentActivity == null) {
                throw new IllegalStateException("Current activity reference not found");
            }
            CleverTapAPI.currentActivity.startActivity(i);
        }
        catch (Throwable t) {
            Logger.error("InAppManager: Please verify the integration of your app. It is not setup to support in-app notifications yet.", t);
        }
    }

    static void processResponseAsync(final JSONObject response, final Context context) {
        CleverTapAPI.postAsyncSafely("InAppManager#processResponseAsync", new Runnable(){

            @Override
            public void run() {
                try {
                    InAppManager.processResponse(response, context);
                }
                catch (Throwable t) {
                    Logger.error("Failed to process response!", t);
                }
            }
        });
    }

    private static void processResponse(JSONObject response, Context context) {
        try {
            JSONArray inappNotifs;
            Logger.logFine("InAppManager: Processing response");
            if (!response.has("inapp_notifs")) {
                Logger.logFine("InAppManager: Response JSON object doesn't contain the inapp key, bailing");
                return;
            }
            int perSession = 10;
            int perDay = 10;
            if (response.has("imc") && response.get("imc") instanceof Integer) {
                perSession = response.getInt("imc");
            }
            if (response.has("imp") && response.get("imp") instanceof Integer) {
                perDay = response.getInt("imp");
            }
            InAppFCManager.updateLimits(context, perDay, perSession);
            try {
                inappNotifs = response.getJSONArray("inapp_notifs");
            }
            catch (JSONException e) {
                Logger.logFine("InAppManager: In-app key didn't contain a valid JSON array");
                return;
            }
            SharedPreferences prefs = StorageHelper.getPreferences(context);
            SharedPreferences.Editor editor = prefs.edit();
            try {
                JSONArray inappsFromPrefs = new JSONArray(prefs.getString("inApp", "[]"));
                if (inappNotifs != null && inappNotifs.length() > 0) {
                    for (int i = 0; i < inappNotifs.length(); ++i) {
                        try {
                            JSONObject inappNotif = inappNotifs.getJSONObject(i);
                            inappsFromPrefs.put((Object)inappNotif);
                            continue;
                        }
                        catch (JSONException e) {
                            Logger.logFine("InAppManager: Malformed inapp notification");
                        }
                    }
                }
                editor.putString("inApp", inappsFromPrefs.toString());
                StorageHelper.persist(editor);
            }
            catch (Throwable e) {
                Logger.logFine("InAppManager: Failed to parse the in-app notifications properly");
                Logger.error("InAppManager: Reason: " + e.getMessage(), e);
            }
            InAppManager.showNotificationIfAvailable(context);
        }
        catch (Throwable t) {
            Logger.error("InAppManager: Failed to parse response", t);
        }
    }

    public static void showNotificationIfAvailable(Context context) {
        SharedPreferences prefs = StorageHelper.getPreferences(context);
        try {
            JSONArray inapps = new JSONArray(prefs.getString("inApp", "[]"));
            if (inapps.length() < 1) {
                return;
            }
            ArrayList<Integer> indicesToIgnore = new ArrayList<Integer>();
            int qualifiedIndex = -1;
            for (int i = 0; i < inapps.length(); ++i) {
                JSONObject inapp = inapps.getJSONObject(i);
                if (InAppFCManager.canShow(context, inapp)) {
                    qualifiedIndex = i;
                    break;
                }
                indicesToIgnore.add(i);
            }
            if (qualifiedIndex != -1) {
                InAppManager.createAndShow(context, inapps.getJSONObject(qualifiedIndex), InAppManager.getBundleFromJsonObject(inapps.getJSONObject(qualifiedIndex)));
            }
            JSONArray inappsUpdated = new JSONArray();
            for (int i = 0; i < inapps.length(); ++i) {
                if (indicesToIgnore.contains(i) || qualifiedIndex == i) continue;
                inappsUpdated.put(inapps.get(i));
            }
            SharedPreferences.Editor editor = prefs.edit().putString("inApp", inappsUpdated.toString());
            StorageHelper.persist(editor);
        }
        catch (Throwable t) {
            Logger.logFine("InAppManager: Couldn't parse JSON array string from prefs", t);
        }
    }

    private static boolean validateNotifBundle(Bundle notif) {
        if (!InAppManager.isKeyValid(notif, "xdp", Integer.class) && !InAppManager.isKeyValid(notif, "xp", Integer.class)) {
            return false;
        }
        if (!InAppManager.isKeyValid(notif, "ydp", Integer.class) && !InAppManager.isKeyValid(notif, "yp", Integer.class)) {
            return false;
        }
        if (!InAppManager.isKeyValid(notif, "dk", Boolean.class)) {
            return false;
        }
        if (!InAppManager.isKeyValid(notif, "sc", Boolean.class)) {
            return false;
        }
        if (!InAppManager.isKeyValid(notif, "html", String.class)) {
            return false;
        }
        if (InAppManager.isKeyValid(notif, "pos", String.class)) {
            char pos = notif.getString("pos").charAt(0);
            switch (pos) {
                case 't': {
                    break;
                }
                case 'r': {
                    break;
                }
                case 'b': {
                    break;
                }
                case 'l': {
                    break;
                }
                case 'c': {
                    break;
                }
                default: {
                    return false;
                }
            }
        } else {
            return false;
        }
        return true;
    }

    private static boolean isKeyValid(Bundle b, String key, Class<?> type) {
        return b.containsKey(key) && b.get(key).getClass().equals(type);
    }

    private static Bundle getBundleFromJsonObject(JSONObject notif) {
        Bundle b = new Bundle();
        Iterator iterator = notif.keys();
        while (iterator.hasNext()) {
            String key = (String)iterator.next();
            try {
                Object value = notif.get(key);
                if (value instanceof String) {
                    b.putString(key, (String)value);
                    continue;
                }
                if (value instanceof Character) {
                    b.putChar(key, ((Character)value).charValue());
                    continue;
                }
                if (value instanceof Integer) {
                    b.putInt(key, ((Integer)value).intValue());
                    continue;
                }
                if (value instanceof Float) {
                    b.putFloat(key, ((Float)value).floatValue());
                    continue;
                }
                if (value instanceof Double) {
                    b.putDouble(key, ((Double)value).doubleValue());
                    continue;
                }
                if (value instanceof Long) {
                    b.putLong(key, ((Long)value).longValue());
                    continue;
                }
                if (value instanceof Boolean) {
                    b.putBoolean(key, ((Boolean)value).booleanValue());
                    continue;
                }
                if (!(value instanceof JSONObject)) continue;
                b.putAll(InAppManager.getBundleFromJsonObject((JSONObject)value));
            }
            catch (JSONException e) {
                Logger.logFine("InAppManager: Key had foreign object. Discarding");
            }
        }
        return b;
    }
}

