
package com.clevertap.android.sdk;

import android.content.Context;

import java.io.*;
import java.nio.charset.Charset;

final class ParseUtils {

    public static String getParseInstallationId(Context context) {
        String installationId = null;

        try {
            File e = new File(context.getDir("Parse", 0), "installationId");
            installationId = readFileToString(e, "UTF-8");
        } catch (FileNotFoundException var3) {
            Logger.logFine("Couldn\'t find existing installationId file.");
        } catch (IOException var4) {
            Logger.logFine("Unexpected exception reading installation id from disk", var4);
        }

        return installationId;
    }

    private static String readFileToString(File file, Charset encoding) throws IOException {
        return new String(readFileToByteArray(file), encoding);
    }

    private static String readFileToString(File file, String encoding) throws IOException {
        return readFileToString(file, Charset.forName(encoding));
    }

    private static byte[] readFileToByteArray(File file) throws IOException {
        FileInputStream in = null;

        byte[] var2;
        try {
            in = openInputStream(file);
            var2 = toByteArray(in);
        } finally {
            closeQuietly(in);
        }

        return var2;
    }

    private static byte[] toByteArray(InputStream input) throws IOException {
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        copy(input, output);
        return output.toByteArray();
    }


    private static FileInputStream openInputStream(File file) throws IOException {
        if (file.exists()) {
            if (file.isDirectory()) {
                throw new IOException("File \'" + file + "\' exists but is a directory");
            } else if (!file.canRead()) {
                throw new IOException("File \'" + file + "\' cannot be read");
            } else {
                return new FileInputStream(file);
            }
        } else {
            throw new FileNotFoundException("File \'" + file + "\' does not exist");
        }
    }

    private static void closeQuietly(InputStream input) {
        try {
            if (input != null) {
                input.close();
            }
        } catch (IOException ignored) {
        }
    }

    private static int copy(InputStream input, OutputStream output) throws IOException {
        long count = copyLarge(input, output, new byte[4096]);
        return count > 2147483647L ? -1 : (int) count;
    }

    private static long copyLarge(InputStream input, OutputStream output, byte[] buffer) throws IOException {
        long count = 0L;

        int n1;
        for (boolean n = false; -1 != (n1 = input.read(buffer)); count += (long) n1) {
            output.write(buffer, 0, n1);
        }

        return count;
    }
}
