/*
 * Decompiled with CFR 0.152.
 */
package com.clevertap.android.sdk;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.SharedPreferences;
import com.clevertap.android.sdk.CleverTapAPI;
import com.clevertap.android.sdk.EventDetail;
import com.clevertap.android.sdk.Logger;
import com.clevertap.android.sdk.StorageHelper;
import com.clevertap.android.sdk.SyncListener;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONObject;

final class LocalDataStore {
    private static final String profileNamespace = "local_profile";
    private static final String eventNamespace = "local_events";
    private static final String PERSONALISATION_ENABLED = "personalisationEnabledBool";
    private static final HashMap<String, Integer> PROFILE_EXPIRY_MAP = new HashMap();

    LocalDataStore() {
    }

    static void setPersonalisationEnabled(Context context, boolean enable) {
        StorageHelper.putBoolean(context, PERSONALISATION_ENABLED, enable);
    }

    static boolean isPersonalisationEnabled(Context context) {
        return StorageHelper.getBoolean(context, PERSONALISATION_ENABLED, false);
    }

    static void setDataSyncFlag(Context context, JSONObject event) {
        try {
            String evtName;
            boolean enablePersonalisation = StorageHelper.getBoolean(context, PERSONALISATION_ENABLED, false);
            if (!enablePersonalisation) {
                event.put("dsync", false);
                return;
            }
            String eventType = event.getString("type");
            if ("event".equals(eventType) && "App Launched".equals(evtName = event.getString("evtName"))) {
                Logger.logFine("Local cache needs to be updated (triggered by App Launched)");
                event.put("dsync", true);
                return;
            }
            if ("profile".equals(eventType)) {
                event.put("dsync", true);
                Logger.logFine("Local cache needs to be updated (profile event)");
                return;
            }
            int now = (int)(System.currentTimeMillis() / 1000L);
            int expiresIn = StorageHelper.getInt(context, "local_cache_expires_in", 1200);
            int lastUpdate = StorageHelper.getInt(context, "local_cache_last_update", now);
            if (lastUpdate + expiresIn < now) {
                event.put("dsync", true);
                Logger.logFine("Local cache needs to be updated");
            } else {
                event.put("dsync", false);
                Logger.logFine("Local cache doesn't need to be updated");
            }
        }
        catch (Throwable t) {
            Logger.error("Failed to sync with upstream", t);
        }
    }

    private static int getTTL(Context context) {
        return StorageHelper.getInt(context, "local_cache_expires_in", 1200);
    }

    private static void setTTL(Context context, int ttl) {
        StorageHelper.putInt(context, "local_cache_expires_in", ttl);
    }

    static void persistEvent(Context context, JSONObject event, int type) {
        try {
            if (event == null) {
                return;
            }
            if (type == 4) {
                LocalDataStore.persistEvent(context, event);
            } else if (type == 3) {
                LocalDataStore.persistProfile(context, event, false);
            }
        }
        catch (Throwable t) {
            Logger.error("Failed to sync with upstream", t);
        }
    }

    static void syncWithUpstream(Context context, JSONObject response) {
        try {
            JSONObject eventUpdates = null;
            JSONObject profileUpdates = null;
            if (!response.has("evpr")) {
                return;
            }
            JSONObject evpr = response.getJSONObject("evpr");
            if (evpr.has("profile")) {
                JSONObject profile = evpr.getJSONObject("profile");
                if (profile.has("_custom")) {
                    JSONObject custom = profile.getJSONObject("_custom");
                    profile.remove("_custom");
                    Iterator keys = custom.keys();
                    while (keys.hasNext()) {
                        String next = keys.next().toString();
                        profile.put(next, custom.get(next));
                    }
                }
                JSONObject wrapper = new JSONObject();
                wrapper.put("profile", (Object)profile);
                profileUpdates = LocalDataStore.persistProfile(context, wrapper, true);
            }
            if (evpr.has("events")) {
                eventUpdates = LocalDataStore.syncEventsFromUpstream(context, evpr.getJSONObject("events"));
            }
            if (evpr.has("expires_in")) {
                int expiresIn = evpr.getInt("expires_in");
                LocalDataStore.setTTL(context, expiresIn);
            }
            StorageHelper.putInt(context, "local_cache_last_update", (int)(System.currentTimeMillis() / 1000L));
            if (profileUpdates != null || eventUpdates != null) {
                SyncListener syncListener;
                JSONObject updates = new JSONObject();
                if (profileUpdates != null) {
                    updates.put("profile", (Object)profileUpdates);
                }
                if (eventUpdates != null) {
                    updates.put("events", (Object)eventUpdates);
                }
                if ((syncListener = CleverTapAPI.getInstance(context).getSyncListener()) != null) {
                    try {
                        syncListener.profileDataUpdated(updates);
                    }
                    catch (Throwable t) {
                        Logger.error("Execution of sync listener failed", t);
                    }
                }
            }
        }
        catch (Throwable t) {
            Logger.error("Failed to sync with upstream", t);
        }
    }

    @SuppressLint(value={"CommitPrefEdits"})
    private static JSONObject syncEventsFromUpstream(Context context, JSONObject events) {
        try {
            JSONObject eventUpdates = null;
            SharedPreferences prefs = StorageHelper.getPreferences(context, eventNamespace);
            Iterator keys = events.keys();
            SharedPreferences.Editor editor = prefs.edit();
            while (keys.hasNext()) {
                int last;
                int first;
                int upstreamCount;
                String event = keys.next().toString();
                String encoded = prefs.getString(event, LocalDataStore.encodeEventDetails(0, 0, 0));
                EventDetail ed = LocalDataStore.decodeEventDetails(event, encoded);
                JSONArray upstream = events.getJSONArray(event);
                if (upstream == null || upstream.length() < 3) {
                    Logger.error("Corrupted upstream event detail");
                    continue;
                }
                try {
                    upstreamCount = upstream.getInt(0);
                    first = upstream.getInt(1);
                    last = upstream.getInt(2);
                }
                catch (Throwable t) {
                    Logger.error("Failed to parse upstream event message: " + upstream.toString());
                    continue;
                }
                if (upstreamCount > ed.getCount()) {
                    editor.putString(event, LocalDataStore.encodeEventDetails(first, last, upstreamCount));
                    Logger.logFine("Accepted update for event " + event + " from upstream");
                    try {
                        if (eventUpdates == null) {
                            eventUpdates = new JSONObject();
                        }
                        JSONObject evUpdate = new JSONObject();
                        JSONObject countUpdate = new JSONObject();
                        countUpdate.put("oldValue", ed.getCount());
                        countUpdate.put("newValue", upstreamCount);
                        evUpdate.put("count", (Object)countUpdate);
                        JSONObject firstUpdate = new JSONObject();
                        firstUpdate.put("oldValue", ed.getFirstTime());
                        firstUpdate.put("newValue", upstream.getInt(1));
                        evUpdate.put("firstTime", (Object)firstUpdate);
                        JSONObject lastUpdate = new JSONObject();
                        lastUpdate.put("oldValue", ed.getLastTime());
                        lastUpdate.put("newValue", upstream.getInt(2));
                        evUpdate.put("lastTime", (Object)lastUpdate);
                        eventUpdates.put(event, (Object)evUpdate);
                    }
                    catch (Throwable t) {
                        Logger.error("Couldn't set event updates", t);
                    }
                    continue;
                }
                Logger.logFine("Rejected update for event " + event + " from upstream");
            }
            StorageHelper.persist(editor);
            return eventUpdates;
        }
        catch (Throwable t) {
            Logger.error("Couldn't sync events from upstream", t);
            return null;
        }
    }

    @SuppressLint(value={"CommitPrefEdits"})
    private static JSONObject persistProfile(Context context, JSONObject event, boolean syncFromUpstream) {
        try {
            JSONObject profileUpdates = null;
            JSONObject profile = event.getJSONObject("profile");
            if (profile == null || profile.length() == 0) {
                return null;
            }
            SharedPreferences prefs = StorageHelper.getPreferences(context, profileNamespace);
            SharedPreferences.Editor editor = prefs.edit();
            int now = (int)(System.currentTimeMillis() / 1000L);
            int validUntil = now + LocalDataStore.getTTL(context);
            Iterator keys = profile.keys();
            while (keys.hasNext()) {
                try {
                    String key = keys.next().toString();
                    String oldValue = prefs.getString(key, null);
                    String newValue = profile.get(key).toString();
                    if (syncFromUpstream) {
                        Integer keyValidUntil = PROFILE_EXPIRY_MAP.get(key);
                        if (keyValidUntil != null && now < keyValidUntil) {
                            Logger.logFine("Rejecting upstream value for key " + key + " " + "because our local cache prohibits it");
                            continue;
                        }
                    } else {
                        PROFILE_EXPIRY_MAP.put(key, validUntil);
                    }
                    editor.putString(key, profile.get(key).toString());
                    if (oldValue != null && newValue.equals(oldValue)) continue;
                    try {
                        if (profileUpdates == null) {
                            profileUpdates = new JSONObject();
                        }
                        JSONObject keyUpdates = new JSONObject();
                        if (oldValue != null) {
                            keyUpdates.put("oldValue", (Object)oldValue);
                        }
                        keyUpdates.put("newValue", (Object)newValue);
                        profileUpdates.put(key, (Object)keyUpdates);
                    }
                    catch (Throwable t) {
                        Logger.logFine("Failed to set profile updates", t);
                    }
                }
                catch (Throwable t) {
                    Logger.logFine("Failed to update profile field", t);
                }
            }
            StorageHelper.persist(editor);
            return profileUpdates;
        }
        catch (Throwable t) {
            Logger.error("Failed to persist profile locally", t);
            return null;
        }
    }

    @SuppressLint(value={"CommitPrefEdits"})
    private static void persistEvent(Context context, JSONObject event) {
        try {
            String evtName = event.getString("evtName");
            if (evtName == null) {
                return;
            }
            SharedPreferences prefs = StorageHelper.getPreferences(context, eventNamespace);
            int now = (int)(System.currentTimeMillis() / 1000L);
            String encoded = prefs.getString(evtName, LocalDataStore.encodeEventDetails(now, now, 0));
            EventDetail ed = LocalDataStore.decodeEventDetails(evtName, encoded);
            String updateEncoded = LocalDataStore.encodeEventDetails(ed.getFirstTime(), now, ed.getCount() + 1);
            SharedPreferences.Editor editor = prefs.edit();
            editor.putString(evtName, updateEncoded);
            StorageHelper.persist(editor);
        }
        catch (Throwable t) {
            Logger.error("Failed to persist event locally", t);
        }
    }

    private static String encodeEventDetails(int first, int last, int count) {
        return count + "|" + first + "|" + last;
    }

    private static EventDetail decodeEventDetails(String name, String encoded) {
        if (encoded == null) {
            return null;
        }
        String[] parts = encoded.split("\\|");
        return new EventDetail(Integer.parseInt(parts[0]), Integer.parseInt(parts[1]), Integer.parseInt(parts[2]), name);
    }

    static Map<String, EventDetail> getEventHistory(Context context) {
        try {
            SharedPreferences prefs = StorageHelper.getPreferences(context, eventNamespace);
            Map all = prefs.getAll();
            HashMap<String, EventDetail> out = new HashMap<String, EventDetail>();
            for (String eventName : all.keySet()) {
                out.put(eventName, LocalDataStore.decodeEventDetails(eventName, all.get(eventName).toString()));
            }
            return out;
        }
        catch (Throwable t) {
            Logger.error("Failed to retrieve local event history", t);
            return null;
        }
    }

    static EventDetail getEventDetail(Context context, String eventName) {
        try {
            if (!LocalDataStore.isPersonalisationEnabled(context)) {
                return null;
            }
            SharedPreferences prefs = StorageHelper.getPreferences(context, eventNamespace);
            return LocalDataStore.decodeEventDetails(eventName, prefs.getString(eventName, null));
        }
        catch (Throwable t) {
            Logger.error("Failed to retrieve local event detail", t);
            return null;
        }
    }

    static String getProfileProperty(Context context, String key) {
        try {
            if (!LocalDataStore.isPersonalisationEnabled(context)) {
                return null;
            }
            SharedPreferences prefs = StorageHelper.getPreferences(context, profileNamespace);
            return prefs.getString(key, null);
        }
        catch (Throwable t) {
            Logger.error("Failed to retrieve local profile property", t);
            return null;
        }
    }
}

