/*
 * Decompiled with CFR 0.152.
 */
package com.clevertap.android.sdk;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import com.clevertap.android.sdk.CleverTapAPI;
import com.clevertap.android.sdk.Logger;
import com.clevertap.android.sdk.SessionHandler;
import com.clevertap.android.sdk.Validator;
import com.clevertap.android.sdk.exceptions.CleverTapMetaDataNotFoundException;
import com.clevertap.android.sdk.exceptions.CleverTapPermissionsNotSatisfied;
import org.json.JSONObject;

public final class InstallReferrerBroadcastReceiver
extends BroadcastReceiver {
    public void onReceive(Context context, Intent intent) {
        try {
            CleverTapAPI wr = CleverTapAPI.getInstance(context);
            wr.pushInstallReferrer(intent);
        }
        catch (CleverTapMetaDataNotFoundException ignore) {
        }
        catch (CleverTapPermissionsNotSatisfied cleverTapPermissionsNotSatisfied) {
            // empty catch block
        }
    }

    static JSONObject getUrchinFromUri(Context context, Uri uri) {
        JSONObject referrer = new JSONObject();
        try {
            String source = InstallReferrerBroadcastReceiver.getUtmOrWzrkValue("source", uri);
            String medium = InstallReferrerBroadcastReceiver.getUtmOrWzrkValue("medium", uri);
            String campaign = InstallReferrerBroadcastReceiver.getUtmOrWzrkValue("campaign", uri);
            SessionHandler cfr_ignored_0 = CleverTapAPI.getInstance((Context)context).session;
            SessionHandler.setSource(source);
            SessionHandler cfr_ignored_1 = CleverTapAPI.getInstance((Context)context).session;
            SessionHandler.setMedium(medium);
            SessionHandler cfr_ignored_2 = CleverTapAPI.getInstance((Context)context).session;
            SessionHandler.setCampaign(campaign);
            referrer.put("us", (Object)source);
            referrer.put("um", (Object)medium);
            referrer.put("uc", (Object)campaign);
            String wm = InstallReferrerBroadcastReceiver.getWzrkValueForKey("medium", uri);
            if (wm != null && wm.matches("^email$|^social$|^search$")) {
                referrer.put("wm", (Object)wm);
            }
            Logger.logFine("Referrer data: " + referrer.toString(4));
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return referrer;
    }

    private static String getUtmOrWzrkValue(String utmKey, Uri uri) {
        String value = InstallReferrerBroadcastReceiver.getUtmValueForKey(utmKey, uri);
        if (value != null || (value = InstallReferrerBroadcastReceiver.getWzrkValueForKey(utmKey, uri)) != null) {
            return value;
        }
        return null;
    }

    private static String getWzrkValueForKey(String key, Uri uri) {
        key = "wzrk_" + key;
        return InstallReferrerBroadcastReceiver.getValueForKey(key, uri);
    }

    private static String getUtmValueForKey(String key, Uri uri) {
        key = "utm_" + key;
        return InstallReferrerBroadcastReceiver.getValueForKey(key, uri);
    }

    private static String getValueForKey(String key, Uri uri) {
        if (key == null || uri == null) {
            return null;
        }
        try {
            String value = uri.getQueryParameter(key);
            if (value == null) {
                return null;
            }
            if (value.getBytes("UTF-8").length > 120) {
                return Validator.fastTrim(value, 120);
            }
            return value;
        }
        catch (Throwable t) {
            Logger.logFine("Couldn't parse the install referrer URI", t);
            return null;
        }
    }
}

