/*
 * Decompiled with CFR 0.152.
 */
package com.cleveroad.audiovisualization;

import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.speech.RecognitionListener;
import android.speech.SpeechRecognizer;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.cleveroad.audiovisualization.DbmHandler;
import com.cleveroad.audiovisualization.Utils;

public class SpeechRecognizerDbmHandler
extends DbmHandler<Float>
implements RecognitionListener {
    private static final float MIN_RMS_DB_VALUE = -2.12f;
    private static final float MAX_RMS_DB_VALUE = 10.0f;
    private final SpeechRecognizer speechRecognizer;
    private final float minRmsDbValue;
    private final float maxRmsDbValue;
    private RecognitionListener innerRecognitionListener;

    SpeechRecognizerDbmHandler(@NonNull Context context) {
        this(context, -2.12f, 10.0f);
    }

    SpeechRecognizerDbmHandler(@NonNull Context context, float minRmsDbValue, float maxRmsDbValue) {
        this.speechRecognizer = SpeechRecognizer.createSpeechRecognizer((Context)context);
        this.speechRecognizer.setRecognitionListener((RecognitionListener)this);
        this.minRmsDbValue = minRmsDbValue;
        this.maxRmsDbValue = maxRmsDbValue;
    }

    public void startListening(Intent recognitionIntent) {
        this.speechRecognizer.startListening(recognitionIntent);
    }

    public void stopListening() {
        this.speechRecognizer.stopListening();
    }

    public SpeechRecognizerDbmHandler innerRecognitionListener(@Nullable RecognitionListener innerRecognitionListener) {
        this.innerRecognitionListener = innerRecognitionListener;
        return this;
    }

    public RecognitionListener innerRecognitionListener() {
        return this.innerRecognitionListener;
    }

    @Override
    protected void onDataReceivedImpl(Float rmsdB, int layersCount, float[] dBmArray, float[] ampsArray) {
        for (int i = 0; i < layersCount; ++i) {
            dBmArray[i] = Utils.normalize(rmsdB.floatValue(), this.minRmsDbValue, this.maxRmsDbValue);
            ampsArray[i] = 1.0f;
        }
    }

    @Override
    public void release() {
        super.release();
        this.speechRecognizer.destroy();
    }

    public void onReadyForSpeech(Bundle params) {
        if (this.innerRecognitionListener != null) {
            this.innerRecognitionListener.onReadyForSpeech(params);
        }
    }

    public void onBeginningOfSpeech() {
        if (this.innerRecognitionListener != null) {
            this.innerRecognitionListener.onBeginningOfSpeech();
        }
    }

    public void onRmsChanged(float rmsdB) {
        this.onDataReceived(Float.valueOf(rmsdB));
        if (this.innerRecognitionListener != null) {
            this.innerRecognitionListener.onRmsChanged(rmsdB);
        }
    }

    public void onBufferReceived(byte[] buffer) {
        if (this.innerRecognitionListener != null) {
            this.innerRecognitionListener.onBufferReceived(buffer);
        }
    }

    public void onEndOfSpeech() {
        if (this.innerRecognitionListener != null) {
            this.innerRecognitionListener.onEndOfSpeech();
        }
    }

    public void onError(int error) {
        if (this.innerRecognitionListener != null) {
            this.innerRecognitionListener.onError(error);
        }
    }

    public void onResults(Bundle results) {
        this.speechRecognizer.cancel();
        this.onDataReceived(Float.valueOf(this.minRmsDbValue));
        this.calmDownAndStopRendering();
        if (this.innerRecognitionListener != null) {
            this.innerRecognitionListener.onResults(results);
        }
    }

    public void onPartialResults(Bundle partialResults) {
        if (this.innerRecognitionListener != null) {
            this.innerRecognitionListener.onPartialResults(partialResults);
        }
    }

    public void onEvent(int eventType, Bundle params) {
        if (this.innerRecognitionListener != null) {
            this.innerRecognitionListener.onEvent(eventType, params);
        }
    }
}

