/*
 * Decompiled with CFR 0.152.
 */
package com.cleveroad.audiovisualization;

import android.content.Context;
import android.media.MediaPlayer;
import android.support.annotation.CallSuper;
import android.support.annotation.NonNull;
import com.cleveroad.audiovisualization.InnerAudioVisualization;
import com.cleveroad.audiovisualization.SpeechRecognizerDbmHandler;
import com.cleveroad.audiovisualization.VisualizerDbmHandler;
import java.util.Timer;
import java.util.TimerTask;

public abstract class DbmHandler<TData> {
    private static final long UPDATE_INTERVAL = 16L;
    private int layersCount;
    private InnerAudioVisualization audioVisualization;
    private float[] dBmArray;
    private float[] ampsArray;
    private float[] emptyArray;
    private boolean released;
    private Timer timer;

    void setUp(@NonNull InnerAudioVisualization audioVisualization, int layersCount) {
        this.audioVisualization = audioVisualization;
        this.layersCount = layersCount;
        this.dBmArray = new float[layersCount];
        this.ampsArray = new float[layersCount];
        this.emptyArray = new float[layersCount];
    }

    public final void onDataReceived(TData data) {
        if (this.released) {
            return;
        }
        this.onDataReceivedImpl(data, this.layersCount, this.dBmArray, this.ampsArray);
        this.audioVisualization.onDataReceived(this.dBmArray, this.ampsArray);
        this.startRendering();
    }

    protected final void startRendering() {
        this.cancelTimer();
        this.audioVisualization.startRendering();
    }

    protected final void stopRendering() {
        this.cancelTimer();
        this.audioVisualization.stopRendering();
    }

    protected final void calmDownAndStopRendering() {
        if (this.timer == null) {
            this.timer = new Timer("Stop Rendering Timer");
            this.timer.scheduleAtFixedRate(new TimerTask(){

                @Override
                public void run() {
                    if (DbmHandler.this.audioVisualization != null) {
                        DbmHandler.this.audioVisualization.onDataReceived(DbmHandler.this.emptyArray, DbmHandler.this.emptyArray);
                    }
                }
            }, 16L, 16L);
        }
        this.audioVisualization.calmDownListener(new InnerAudioVisualization.CalmDownListener(){

            @Override
            public void onCalmedDown() {
                DbmHandler.this.stopRendering();
            }
        });
    }

    private void cancelTimer() {
        if (this.timer != null) {
            this.timer.cancel();
            this.timer.purge();
            this.timer = null;
        }
    }

    public void onResume() {
    }

    public void onPause() {
    }

    @CallSuper
    public void release() {
        this.released = true;
        this.dBmArray = null;
        this.ampsArray = null;
        this.audioVisualization = null;
    }

    protected abstract void onDataReceivedImpl(TData var1, int var2, float[] var3, float[] var4);

    public static class Factory {
        public static VisualizerDbmHandler newVisualizerHandler(@NonNull Context context, int audioSessionId) {
            return new VisualizerDbmHandler(context, audioSessionId);
        }

        public static VisualizerDbmHandler newVisualizerHandler(@NonNull Context context, @NonNull MediaPlayer mediaPlayer) {
            return new VisualizerDbmHandler(context, mediaPlayer);
        }

        public static SpeechRecognizerDbmHandler newSpeechRecognizerHandler(@NonNull Context context) {
            return new SpeechRecognizerDbmHandler(context);
        }

        public static SpeechRecognizerDbmHandler newSpeechRecognizerDbmHandler(@NonNull Context context, float minRmsDbValue, float maxRmsDbValue) {
            return new SpeechRecognizerDbmHandler(context, minRmsDbValue, maxRmsDbValue);
        }
    }
}

