/*
 * Decompiled with CFR 0.152.
 */
package com.clearspring.analytics.stream.frequency;

import com.clearspring.analytics.stream.frequency.IFrequency;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Random;

public class CountMinSketch
implements IFrequency {
    public static final long PRIME_MODULUS = Integer.MAX_VALUE;
    private int depth;
    private int width;
    private long[][] table;
    private long[] hashA;
    private long size;
    private double eps;
    private double confidence;

    private CountMinSketch() {
    }

    public CountMinSketch(int depth, int width, int seed) {
        this.depth = depth;
        this.width = width;
        this.eps = 2.0 / (double)width;
        this.confidence = 1.0 - 1.0 / Math.pow(2.0, depth);
        this.initTablesWith(depth, width, seed);
    }

    public CountMinSketch(double epsOfTotalCount, double confidence, int seed) {
        this.eps = epsOfTotalCount;
        this.confidence = confidence;
        this.width = (int)Math.ceil(2.0 / epsOfTotalCount);
        this.depth = (int)Math.ceil(-Math.log(1.0 - confidence) / Math.log(2.0));
        this.initTablesWith(this.depth, this.width, seed);
    }

    private void initTablesWith(int depth, int width, int seed) {
        this.table = new long[depth][width];
        this.hashA = new long[depth];
        Random r = new Random(seed);
        for (int i = 0; i < depth; ++i) {
            this.hashA[i] = r.nextInt(Integer.MAX_VALUE);
        }
    }

    public double getRelativeError() {
        return this.eps;
    }

    public double getConfidence() {
        return this.confidence;
    }

    private int hash(long item, int i) {
        long hash = this.hashA[i] * item;
        hash += hash >> 32;
        return (int)(hash &= Integer.MAX_VALUE) % this.width;
    }

    @Override
    public void add(long item, long count) {
        if (count < 0L) {
            throw new IllegalArgumentException("Negative increments not implemented");
        }
        for (int i = 0; i < this.depth; ++i) {
            long[] lArray = this.table[i];
            int n = this.hash(item, i);
            lArray[n] = lArray[n] + count;
        }
        this.size += count;
    }

    @Override
    public long size() {
        return this.size;
    }

    @Override
    public long estimateCount(long item) {
        long res = Long.MAX_VALUE;
        for (int i = 0; i < this.depth; ++i) {
            res = Math.min(res, this.table[i][this.hash(item, i)]);
        }
        return res;
    }

    public static byte[] serialize(CountMinSketch sketch) {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        DataOutputStream s = new DataOutputStream(bos);
        try {
            s.writeLong(sketch.size);
            s.writeInt(sketch.depth);
            s.writeInt(sketch.width);
            for (int i = 0; i < sketch.depth; ++i) {
                s.writeLong(sketch.hashA[i]);
                for (int j = 0; j < sketch.width; ++j) {
                    s.writeLong(sketch.table[i][j]);
                }
            }
            return bos.toByteArray();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static CountMinSketch deserialize(byte[] data) {
        ByteArrayInputStream bis = new ByteArrayInputStream(data);
        DataInputStream s = new DataInputStream(bis);
        try {
            CountMinSketch sketch = new CountMinSketch();
            sketch.size = s.readLong();
            sketch.depth = s.readInt();
            sketch.width = s.readInt();
            sketch.eps = 2.0 / (double)sketch.width;
            sketch.confidence = 1.0 - 1.0 / Math.pow(2.0, sketch.depth);
            sketch.hashA = new long[sketch.depth];
            sketch.table = new long[sketch.depth][sketch.width];
            for (int i = 0; i < sketch.depth; ++i) {
                sketch.hashA[i] = s.readLong();
                for (int j = 0; j < sketch.width; ++j) {
                    sketch.table[i][j] = s.readLong();
                }
            }
            return sketch;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

