ace.define("ace/autocomplete/popup",["require","exports","module","ace/virtual_renderer","ace/editor","ace/range","ace/lib/event","ace/lib/lang","ace/lib/dom","ace/config"],function(b,E,H){"use strict";var A=b("../virtual_renderer").VirtualRenderer,k=b("../editor").Editor,L=b("../range").Range,C=b("../lib/event"),S=b("../lib/lang"),y=b("../lib/dom"),T=b("../config").nls,P=function(M){return"suggest-aria-id:".concat(M)},$=function(M){var x=new A(M);x.$maxLines=4;var v=new k(x);return v.setHighlightActiveLine(!1),v.setShowPrintMargin(!1),v.renderer.setShowGutter(!1),v.renderer.setHighlightGutterLine(!1),v.$mouseHandler.$focusTimeout=0,v.$highlightTagPending=!0,v};y.importCssString('\n.ace_editor.ace_autocomplete .ace_marker-layer .ace_active-line {\n    background-color: #CAD6FA;\n    z-index: 1;\n}\n.ace_dark.ace_editor.ace_autocomplete .ace_marker-layer .ace_active-line {\n    background-color: #3a674e;\n}\n.ace_editor.ace_autocomplete .ace_line-hover {\n    border: 1px solid #abbffe;\n    margin-top: -1px;\n    background: rgba(233,233,253,0.4);\n    position: absolute;\n    z-index: 2;\n}\n.ace_dark.ace_editor.ace_autocomplete .ace_line-hover {\n    border: 1px solid rgba(109, 150, 13, 0.8);\n    background: rgba(58, 103, 78, 0.62);\n}\n.ace_completion-meta {\n    opacity: 0.5;\n    margin-left: 0.9em;\n}\n.ace_completion-message {\n    margin-left: 0.9em;\n    color: blue;\n}\n.ace_editor.ace_autocomplete .ace_completion-highlight{\n    color: #2d69c7;\n}\n.ace_dark.ace_editor.ace_autocomplete .ace_completion-highlight{\n    color: #93ca12;\n}\n.ace_editor.ace_autocomplete {\n    width: 300px;\n    z-index: 200000;\n    border: 1px lightgray solid;\n    position: fixed;\n    box-shadow: 2px 3px 5px rgba(0,0,0,.2);\n    line-height: 1.4;\n    background: #fefefe;\n    color: #111;\n}\n.ace_dark.ace_editor.ace_autocomplete {\n    border: 1px #484747 solid;\n    box-shadow: 2px 3px 5px rgba(0, 0, 0, 0.51);\n    line-height: 1.4;\n    background: #25282c;\n    color: #c1c1c1;\n}\n.ace_autocomplete .ace_text-layer  {\n    width: calc(100% - 8px);\n}\n.ace_autocomplete .ace_line {\n    display: flex;\n    align-items: center;\n}\n.ace_autocomplete .ace_line > * {\n    min-width: 0;\n    flex: 0 0 auto;\n}\n.ace_autocomplete .ace_line .ace_ {\n    flex: 0 1 auto;\n    overflow: hidden;\n    white-space: nowrap;\n    text-overflow: ellipsis;\n}\n.ace_autocomplete .ace_completion-spacer {\n    flex: 1;\n}\n.ace_autocomplete.ace_loading:after  {\n    content: "";\n    position: absolute;\n    top: 0px;\n    height: 2px;\n    width: 8%;\n    background: blue;\n    z-index: 100;\n    animation: ace_progress 3s infinite linear;\n    animation-delay: 300ms;\n    transform: translateX(-100%) scaleX(1);\n}\n@keyframes ace_progress {\n    0% { transform: translateX(-100%) scaleX(1) }\n    50% { transform: translateX(625%) scaleX(2) } \n    100% { transform: translateX(1500%) scaleX(3) } \n}\n@media (prefers-reduced-motion) {\n    .ace_autocomplete.ace_loading:after {\n        transform: translateX(625%) scaleX(2);\n        animation: none;\n     }\n}\n',"autocompletion.css",!1),E.AcePopup=function M(x){var v=y.createElement("div"),h=new $(v);x&&x.appendChild(v),v.style.display="none",h.renderer.content.style.cursor="default",h.renderer.setStyle("ace_autocomplete"),h.renderer.$textLayer.element.setAttribute("role","listbox"),h.renderer.$textLayer.element.setAttribute("aria-label",T("Autocomplete suggestions")),h.renderer.textarea.setAttribute("aria-hidden","true"),h.setOption("displayIndentGuides",!1),h.setOption("dragDelay",150);var u=function(){};h.focus=u,h.$isFocused=!0,h.renderer.$cursorLayer.restartTimer=u,h.renderer.$cursorLayer.element.style.opacity=0,h.renderer.$maxLines=8,h.renderer.$keepTextAreaAtCursor=!1,h.setHighlightActiveLine(!1),h.session.highlight(""),h.session.$searchHighlight.clazz="ace_highlight-marker",h.on("mousedown",function(o){var r=o.getDocumentPosition();h.selection.moveToPosition(r),n.start.row=n.end.row=r.row,o.stop()});var s,c=new L(-1,0,-1,1/0),n=new L(-1,0,-1,1/0);n.id=h.session.addMarker(n,"ace_active-line","fullLine"),h.setSelectOnHover=function(o){o?c.id&&(h.session.removeMarker(c.id),c.id=null):c.id=h.session.addMarker(c,"ace_line-hover","fullLine")},h.setSelectOnHover(!1),h.on("mousemove",function(o){if(s){if(s.x!=o.x||s.y!=o.y){(s=o).scrollTop=h.renderer.scrollTop,h.isMouseOver=!0;var r=s.getDocumentPosition().row;c.start.row!=r&&(c.id||h.setRow(r),t(r))}}else s=o}),h.renderer.on("beforeRender",function(){if(s&&-1!=c.start.row){s.$pos=null;var o=s.getDocumentPosition().row;c.id||h.setRow(o),t(o,!0)}}),h.renderer.on("afterRender",function(){var o=h.getRow(),r=h.renderer.$textLayer,l=r.element.childNodes[o-r.config.firstRow],a=document.activeElement;if(l!==r.selectedNode&&r.selectedNode&&(y.removeCssClass(r.selectedNode,"ace_selected"),a.removeAttribute("aria-activedescendant"),r.selectedNode.removeAttribute("id")),r.selectedNode=l,l){y.addCssClass(l,"ace_selected");var f=P(o);l.id=f,r.element.setAttribute("aria-activedescendant",f),a.setAttribute("aria-activedescendant",f),l.setAttribute("role","option"),l.setAttribute("aria-label",h.getData(o).value),l.setAttribute("aria-setsize",h.data.length),l.setAttribute("aria-posinset",o+1),l.setAttribute("aria-describedby","doc-tooltip")}});var e=function(){t(-1)},t=function(o,r){o!==c.start.row&&(c.start.row=c.end.row=o,r||h.session._emit("changeBackMarker"),h._emit("changeHoverMarker"))};h.getHoveredRow=function(){return c.start.row},C.addListener(h.container,"mouseout",function(){h.isMouseOver=!1,e()}),h.on("hide",e),h.on("changeSelection",e),h.session.doc.getLength=function(){return h.data.length},h.session.doc.getLine=function(o){var r=h.data[o];return"string"==typeof r?r:r&&r.value||""};var i=h.session.bgTokenizer;return i.$tokenizeRow=function(o){var r=h.data[o],l=[];if(!r)return l;"string"==typeof r&&(r={value:r});var a=r.caption||r.value||r.name;function f(D,z){D&&l.push({type:(r.className||"")+(z||""),value:D})}for(var p=a.toLowerCase(),g=(h.filterText||"").toLowerCase(),d=0,m=0,w=0;w<=g.length;w++)if(w!=m&&(r.matchMask&1<<w||w==g.length)){var _=g.slice(m,w);m=w;var F=p.indexOf(_,d);if(-1==F)continue;f(a.slice(d,F),""),f(a.slice(F,d=F+_.length),"completion-highlight")}return f(a.slice(d,a.length),""),l.push({type:"completion-spacer",value:" "}),r.meta&&l.push({type:"completion-meta",value:r.meta}),r.message&&l.push({type:"completion-message",value:r.message}),l},i.$updateOnChange=u,i.start=u,h.session.$computeWidth=function(){return this.screenWidth=0},h.isOpen=!1,h.isTopdown=!1,h.autoSelect=!0,h.filterText="",h.isMouseOver=!1,h.data=[],h.setData=function(o,r){h.filterText=r||"",h.setValue(S.stringRepeat("\n",o.length),-1),h.data=o||[],h.setRow(0)},h.getData=function(o){return h.data[o]},h.getRow=function(){return n.start.row},h.setRow=function(o){o=Math.max(this.autoSelect?0:-1,Math.min(this.data.length-1,o)),n.start.row!=o&&(h.selection.clearSelection(),n.start.row=n.end.row=o||0,h.session._emit("changeBackMarker"),h.moveCursorTo(o||0,0),h.isOpen&&h._signal("select"))},h.on("changeSelection",function(){h.isOpen&&h.setRow(h.selection.lead.row),h.renderer.scrollCursorIntoView()}),h.hide=function(){this.container.style.display="none",h.anchorPos=null,h.anchor=null,h.isOpen&&(h.isOpen=!1,this._signal("hide"))},h.tryShow=function(o,r,l,a){if(!a&&h.isOpen&&h.anchorPos&&h.anchor&&h.anchorPos.top===o.top&&h.anchorPos.left===o.left&&h.anchor===l)return!0;var f=this.container,p=window.innerHeight,g=window.innerWidth,d=this.renderer,m=d.$maxLines*r*1.4,w={top:0,bottom:0,left:0},_=p-o.top-3*this.$borderSize-r,F=o.top-3*this.$borderSize;l||(l=F<=_||_>=m?"bottom":"top"),"top"===l?(w.bottom=o.top-this.$borderSize,w.top=w.bottom-m):"bottom"===l&&(w.top=o.top+r+this.$borderSize,w.bottom=w.top+m);var D=w.top>=0&&w.bottom<=p;if(!a&&!D)return!1;d.$maxPixelHeight=D?null:"top"===l?F:_,"top"===l?(f.style.top="",f.style.bottom=p-w.bottom+"px",h.isTopdown=!1):(f.style.top=w.top+"px",f.style.bottom="",h.isTopdown=!0),f.style.display="";var z=o.left;return z+f.offsetWidth>g&&(z=g-f.offsetWidth),f.style.left=z+"px",f.style.right="",h.isOpen||(h.isOpen=!0,this._signal("show"),s=null),h.anchorPos=o,h.anchor=l,!0},h.show=function(o,r,l){this.tryShow(o,r,l?"bottom":void 0,!0)},h.goTo=function(o){var r=this.getRow(),l=this.session.getLength()-1;switch(o){case"up":r=r<=0?l:r-1;break;case"down":r=r>=l?-1:r+1;break;case"start":r=0;break;case"end":r=l}this.setRow(r)},h.getTextLeftOffset=function(){return this.$borderSize+this.renderer.$padding+this.$imageSize},h.$imageSize=0,h.$borderSize=1,h},E.$singleLineEditor=$,E.getAriaId=P}),ace.define("ace/snippets",["require","exports","module","ace/lib/dom","ace/lib/oop","ace/lib/event_emitter","ace/lib/lang","ace/range","ace/range_list","ace/keyboard/hash_handler","ace/tokenizer","ace/clipboard","ace/editor"],function(b,E,H){"use strict";var A=b("./lib/dom"),k=b("./lib/oop"),L=b("./lib/event_emitter").EventEmitter,C=b("./lib/lang"),S=b("./range").Range,y=b("./range_list").RangeList,T=b("./keyboard/hash_handler").HashHandler,P=b("./tokenizer").Tokenizer,$=b("./clipboard"),O={CURRENT_WORD:function(n){return n.session.getTextRange(n.session.getWordRange())},SELECTION:function(n,e,t){var i=n.session.getTextRange();return t?i.replace(/\n\r?([ \t]*\S)/g,"\n"+t+"$1"):i},CURRENT_LINE:function(n){return n.session.getLine(n.getCursorPosition().row)},PREV_LINE:function(n){return n.session.getLine(n.getCursorPosition().row-1)},LINE_INDEX:function(n){return n.getCursorPosition().row},LINE_NUMBER:function(n){return n.getCursorPosition().row+1},SOFT_TABS:function(n){return n.session.getUseSoftTabs()?"YES":"NO"},TAB_SIZE:function(n){return n.session.getTabSize()},CLIPBOARD:function(n){return $.getText&&$.getText()},FILENAME:function(n){return/[^/\\]*$/.exec(this.FILEPATH(n))[0]},FILENAME_BASE:function(n){return/[^/\\]*$/.exec(this.FILEPATH(n))[0].replace(/\.[^.]*$/,"")},DIRECTORY:function(n){return this.FILEPATH(n).replace(/[^/\\]*$/,"")},FILEPATH:function(n){return"/not implemented.txt"},WORKSPACE_NAME:function(){return"Unknown"},FULLNAME:function(){return"Unknown"},BLOCK_COMMENT_START:function(n){var e=n.session.$mode||{};return e.blockComment&&e.blockComment.start||""},BLOCK_COMMENT_END:function(n){var e=n.session.$mode||{};return e.blockComment&&e.blockComment.end||""},LINE_COMMENT:function(n){return(n.session.$mode||{}).lineCommentStart||""},CURRENT_YEAR:M.bind(null,{year:"numeric"}),CURRENT_YEAR_SHORT:M.bind(null,{year:"2-digit"}),CURRENT_MONTH:M.bind(null,{month:"numeric"}),CURRENT_MONTH_NAME:M.bind(null,{month:"long"}),CURRENT_MONTH_NAME_SHORT:M.bind(null,{month:"short"}),CURRENT_DATE:M.bind(null,{day:"2-digit"}),CURRENT_DAY_NAME:M.bind(null,{weekday:"long"}),CURRENT_DAY_NAME_SHORT:M.bind(null,{weekday:"short"}),CURRENT_HOUR:M.bind(null,{hour:"2-digit",hour12:!1}),CURRENT_MINUTE:M.bind(null,{minute:"2-digit"}),CURRENT_SECOND:M.bind(null,{second:"2-digit"})};function M(n){var e=(new Date).toLocaleString("en-us",n);return 1==e.length?"0"+e:e}O.SELECTED_TEXT=O.SELECTION;var x=function(){function n(){this.snippetMap={},this.snippetNameMap={},this.variables=O}return n.prototype.getTokenizer=function(){return n.$tokenizer||this.createTokenizer()},n.prototype.createTokenizer=function(){function e(o){return o=o.substr(1),/^\d+$/.test(o)?[{tabstopId:parseInt(o,10)}]:[{text:o}]}function t(o){return"(?:[^\\\\"+o+"]|\\\\.)"}var i={regex:"/("+t("/")+"+)/",onMatch:function(o,r,l){var a=l[0];return a.fmtString=!0,a.guard=o.slice(1,-1),a.flag="",""},next:"formatString"};return n.$tokenizer=new P({start:[{regex:/\\./,onMatch:function(o,r,l){var a=o[1];return("}"==a&&l.length||-1!="`$\\".indexOf(a))&&(o=a),[o]}},{regex:/}/,onMatch:function(o,r,l){return[l.length?l.shift():o]}},{regex:/\$(?:\d+|\w+)/,onMatch:e},{regex:/\$\{[\dA-Z_a-z]+/,onMatch:function(o,r,l){var a=e(o.substr(1));return l.unshift(a[0]),a},next:"snippetVar"},{regex:/\n/,token:"newline",merge:!1}],snippetVar:[{regex:"\\|"+t("\\|")+"*\\|",onMatch:function(o,r,l){var a=o.slice(1,-1).replace(/\\[,|\\]|,/g,function(f){return 2==f.length?f[1]:"\0"}).split("\0").map(function(f){return{value:f}});return l[0].choices=a,[a[0]]},next:"start"},i,{regex:"([^:}\\\\]|\\\\.)*:?",token:"",next:"start"}],formatString:[{regex:/:/,onMatch:function(o,r,l){return l.length&&l[0].expectElse?(l[0].expectElse=!1,l[0].ifEnd={elseEnd:l[0]},[l[0].ifEnd]):":"}},{regex:/\\./,onMatch:function(o,r,l){var a=o[1];return"}"==a&&l.length||-1!="`$\\".indexOf(a)?o=a:"n"==a?o="\n":"t"==a?o="\t":-1!="ulULE".indexOf(a)&&(o={changeCase:a,local:a>"a"}),[o]}},{regex:"/\\w*}",onMatch:function(o,r,l){var a=l.shift();return a&&(a.flag=o.slice(1,-1)),this.next=a&&a.tabstopId?"start":"",[a||o]},next:"start"},{regex:/\$(?:\d+|\w+)/,onMatch:function(o,r,l){return[{text:o.slice(1)}]}},{regex:/\${\w+/,onMatch:function(o,r,l){var a={text:o.slice(2)};return l.unshift(a),[a]},next:"formatStringVar"},{regex:/\n/,token:"newline",merge:!1},{regex:/}/,onMatch:function(o,r,l){var a=l.shift();return this.next=a&&a.tabstopId?"start":"",[a||o]},next:"start"}],formatStringVar:[{regex:/:\/\w+}/,onMatch:function(o,r,l){return l[0].formatFunction=o.slice(2,-1),[l.shift()]},next:"formatString"},i,{regex:/:[\?\-+]?/,onMatch:function(o,r,l){"+"==o[1]&&(l[0].ifEnd=l[0]),"?"==o[1]&&(l[0].expectElse=!0)},next:"formatString"},{regex:"([^:}\\\\]|\\\\.)*:?",token:"",next:"formatString"}]})},n.prototype.tokenizeTmSnippet=function(e,t){return this.getTokenizer().getLineTokens(e,t).tokens.map(function(i){return i.value||i})},n.prototype.getVariableValue=function(e,t,i){if(/^\d+$/.test(t))return(this.variables.__||{})[t]||"";if(/^[A-Z]\d+$/.test(t))return(this.variables[t[0]+"__"]||{})[t.substr(1)]||"";if(t=t.replace(/^TM_/,""),!this.variables.hasOwnProperty(t))return"";var o=this.variables[t];return"function"==typeof o&&(o=this.variables[t](e,t,i)),null==o?"":o},n.prototype.tmStrFormat=function(e,t,i){if(!t.fmt)return e;var r=t.guard;r=new RegExp(r,(t.flag||"").replace(/[^gim]/g,""));var l="string"==typeof t.fmt?this.tokenizeTmSnippet(t.fmt,"formatString"):t.fmt,a=this,f=e.replace(r,function(){var p=a.variables.__;a.variables.__=[].slice.call(arguments);for(var g=a.resolveVariables(l,i),d="E",m=0;m<g.length;m++){var w=g[m];if("object"==typeof w)if(g[m]="",w.changeCase&&w.local){var _=g[m+1];_&&"string"==typeof _&&(g[m]="u"==w.changeCase?_[0].toUpperCase():_[0].toLowerCase(),g[m+1]=_.substr(1))}else w.changeCase&&(d=w.changeCase);else"U"==d?g[m]=w.toUpperCase():"L"==d&&(g[m]=w.toLowerCase())}return a.variables.__=p,g.join("")});return f},n.prototype.tmFormatFunction=function(e,t,i){return"upcase"==t.formatFunction?e.toUpperCase():"downcase"==t.formatFunction?e.toLowerCase():e},n.prototype.resolveVariables=function(e,t){for(var i=[],o="",r=!0,l=0;l<e.length;l++){var a=e[l];if("string"!=typeof a){if(a){if(r=!1,a.fmtString){var f=e.indexOf(a,l+1);-1==f&&(f=e.length),a.fmt=e.slice(l+1,f),l=f}if(a.text){var p=this.getVariableValue(t,a.text,o)+"";a.fmtString&&(p=this.tmStrFormat(p,a,t)),a.formatFunction&&(p=this.tmFormatFunction(p,a,t)),p&&!a.ifEnd?(i.push(p),g(a)):!p&&a.ifEnd&&g(a.ifEnd)}else a.elseEnd?g(a.elseEnd):(null!=a.tabstopId||null!=a.changeCase)&&i.push(a)}}else i.push(a),"\n"==a?(r=!0,o=""):r&&(o=/^\t*/.exec(a)[0],r=/\S/.test(a))}function g(d){var m=e.indexOf(d,l+1);-1!=m&&(l=m)}return i},n.prototype.getDisplayTextForSnippet=function(e,t){return v.call(this,e,t).text},n.prototype.insertSnippetForSelection=function(e,t,i){void 0===i&&(i={});var o=v.call(this,e,t,i),r=e.getSelectionRange(),l=e.session.replace(r,o.text);new h(e).addTabstops(o.tabstops,r.start,l,e.inVirtualSelectionMode&&e.selection.index)},n.prototype.insertSnippet=function(e,t,i){void 0===i&&(i={});var o=this;if(e.inVirtualSelectionMode)return o.insertSnippetForSelection(e,t,i);e.forEachSelection(function(){o.insertSnippetForSelection(e,t,i)},null,{keepOrder:!0}),e.tabstopManager&&e.tabstopManager.tabNext()},n.prototype.$getScope=function(e){var t=e.session.$mode.$id||"";if("html"===(t=t.split("/").pop())||"php"===t){"php"===t&&!e.session.$mode.inlinePhp&&(t="html");var i=e.getCursorPosition(),o=e.session.getState(i.row);"object"==typeof o&&(o=o[0]),o.substring&&("js-"==o.substring(0,3)?t="javascript":"css-"==o.substring(0,4)?t="css":"php-"==o.substring(0,4)&&(t="php"))}return t},n.prototype.getActiveScopes=function(e){var t=this.$getScope(e),i=[t],o=this.snippetMap;return o[t]&&o[t].includeScopes&&i.push.apply(i,o[t].includeScopes),i.push("_"),i},n.prototype.expandWithTab=function(e,t){var i=this,o=e.forEachSelection(function(){return i.expandSnippetForSelection(e,t)},null,{keepOrder:!0});return o&&e.tabstopManager&&e.tabstopManager.tabNext(),o},n.prototype.expandSnippetForSelection=function(e,t){var f,i=e.getCursorPosition(),o=e.session.getLine(i.row),r=o.substring(0,i.column),l=o.substr(i.column),a=this.snippetMap;return this.getActiveScopes(e).some(function(p){var g=a[p];return g&&(f=this.findMatchingSnippet(g,r,l)),!!f},this),!!f&&(t&&t.dryRun||(e.session.doc.removeInLine(i.row,i.column-f.replaceBefore.length,i.column+f.replaceAfter.length),this.variables.M__=f.matchBefore,this.variables.T__=f.matchAfter,this.insertSnippetForSelection(e,f.content),this.variables.M__=this.variables.T__=null),!0)},n.prototype.findMatchingSnippet=function(e,t,i){for(var o=e.length;o--;){var r=e[o];if((!r.startRe||r.startRe.test(t))&&(!r.endRe||r.endRe.test(i))&&(r.startRe||r.endRe))return r.matchBefore=r.startRe?r.startRe.exec(t):[""],r.matchAfter=r.endRe?r.endRe.exec(i):[""],r.replaceBefore=r.triggerRe?r.triggerRe.exec(t)[0]:"",r.replaceAfter=r.endTriggerRe?r.endTriggerRe.exec(i)[0]:"",r}},n.prototype.register=function(e,t){var i=this.snippetMap,o=this.snippetNameMap,r=this;function l(p){return p&&!/^\^?\(.*\)\$?$|^\\b$/.test(p)&&(p="(?:"+p+")"),p||""}function a(p,g,d){return p=l(p),g=l(g),d?(p=g+p)&&"$"!=p[p.length-1]&&(p+="$"):(p+=g)&&"^"!=p[0]&&(p="^"+p),new RegExp(p)}function f(p){p.scope||(p.scope=t||"_"),i[t=p.scope]||(i[t]=[],o[t]={});var g=o[t];if(p.name){var d=g[p.name];d&&r.unregister(d),g[p.name]=p}i[t].push(p),p.prefix&&(p.tabTrigger=p.prefix),!p.content&&p.body&&(p.content=Array.isArray(p.body)?p.body.join("\n"):p.body),p.tabTrigger&&!p.trigger&&(!p.guard&&/^\w/.test(p.tabTrigger)&&(p.guard="\\b"),p.trigger=C.escapeRegExp(p.tabTrigger)),(p.trigger||p.guard||p.endTrigger||p.endGuard)&&(p.startRe=a(p.trigger,p.guard,!0),p.triggerRe=new RegExp(p.trigger),p.endRe=a(p.endTrigger,p.endGuard,!0),p.endTriggerRe=new RegExp(p.endTrigger))}e||(e=[]),Array.isArray(e)?e.forEach(f):Object.keys(e).forEach(function(p){f(e[p])}),this._signal("registerSnippets",{scope:t})},n.prototype.unregister=function(e,t){var i=this.snippetMap,o=this.snippetNameMap;function r(l){var a=o[l.scope||t];if(a&&a[l.name]){delete a[l.name];var f=i[l.scope||t],p=f&&f.indexOf(l);p>=0&&f.splice(p,1)}}e.content?r(e):Array.isArray(e)&&e.forEach(r)},n.prototype.parseSnippetFile=function(e){e=e.replace(/\r/g,"");for(var r,t=[],i={},o=/^#.*|^({[\s\S]*})\s*$|^(\S+) (.*)$|^((?:\n*\t.*)+)/gm;r=o.exec(e);){if(r[1])try{i=JSON.parse(r[1]),t.push(i)}catch(p){}if(r[4])i.content=r[4].replace(/^\t/gm,""),t.push(i),i={};else{var l=r[2],a=r[3];if("regex"==l){var f=/\/((?:[^\/\\]|\\.)*)|$/g;i.guard=f.exec(a)[1],i.trigger=f.exec(a)[1],i.endTrigger=f.exec(a)[1],i.endGuard=f.exec(a)[1]}else"snippet"==l?(i.tabTrigger=a.match(/^\S*/)[0],i.name||(i.name=a)):l&&(i[l]=a)}}return t},n.prototype.getSnippetByName=function(e,t){var o,i=this.snippetNameMap;return this.getActiveScopes(t).some(function(r){var l=i[r];return l&&(o=l[e]),!!o},this),o},n}();k.implement(x.prototype,L);var v=function(n,e,t){void 0===t&&(t={});var i=n.getCursorPosition(),o=n.session.getLine(i.row),r=n.session.getTabString(),l=o.match(/^\s*/)[0];i.column<l.length&&(l=l.slice(0,i.column)),e=e.replace(/\r/g,"");var a=this.tokenizeTmSnippet(e);a=(a=this.resolveVariables(a,n)).map(function(R){return"\n"!=R||t.excludeExtraIndent?"string"==typeof R?R.replace(/\t/g,r):R:R+l});var f=[];a.forEach(function(R,I){if("object"==typeof R){var j=R.tabstopId,N=f[j];if(N||((N=f[j]=[]).index=j,N.value="",N.parents={}),-1===N.indexOf(R)){R.choices&&!N.choices&&(N.choices=R.choices),N.push(R);var V=a.indexOf(R,I+1);if(-1!==V){var B=a.slice(I+1,V);B.some(function(J){return"object"==typeof J})&&!N.value?N.value=B:B.length&&(!N.value||"string"!=typeof N.value)&&(N.value=B.join(""))}}}}),f.forEach(function(R){R.length=0});var p={};function g(R){for(var I=[],j=0;j<R.length;j++){var N=R[j];if("object"==typeof N){if(p[N.tabstopId])continue;N=I[R.lastIndexOf(N,j-1)]||{tabstopId:N.tabstopId}}I[j]=N}return I}for(var d=0;d<a.length;d++){var m=a[d];if("object"==typeof m){var w=m.tabstopId,_=f[w],F=a.indexOf(m,d+1);if(p[w]){p[w]===m&&(delete p[w],Object.keys(p).forEach(function(R){_.parents[R]=!0}));continue}p[w]=m;var D=_.value;"string"!=typeof D?D=g(D):m.fmt&&(D=this.tmStrFormat(D,m,n)),a.splice.apply(a,[d+1,Math.max(0,F-d)].concat(D,m)),-1===_.indexOf(m)&&_.push(m)}}var z=0,U=0,X="";return a.forEach(function(R){if("string"==typeof R){var I=R.split("\n");I.length>1?(U=I[I.length-1].length,z+=I.length-1):U+=R.length,X+=R}else R&&(R.start?R.end={row:z,column:U}:R.start={row:z,column:U})}),{text:X,tabstops:f,tokens:a}},h=function(){function n(e){if(this.index=0,this.ranges=[],this.tabstops=[],e.tabstopManager)return e.tabstopManager;e.tabstopManager=this,this.$onChange=this.onChange.bind(this),this.$onChangeSelection=C.delayedCall(this.onChangeSelection.bind(this)).schedule,this.$onChangeSession=this.onChangeSession.bind(this),this.$onAfterExec=this.onAfterExec.bind(this),this.attach(e)}return n.prototype.attach=function(e){this.$openTabstops=null,this.selectedTabstop=null,this.editor=e,this.session=e.session,this.editor.on("change",this.$onChange),this.editor.on("changeSelection",this.$onChangeSelection),this.editor.on("changeSession",this.$onChangeSession),this.editor.commands.on("afterExec",this.$onAfterExec),this.editor.keyBinding.addKeyboardHandler(this.keyboardHandler)},n.prototype.detach=function(){this.tabstops.forEach(this.removeTabstopMarkers,this),this.ranges.length=0,this.tabstops.length=0,this.selectedTabstop=null,this.editor.off("change",this.$onChange),this.editor.off("changeSelection",this.$onChangeSelection),this.editor.off("changeSession",this.$onChangeSession),this.editor.commands.off("afterExec",this.$onAfterExec),this.editor.keyBinding.removeKeyboardHandler(this.keyboardHandler),this.editor.tabstopManager=null,this.session=null,this.editor=null},n.prototype.onChange=function(e){for(var t="r"==e.action[0],i=this.selectedTabstop||{},o=i.parents||{},r=this.tabstops.slice(),l=0;l<r.length;l++){var a=r[l];if(a.rangeList.$bias=a==i||o[a.index]?0:1,"remove"==e.action&&a!==i){var p=a.parents&&a.parents[i.index],g=a.rangeList.pointIndex(e.start,p);g=g<0?-g-1:g+1;for(var d=a.rangeList.pointIndex(e.end,p),m=a.rangeList.ranges.slice(g,d=d<0?-d-1:d-1),w=0;w<m.length;w++)this.removeRange(m[w])}a.rangeList.$onChange(e)}var _=this.session;!this.$inChange&&t&&1==_.getLength()&&!_.getValue()&&this.detach()},n.prototype.updateLinkedFields=function(){var e=this.selectedTabstop;if(e&&e.hasLinkedRanges&&e.firstNonLinked){this.$inChange=!0;for(var t=this.session,i=t.getTextRange(e.firstNonLinked),o=0;o<e.length;o++){var r=e[o];if(r.linked){var a=E.snippetManager.tmStrFormat(i,r.original,this.editor);t.replace(r,a)}}this.$inChange=!1}},n.prototype.onAfterExec=function(e){e.command&&!e.command.readOnly&&this.updateLinkedFields()},n.prototype.onChangeSelection=function(){if(this.editor){for(var e=this.editor.selection.lead,t=this.editor.selection.anchor,i=this.editor.selection.isEmpty(),o=0;o<this.ranges.length;o++)if(!this.ranges[o].linked){var r=this.ranges[o].contains(e.row,e.column),l=i||this.ranges[o].contains(t.row,t.column);if(r&&l)return}this.detach()}},n.prototype.onChangeSession=function(){this.detach()},n.prototype.tabNext=function(e){var t=this.tabstops.length,i=this.index+(e||1);(i=Math.min(Math.max(i,1),t))==t&&(i=0),this.selectTabstop(i),0===i&&this.detach()},n.prototype.selectTabstop=function(e){this.$openTabstops=null;var t=this.tabstops[this.index];if(t&&this.addTabstopMarkers(t),this.index=e,(t=this.tabstops[this.index])&&t.length){this.selectedTabstop=t;var i=t.firstNonLinked||t;if(t.choices&&(i.cursor=i.start),this.editor.inVirtualSelectionMode)this.editor.selection.fromOrientedRange(i);else{var o=this.editor.multiSelect;o.toSingleRange(i);for(var r=0;r<t.length;r++)t.hasLinkedRanges&&t[r].linked||o.addRange(t[r].clone(),!0)}this.editor.keyBinding.addKeyboardHandler(this.keyboardHandler),this.selectedTabstop&&this.selectedTabstop.choices&&this.editor.execCommand("startAutocomplete",{matches:this.selectedTabstop.choices})}},n.prototype.addTabstops=function(e,t,i){var o=this.useLink||!this.editor.getOption("enableMultiselect");if(this.$openTabstops||(this.$openTabstops=[]),!e[0]){var r=S.fromPoints(i,i);s(r.start,t),s(r.end,t),e[0]=[r],e[0].index=0}var a=[this.index+1,0],f=this.ranges;e.forEach(function(p,g){for(var d=this.$openTabstops[g]||p,m=0;m<p.length;m++){var w=p[m],_=S.fromPoints(w.start,w.end||w.start);u(_.start,t),u(_.end,t),_.original=w,_.tabstop=d,f.push(_),d!=p?d.unshift(_):d[m]=_,w.fmtString||d.firstNonLinked&&o?(_.linked=!0,d.hasLinkedRanges=!0):d.firstNonLinked||(d.firstNonLinked=_)}d.firstNonLinked||(d.hasLinkedRanges=!1),d===p&&(a.push(d),this.$openTabstops[g]=d),this.addTabstopMarkers(d),d.rangeList=d.rangeList||new y,d.rangeList.$bias=0,d.rangeList.addList(d)},this),a.length>2&&(this.tabstops.length&&a.push(a.splice(2,1)[0]),this.tabstops.splice.apply(this.tabstops,a))},n.prototype.addTabstopMarkers=function(e){var t=this.session;e.forEach(function(i){i.markerId||(i.markerId=t.addMarker(i,"ace_snippet-marker","text"))})},n.prototype.removeTabstopMarkers=function(e){var t=this.session;e.forEach(function(i){t.removeMarker(i.markerId),i.markerId=null})},n.prototype.removeRange=function(e){var t=e.tabstop.indexOf(e);-1!=t&&e.tabstop.splice(t,1),-1!=(t=this.ranges.indexOf(e))&&this.ranges.splice(t,1),-1!=(t=e.tabstop.rangeList.ranges.indexOf(e))&&e.tabstop.splice(t,1),this.session.removeMarker(e.markerId),e.tabstop.length||(-1!=(t=this.tabstops.indexOf(e.tabstop))&&this.tabstops.splice(t,1),this.tabstops.length||this.detach())},n}();h.prototype.keyboardHandler=new T,h.prototype.keyboardHandler.bindKeys({Tab:function(n){E.snippetManager&&E.snippetManager.expandWithTab(n)||(n.tabstopManager.tabNext(1),n.renderer.scrollCursorIntoView())},"Shift-Tab":function(n){n.tabstopManager.tabNext(-1),n.renderer.scrollCursorIntoView()},Esc:function(n){n.tabstopManager.detach()}});var u=function(n,e){0==n.row&&(n.column+=e.column),n.row+=e.row},s=function(n,e){n.row==e.row&&(n.column-=e.column),n.row-=e.row};A.importCssString("\n.ace_snippet-marker {\n    -moz-box-sizing: border-box;\n    box-sizing: border-box;\n    background: rgba(194, 193, 208, 0.09);\n    border: 1px dotted rgba(211, 208, 235, 0.62);\n    position: absolute;\n}","snippets.css",!1),E.snippetManager=new x;var c=b("./editor").Editor;(function(){this.insertSnippet=function(n,e){return E.snippetManager.insertSnippet(this,n,e)},this.expandSnippet=function(n){return E.snippetManager.expandWithTab(this,n)}}).call(c.prototype)}),ace.define("ace/autocomplete/inline_screenreader",["require","exports","module"],function(b,E,H){"use strict";var A=function(){function k(L){this.editor=L,this.screenReaderDiv=document.createElement("div"),this.screenReaderDiv.classList.add("ace_screenreader-only"),this.editor.container.appendChild(this.screenReaderDiv)}return k.prototype.setScreenReaderContent=function(L){for(!this.popup&&this.editor.completer&&this.editor.completer.popup&&(this.popup=this.editor.completer.popup,this.popup.renderer.on("afterRender",function(){var S=this.popup.getRow(),y=this.popup.renderer.$textLayer,T=y.element.childNodes[S-y.config.firstRow];if(T){for(var P="doc-tooltip ",$=0;$<this._lines.length;$++)P+="ace-inline-screenreader-line-".concat($," ");T.setAttribute("aria-describedby",P)}}.bind(this)));this.screenReaderDiv.firstChild;)this.screenReaderDiv.removeChild(this.screenReaderDiv.firstChild);this._lines=L.split(/\r\n|\r|\n/);var C=this.createCodeBlock();this.screenReaderDiv.appendChild(C)},k.prototype.destroy=function(){this.screenReaderDiv.remove()},k.prototype.createCodeBlock=function(){var L=document.createElement("pre");L.setAttribute("id","ace-inline-screenreader");for(var C=0;C<this._lines.length;C++){var S=document.createElement("code");S.setAttribute("id","ace-inline-screenreader-line-".concat(C));var y=document.createTextNode(this._lines[C]);S.appendChild(y),L.appendChild(S)}return L},k}();E.AceInlineScreenReader=A}),ace.define("ace/autocomplete/inline",["require","exports","module","ace/snippets","ace/autocomplete/inline_screenreader"],function(b,E,H){"use strict";var A=b("../snippets").snippetManager,k=b("./inline_screenreader").AceInlineScreenReader,L=function(){function C(){this.editor=null}return C.prototype.show=function(S,y,T){if(T=T||"",S&&this.editor&&this.editor!==S&&(this.hide(),this.editor=null,this.inlineScreenReader=null),!S||!y)return!1;this.inlineScreenReader||(this.inlineScreenReader=new k(S));var P=y.snippet?A.getDisplayTextForSnippet(S,y.snippet):y.value;return!(y.hideInlinePreview||!P||!P.startsWith(T)||(this.editor=S,this.inlineScreenReader.setScreenReaderContent(P),""===(P=P.slice(T.length))?S.removeGhostText():S.setGhostText(P),0))},C.prototype.isOpen=function(){return!!this.editor&&!!this.editor.renderer.$ghostText},C.prototype.hide=function(){return!!this.editor&&(this.editor.removeGhostText(),!0)},C.prototype.destroy=function(){this.hide(),this.editor=null,this.inlineScreenReader&&(this.inlineScreenReader.destroy(),this.inlineScreenReader=null)},C}();E.AceInline=L}),ace.define("ace/autocomplete/util",["require","exports","module"],function(b,E,H){"use strict";E.parForEach=function(k,L,C){var S=0,y=k.length;0===y&&C();for(var T=0;T<y;T++)L(k[T],function(P,$){++S===y&&C(P,$)})};var A=/[a-zA-Z_0-9\$\-\u00A2-\u2000\u2070-\uFFFF]/;E.retrievePrecedingIdentifier=function(k,L,C){C=C||A;for(var S=[],y=L-1;y>=0&&C.test(k[y]);y--)S.push(k[y]);return S.reverse().join("")},E.retrieveFollowingIdentifier=function(k,L,C){C=C||A;for(var S=[],y=L;y<k.length&&C.test(k[y]);y++)S.push(k[y]);return S},E.getCompletionPrefix=function(k){var S,L=k.getCursorPosition(),C=k.session.getLine(L.row);return k.completers.forEach(function(y){y.identifierRegexps&&y.identifierRegexps.forEach(function(T){!S&&T&&(S=this.retrievePrecedingIdentifier(C,L.column,T))}.bind(this))}.bind(this)),S||this.retrievePrecedingIdentifier(C,L.column)},E.triggerAutocomplete=function(k){var L=k.getCursorPosition(),y=k.session.getLine(L.row)[0===L.column?0:L.column-1];return k.completers.some(function(T){if(T.triggerCharacters&&Array.isArray(T.triggerCharacters))return T.triggerCharacters.includes(y)})}}),ace.define("ace/autocomplete",["require","exports","module","ace/keyboard/hash_handler","ace/autocomplete/popup","ace/autocomplete/inline","ace/autocomplete/popup","ace/autocomplete/util","ace/lib/lang","ace/lib/dom","ace/snippets","ace/config","ace/lib/event"],function(b,E,H){"use strict";var A=b("./keyboard/hash_handler").HashHandler,k=b("./autocomplete/popup").AcePopup,L=b("./autocomplete/inline").AceInline,C=b("./autocomplete/popup").getAriaId,S=b("./autocomplete/util"),y=b("./lib/lang"),T=b("./lib/dom"),P=b("./snippets").snippetManager,$=b("./config"),O=b("./lib/event"),M=function(u,s){s.completer&&s.completer.destroy()},x=function(){function u(){this.autoInsert=!1,this.autoSelect=!0,this.autoShown=!1,this.exactMatch=!1,this.inlineEnabled=!1,this.keyboardHandler=new A,this.keyboardHandler.bindKeys(this.commands),this.parentNode=null,this.setSelectOnHover=!1,this.showLoadingState=!1,this.stickySelectionDelay=500,this.blurListener=this.blurListener.bind(this),this.changeListener=this.changeListener.bind(this),this.mousedownListener=this.mousedownListener.bind(this),this.mousewheelListener=this.mousewheelListener.bind(this),this.onLayoutChange=this.onLayoutChange.bind(this),this.changeTimer=y.delayedCall(function(){this.updateCompletions(!0)}.bind(this)),this.tooltipTimer=y.delayedCall(this.updateDocTooltip.bind(this),50),this.stickySelectionTimer=y.delayedCall(function(){this.stickySelection=!0}.bind(this),this.stickySelectionDelay),this.$firstOpenTimer=y.delayedCall(function(){var s=this.completionProvider&&this.completionProvider.initialPosition;this.autoShown||this.popup&&this.popup.isOpen||!s||(this.completions=new h(u.completionsForLoading),this.openPopup(this.editor,s.prefix,!1),this.popup.renderer.setStyle("ace_loading",!0))}.bind(this),this.stickySelectionDelay)}return Object.defineProperty(u,"completionsForLoading",{get:function(){return[{caption:$.nls("Loading..."),value:""}]},enumerable:!1,configurable:!0}),u.prototype.$init=function(){return this.popup=new k(this.parentNode||document.body||document.documentElement),this.popup.on("click",function(s){this.insertMatch(),s.stop()}.bind(this)),this.popup.focus=this.editor.focus.bind(this.editor),this.popup.on("show",this.$onPopupShow.bind(this)),this.popup.on("hide",this.$onHidePopup.bind(this)),this.popup.on("select",this.$onPopupChange.bind(this)),O.addListener(this.popup.container,"mouseout",this.mouseOutListener.bind(this)),this.popup.on("changeHoverMarker",this.tooltipTimer.bind(null,null)),this.popup},u.prototype.$initInline=function(){if(this.inlineEnabled&&!this.inlineRenderer)return this.inlineRenderer=new L,this.inlineRenderer},u.prototype.getPopup=function(){return this.popup||this.$init()},u.prototype.$onHidePopup=function(){this.inlineRenderer&&this.inlineRenderer.hide(),this.hideDocTooltip(),this.stickySelectionTimer.cancel(),this.stickySelection=!1},u.prototype.$onPopupChange=function(s){if(this.inlineRenderer&&this.inlineEnabled){var c=s?null:this.popup.getData(this.popup.getRow()),n=S.getCompletionPrefix(this.editor);if(this.inlineRenderer.show(this.editor,c,n)||this.inlineRenderer.hide(),this.popup.isMouseOver&&this.setSelectOnHover)return void this.tooltipTimer.call(null,null)}this.$updatePopupPosition(),this.tooltipTimer.call(null,null)},u.prototype.$onPopupShow=function(s){this.$onPopupChange(s),this.stickySelection=!1,this.stickySelectionDelay>=0&&this.stickySelectionTimer.schedule(this.stickySelectionDelay)},u.prototype.observeLayoutChanges=function(){if(!this.$elements&&this.editor){window.addEventListener("resize",this.onLayoutChange,{passive:!0}),window.addEventListener("wheel",this.mousewheelListener);for(var s=this.editor.container.parentNode,c=[];s;)c.push(s),s.addEventListener("scroll",this.onLayoutChange,{passive:!0}),s=s.parentNode;this.$elements=c}},u.prototype.unObserveLayoutChanges=function(){var s=this;window.removeEventListener("resize",this.onLayoutChange,{passive:!0}),window.removeEventListener("wheel",this.mousewheelListener),this.$elements&&this.$elements.forEach(function(c){c.removeEventListener("scroll",s.onLayoutChange,{passive:!0})}),this.$elements=null},u.prototype.onLayoutChange=function(){if(!this.popup.isOpen)return this.unObserveLayoutChanges();this.$updatePopupPosition(),this.updateDocTooltip()},u.prototype.$updatePopupPosition=function(){var s=this.editor,c=s.renderer,n=c.layerConfig.lineHeight,e=c.$cursorLayer.getPixelPosition(this.base,!0);e.left-=this.popup.getTextLeftOffset();var t=s.container.getBoundingClientRect();e.top+=t.top-c.layerConfig.offset,e.left+=t.left-s.renderer.scrollLeft,e.left+=c.gutterWidth;var i={top:e.top,left:e.left};c.$ghostText&&c.$ghostTextWidget&&this.base.row===c.$ghostText.position.row&&(i.top+=c.$ghostTextWidget.el.offsetHeight),!this.popup.tryShow(i,n,"bottom")&&(this.popup.tryShow(e,n,"top")||this.popup.show(e,n))},u.prototype.openPopup=function(s,c,n){this.$firstOpenTimer.cancel(),this.popup||this.$init(),this.inlineEnabled&&!this.inlineRenderer&&this.$initInline(),this.popup.autoSelect=this.autoSelect,this.popup.setSelectOnHover(this.setSelectOnHover);var i,e=this.popup.getRow(),t=this.popup.data[e];this.popup.setData(this.completions.filtered,this.completions.filterText),this.editor.textInput.setAriaOptions&&this.editor.textInput.setAriaOptions({activeDescendant:C(this.popup.getRow()),inline:this.inlineEnabled}),s.keyBinding.addKeyboardHandler(this.keyboardHandler),this.stickySelection&&(i=this.popup.data.indexOf(t)),(!i||-1===i)&&(i=0),this.popup.setRow(this.autoSelect?i:-1),i===e&&t!==this.completions.filtered[i]&&this.$onPopupChange(),n?n&&!c&&this.detach():(this.popup.setTheme(s.getTheme()),this.popup.setFontSize(s.getFontSize()),this.$updatePopupPosition(),this.tooltipNode&&this.updateDocTooltip()),this.changeTimer.cancel(),this.observeLayoutChanges()},u.prototype.detach=function(){this.editor&&(this.editor.keyBinding.removeKeyboardHandler(this.keyboardHandler),this.editor.off("changeSelection",this.changeListener),this.editor.off("blur",this.blurListener),this.editor.off("mousedown",this.mousedownListener),this.editor.off("mousewheel",this.mousewheelListener)),this.$firstOpenTimer.cancel(),this.changeTimer.cancel(),this.hideDocTooltip(),this.completionProvider&&this.completionProvider.detach(),this.popup&&this.popup.isOpen&&this.popup.hide(),this.base&&this.base.detach(),this.activated=!1,this.completionProvider=this.completions=this.base=null,this.unObserveLayoutChanges()},u.prototype.changeListener=function(s){var c=this.editor.selection.lead;(c.row!=this.base.row||c.column<this.base.column)&&this.detach(),this.activated?this.changeTimer.schedule():this.detach()},u.prototype.blurListener=function(s){var c=document.activeElement,n=this.editor.textInput.getElement(),e=s.relatedTarget&&this.tooltipNode&&this.tooltipNode.contains(s.relatedTarget);c!=n&&c.parentNode!=(this.popup&&this.popup.container)&&!e&&c!=this.tooltipNode&&s.relatedTarget!=n&&this.detach()},u.prototype.mousedownListener=function(s){this.detach()},u.prototype.mousewheelListener=function(s){this.popup.isMouseOver||this.detach()},u.prototype.mouseOutListener=function(s){this.popup.isOpen&&this.$updatePopupPosition()},u.prototype.goTo=function(s){this.popup.goTo(s)},u.prototype.insertMatch=function(s,c){if(s||(s=this.popup.getData(this.popup.getRow())),!s)return!1;if(""===s.value)return this.detach();var n=this.completions,e=this.getCompletionProvider().insertMatch(this.editor,s,n.filterText,c);return this.completions==n&&this.detach(),e},u.prototype.showPopup=function(s,c){this.editor&&this.detach(),this.activated=!0,this.editor=s,s.completer!=this&&(s.completer&&s.completer.detach(),s.completer=this),s.on("changeSelection",this.changeListener),s.on("blur",this.blurListener),s.on("mousedown",this.mousedownListener),s.on("mousewheel",this.mousewheelListener),this.updateCompletions(!1,c)},u.prototype.getCompletionProvider=function(s){return this.completionProvider||(this.completionProvider=new v(s)),this.completionProvider},u.prototype.gatherCompletions=function(s,c){return this.getCompletionProvider().gatherCompletions(s,c)},u.prototype.updateCompletions=function(s,c){if(s&&this.base&&this.completions){var e=this.editor.getCursorPosition();if((t=this.editor.session.getTextRange({start:this.base,end:e}))==this.completions.filterText)return;return this.completions.setFilter(t),this.completions.filtered.length&&(1!=this.completions.filtered.length||this.completions.filtered[0].value!=t||this.completions.filtered[0].snippet)?void this.openPopup(this.editor,t,s):this.detach()}if(c&&c.matches)return e=this.editor.getSelectionRange().start,this.base=this.editor.session.doc.createAnchor(e.row,e.column),this.base.$insertRight=!0,this.completions=new h(c.matches),this.openPopup(this.editor,"",s);var n=this.editor.getSession(),t=(e=this.editor.getCursorPosition(),S.getCompletionPrefix(this.editor));this.base=n.doc.createAnchor(e.row,e.column-t.length),this.base.$insertRight=!0;var i={exactMatch:this.exactMatch,ignoreCaption:this.ignoreCaption};this.getCompletionProvider({prefix:t,pos:e}).provideCompletions(this.editor,i,function(o,r,l){var a=r.filtered,f=S.getCompletionPrefix(this.editor);if(this.$firstOpenTimer.cancel(),l){if(!a.length){var p=!this.autoShown&&this.emptyMessage;return"function"==typeof p&&(p=this.emptyMessage(f)),p?(this.completions=new h([{caption:p,value:""}]),this.openPopup(this.editor,f,s),void this.popup.renderer.setStyle("ace_loading",!1)):this.detach()}if(1==a.length&&a[0].value==f&&!a[0].snippet)return this.detach();if(this.autoInsert&&!this.autoShown&&1==a.length)return this.insertMatch(a[0])}this.completions=!l&&this.showLoadingState?new h(u.completionsForLoading.concat(a),r.filterText):r,this.openPopup(this.editor,f,s),this.popup.renderer.setStyle("ace_loading",!l)}.bind(this)),this.showLoadingState&&!this.autoShown&&(!this.popup||!this.popup.isOpen)&&this.$firstOpenTimer.delay(this.stickySelectionDelay/2)},u.prototype.cancelContextMenu=function(){this.editor.$mouseHandler.cancelContextMenu()},u.prototype.updateDocTooltip=function(){var s=this.popup,c=this.completions.filtered,n=c&&(c[s.getHoveredRow()]||c[s.getRow()]),e=null;if(!n||!this.editor||!this.popup.isOpen)return this.hideDocTooltip();for(var t=this.editor.completers.length,i=0;i<t;i++){var o=this.editor.completers[i];if(o.getDocTooltip&&n.completerId===o.id){e=o.getDocTooltip(n);break}}if(!e&&"string"!=typeof n&&(e=n),"string"==typeof e&&(e={docText:e}),!e||!e.docHTML&&!e.docText)return this.hideDocTooltip();this.showDocTooltip(e)},u.prototype.showDocTooltip=function(s){this.tooltipNode||(this.tooltipNode=T.createElement("div"),this.tooltipNode.style.margin=0,this.tooltipNode.style.pointerEvents="auto",this.tooltipNode.tabIndex=-1,this.tooltipNode.onblur=this.blurListener.bind(this),this.tooltipNode.onclick=this.onTooltipClick.bind(this),this.tooltipNode.id="doc-tooltip",this.tooltipNode.setAttribute("role","tooltip"));var c=this.editor.renderer.theme;this.tooltipNode.className="ace_tooltip ace_doc-tooltip "+(c.isDark?"ace_dark ":"")+(c.cssClass||"");var n=this.tooltipNode;s.docHTML?n.innerHTML=s.docHTML:s.docText&&(n.textContent=s.docText),n.parentNode||this.popup.container.appendChild(this.tooltipNode);var e=this.popup,t=e.container.getBoundingClientRect();n.style.top=e.container.style.top,n.style.bottom=e.container.style.bottom,n.style.display="block",window.innerWidth-t.right<320?t.left<320?e.isTopdown?(n.style.top=t.bottom+"px",n.style.left=t.left+"px",n.style.right="",n.style.bottom=""):(n.style.top=e.container.offsetTop-n.offsetHeight+"px",n.style.left=t.left+"px",n.style.right="",n.style.bottom=""):(n.style.right=window.innerWidth-t.left+"px",n.style.left=""):(n.style.left=t.right+1+"px",n.style.right="")},u.prototype.hideDocTooltip=function(){if(this.tooltipTimer.cancel(),this.tooltipNode){var s=this.tooltipNode;!this.editor.isFocused()&&document.activeElement==s&&this.editor.focus(),this.tooltipNode=null,s.parentNode&&s.parentNode.removeChild(s)}},u.prototype.onTooltipClick=function(s){for(var c=s.target;c&&c!=this.tooltipNode;){if("A"==c.nodeName&&c.href){c.rel="noreferrer",c.target="_blank";break}c=c.parentNode}},u.prototype.destroy=function(){if(this.detach(),this.popup){this.popup.destroy();var s=this.popup.container;s&&s.parentNode&&s.parentNode.removeChild(s)}this.editor&&this.editor.completer==this&&(this.editor.off("destroy",M),this.editor.completer=null),this.inlineRenderer=this.popup=this.editor=null},u}();x.prototype.commands={Up:function(u){u.completer.goTo("up")},Down:function(u){u.completer.goTo("down")},"Ctrl-Up|Ctrl-Home":function(u){u.completer.goTo("start")},"Ctrl-Down|Ctrl-End":function(u){u.completer.goTo("end")},Esc:function(u){u.completer.detach()},Return:function(u){return u.completer.insertMatch()},"Shift-Return":function(u){u.completer.insertMatch(null,{deleteSuffix:!0})},Tab:function(u){var s=u.completer.insertMatch();if(s||u.tabstopManager)return s;u.completer.goTo("down")},PageUp:function(u){u.completer.popup.gotoPageUp()},PageDown:function(u){u.completer.popup.gotoPageDown()}},x.for=function(u){return u.completer instanceof x||(u.completer&&(u.completer.destroy(),u.completer=null),$.get("sharedPopups")?(x.$sharedInstance||(x.$sharedInstance=new x),u.completer=x.$sharedInstance):(u.completer=new x,u.once("destroy",M))),u.completer},x.startCommand={name:"startAutocomplete",exec:function(u,s){var c=x.for(u);c.autoInsert=!1,c.autoSelect=!0,c.autoShown=!1,c.showPopup(u,s),c.cancelContextMenu()},bindKey:"Ctrl-Space|Ctrl-Shift-Space|Alt-Space"};var v=function(){function u(s){this.initialPosition=s,this.active=!0}return u.prototype.insertByIndex=function(s,c,n){return!(!this.completions||!this.completions.filtered)&&this.insertMatch(s,this.completions.filtered[c],n)},u.prototype.insertMatch=function(s,c,n){if(!c)return!1;if(s.startOperation({command:{name:"insertMatch"}}),c.completer&&c.completer.insertMatch)c.completer.insertMatch(s,c);else{if(!this.completions)return!1;var e=this.completions.filterText.length,t=0;if(c.range&&c.range.start.row===c.range.end.row&&(e-=this.initialPosition.prefix.length,e+=this.initialPosition.pos.column-c.range.start.column,t+=c.range.end.column-this.initialPosition.pos.column),e||t){var i;i=s.selection.getAllRanges?s.selection.getAllRanges():[s.getSelectionRange()];for(var r,o=0;r=i[o];o++)r.start.column-=e,r.end.column+=t,s.session.remove(r)}c.snippet?P.insertSnippet(s,c.snippet):this.$insertString(s,c),c.command&&"startAutocomplete"===c.command&&s.execCommand(c.command)}return s.endOperation(),!0},u.prototype.$insertString=function(s,c){s.execCommand("insertstring",c.value||c)},u.prototype.gatherCompletions=function(s,c){var n=s.getSession(),e=s.getCursorPosition(),t=S.getCompletionPrefix(s),i=[];this.completers=s.completers;var o=s.completers.length;return s.completers.forEach(function(r,l){r.getCompletions(s,n,e,t,function(a,f){r.hideInlinePreview&&(f=f.map(function(p){return Object.assign(p,{hideInlinePreview:r.hideInlinePreview})})),!a&&f&&(i=i.concat(f)),c(null,{prefix:S.getCompletionPrefix(s),matches:i,finished:0==--o})})}),!0},u.prototype.provideCompletions=function(s,c,n){var e=function(r){var l=r.prefix;this.completions=new h(r.matches),c.exactMatch&&(this.completions.exactMatch=!0),c.ignoreCaption&&(this.completions.ignoreCaption=!0),this.completions.setFilter(l),(r.finished||this.completions.filtered.length)&&n(null,this.completions,r.finished)}.bind(this),t=!0,i=null;if(this.gatherCompletions(s,function(r,l){if(this.active&&(r&&(n(r,[],!0),this.detach()),0===l.prefix.indexOf(l.prefix))){if(t)return void(i=l);e(l)}}.bind(this)),t=!1,i){var o=i;i=null,e(o)}},u.prototype.detach=function(){this.active=!1,this.completers&&this.completers.forEach(function(s){"function"==typeof s.cancel&&s.cancel()})},u}(),h=function(){function u(s,c){this.all=s,this.filtered=s,this.filterText=c||"",this.exactMatch=!1,this.ignoreCaption=!1}return u.prototype.setFilter=function(s){if(s.length>this.filterText&&0===s.lastIndexOf(this.filterText,0))var c=this.filtered;else c=this.all;this.filterText=s,c=(c=this.filterCompletions(c,this.filterText)).sort(function(e,t){return t.exactMatch-e.exactMatch||t.$score-e.$score||(e.caption||e.value).localeCompare(t.caption||t.value)});var n=null;c=c.filter(function(e){var t=e.snippet||e.caption||e.value;return t!==n&&(n=t,!0)}),this.filtered=c},u.prototype.filterCompletions=function(s,c){var n=[],e=c.toUpperCase(),t=c.toLowerCase();e:for(var o,i=0;o=s[i];i++){var r=!this.ignoreCaption&&o.caption||o.value||o.snippet;if(r){var p,g,l=-1,a=0,f=0;if(this.exactMatch){if(c!==r.substr(0,c.length))continue e}else{var d=r.toLowerCase().indexOf(t);if(d>-1)f=d;else for(var m=0;m<c.length;m++){var w=r.indexOf(t[m],l+1),_=r.indexOf(e[m],l+1);if((p=w>=0&&(_<0||w<_)?w:_)<0)continue e;(g=p-l-1)>0&&(-1===l&&(f+=10),f+=g,a|=1<<m),l=p}}o.matchMask=a,o.exactMatch=f?0:1,o.$score=(o.score||0)-f,n.push(o)}}return n},u}();E.Autocomplete=x,E.CompletionProvider=v,E.FilteredList=h}),ace.define("ace/ext/menu_tools/settings_menu.css",["require","exports","module"],function(b,E,H){H.exports="#ace_settingsmenu, #kbshortcutmenu {\n    background-color: #F7F7F7;\n    color: black;\n    box-shadow: -5px 4px 5px rgba(126, 126, 126, 0.55);\n    padding: 1em 0.5em 2em 1em;\n    overflow: auto;\n    position: absolute;\n    margin: 0;\n    bottom: 0;\n    right: 0;\n    top: 0;\n    z-index: 9991;\n    cursor: default;\n}\n\n.ace_dark #ace_settingsmenu, .ace_dark #kbshortcutmenu {\n    box-shadow: -20px 10px 25px rgba(126, 126, 126, 0.25);\n    background-color: rgba(255, 255, 255, 0.6);\n    color: black;\n}\n\n.ace_optionsMenuEntry:hover {\n    background-color: rgba(100, 100, 100, 0.1);\n    transition: all 0.3s\n}\n\n.ace_closeButton {\n    background: rgba(245, 146, 146, 0.5);\n    border: 1px solid #F48A8A;\n    border-radius: 50%;\n    padding: 7px;\n    position: absolute;\n    right: -8px;\n    top: -8px;\n    z-index: 100000;\n}\n.ace_closeButton{\n    background: rgba(245, 146, 146, 0.9);\n}\n.ace_optionsMenuKey {\n    color: darkslateblue;\n    font-weight: bold;\n}\n.ace_optionsMenuCommand {\n    color: darkcyan;\n    font-weight: normal;\n}\n.ace_optionsMenuEntry input, .ace_optionsMenuEntry button {\n    vertical-align: middle;\n}\n\n.ace_optionsMenuEntry button[ace_selected_button=true] {\n    background: #e7e7e7;\n    box-shadow: 1px 0px 2px 0px #adadad inset;\n    border-color: #adadad;\n}\n.ace_optionsMenuEntry button {\n    background: white;\n    border: 1px solid lightgray;\n    margin: 0px;\n}\n.ace_optionsMenuEntry button:hover{\n    background: #f0f0f0;\n}"}),ace.define("ace/ext/menu_tools/overlay_page",["require","exports","module","ace/lib/dom","ace/ext/menu_tools/settings_menu.css"],function(b,E,H){"use strict";var A=b("../../lib/dom"),k=b("./settings_menu.css");A.importCssString(k,"settings_menu.css",!1),H.exports.overlayPage=function(C,S,y){var T=document.createElement("div"),P=!1;function $(x){27===x.keyCode&&O()}function O(){!T||(document.removeEventListener("keydown",$),T.parentNode.removeChild(T),C&&C.focus(),T=null,y&&y())}return T.style.cssText="margin: 0; padding: 0; position: fixed; top:0; bottom:0; left:0; right:0;z-index: 9990; "+(C?"background-color: rgba(0, 0, 0, 0.3);":""),T.addEventListener("click",function(x){P||O()}),document.addEventListener("keydown",$),S.addEventListener("click",function(x){x.stopPropagation()}),T.appendChild(S),document.body.appendChild(T),C&&C.blur(),{close:O,setIgnoreFocusOut:function M(x){P=x,x&&(T.style.pointerEvents="none",S.style.pointerEvents="auto")}}}}),ace.define("ace/ext/modelist",["require","exports","module"],function(b,E,H){"use strict";var A=[],L=function(){function x(v,h,u){var s;this.name=v,this.caption=h,this.mode="ace/mode/"+v,this.extensions=u,s=/\^/.test(u)?u.replace(/\|(\^)?/g,function(c,n){return"$|"+(n?"^":"^.*\\.")})+"$":"^.*\\.("+u+")$",this.extRe=new RegExp(s,"gi")}return x.prototype.supportsFile=function(v){return v.match(this.extRe)},x}(),C={ABAP:["abap"],ABC:["abc"],ActionScript:["as"],ADA:["ada|adb"],Alda:["alda"],Apache_Conf:["^htaccess|^htgroups|^htpasswd|^conf|htaccess|htgroups|htpasswd"],Apex:["apex|cls|trigger|tgr"],AQL:["aql"],AsciiDoc:["asciidoc|adoc"],ASL:["dsl|asl|asl.json"],Assembly_x86:["asm|a"],Astro:["astro"],AutoHotKey:["ahk"],BatchFile:["bat|cmd"],BibTeX:["bib"],C_Cpp:["cpp|c|cc|cxx|h|hh|hpp|ino"],C9Search:["c9search_results"],Cirru:["cirru|cr"],Clojure:["clj|cljs"],Cobol:["CBL|COB"],coffee:["coffee|cf|cson|^Cakefile"],ColdFusion:["cfm|cfc"],Crystal:["cr"],CSharp:["cs"],Csound_Document:["csd"],Csound_Orchestra:["orc"],Csound_Score:["sco"],CSS:["css"],Curly:["curly"],Cuttlefish:["conf"],D:["d|di"],Dart:["dart"],Diff:["diff|patch"],Django:["djt|html.djt|dj.html|djhtml"],Dockerfile:["^Dockerfile"],Dot:["dot"],Drools:["drl"],Edifact:["edi"],Eiffel:["e|ge"],EJS:["ejs"],Elixir:["ex|exs"],Elm:["elm"],Erlang:["erl|hrl"],Flix:["flix"],Forth:["frt|fs|ldr|fth|4th"],Fortran:["f|f90"],FSharp:["fsi|fs|ml|mli|fsx|fsscript"],FSL:["fsl"],FTL:["ftl"],Gcode:["gcode"],Gherkin:["feature"],Gitignore:["^.gitignore"],Glsl:["glsl|frag|vert"],Gobstones:["gbs"],golang:["go"],GraphQLSchema:["gql"],Groovy:["groovy"],HAML:["haml"],Handlebars:["hbs|handlebars|tpl|mustache"],Haskell:["hs"],Haskell_Cabal:["cabal"],haXe:["hx"],Hjson:["hjson"],HTML:["html|htm|xhtml|vue|we|wpy"],HTML_Elixir:["eex|html.eex"],HTML_Ruby:["erb|rhtml|html.erb"],INI:["ini|conf|cfg|prefs"],Io:["io"],Ion:["ion"],Jack:["jack"],Jade:["jade|pug"],Java:["java"],JavaScript:["js|jsm|jsx|cjs|mjs"],JEXL:["jexl"],JSON:["json"],JSON5:["json5"],JSONiq:["jq"],JSP:["jsp"],JSSM:["jssm|jssm_state"],JSX:["jsx"],Julia:["jl"],Kotlin:["kt|kts"],LaTeX:["tex|latex|ltx|bib"],Latte:["latte"],LESS:["less"],Liquid:["liquid"],Lisp:["lisp"],LiveScript:["ls"],Log:["log"],LogiQL:["logic|lql"],Logtalk:["lgt"],LSL:["lsl"],Lua:["lua"],LuaPage:["lp"],Lucene:["lucene"],Makefile:["^Makefile|^GNUmakefile|^makefile|^OCamlMakefile|make"],Markdown:["md|markdown"],Mask:["mask"],MATLAB:["matlab"],Maze:["mz"],MediaWiki:["wiki|mediawiki"],MEL:["mel"],MIPS:["s|asm"],MIXAL:["mixal"],MUSHCode:["mc|mush"],MySQL:["mysql"],Nasal:["nas"],Nginx:["nginx|conf"],Nim:["nim"],Nix:["nix"],NSIS:["nsi|nsh"],Nunjucks:["nunjucks|nunjs|nj|njk"],ObjectiveC:["m|mm"],OCaml:["ml|mli"],Odin:["odin"],PartiQL:["partiql|pql"],Pascal:["pas|p"],Perl:["pl|pm"],pgSQL:["pgsql"],PHP:["php|inc|phtml|shtml|php3|php4|php5|phps|phpt|aw|ctp|module"],PHP_Laravel_blade:["blade.php"],Pig:["pig"],PLSQL:["plsql"],Powershell:["ps1"],Praat:["praat|praatscript|psc|proc"],Prisma:["prisma"],Prolog:["plg|prolog"],Properties:["properties"],Protobuf:["proto"],PRQL:["prql"],Puppet:["epp|pp"],Python:["py"],QML:["qml"],R:["r"],Raku:["raku|rakumod|rakutest|p6|pl6|pm6"],Razor:["cshtml|asp"],RDoc:["Rd"],Red:["red|reds"],RHTML:["Rhtml"],Robot:["robot|resource"],RST:["rst"],Ruby:["rb|ru|gemspec|rake|^Guardfile|^Rakefile|^Gemfile"],Rust:["rs"],SaC:["sac"],SASS:["sass"],SCAD:["scad"],Scala:["scala|sbt"],Scheme:["scm|sm|rkt|oak|scheme"],Scrypt:["scrypt"],SCSS:["scss"],SH:["sh|bash|^.bashrc"],SJS:["sjs"],Slim:["slim|skim"],Smarty:["smarty|tpl"],Smithy:["smithy"],snippets:["snippets"],Soy_Template:["soy"],Space:["space"],SPARQL:["rq"],SQL:["sql"],SQLServer:["sqlserver"],Stylus:["styl|stylus"],SVG:["svg"],Swift:["swift"],Tcl:["tcl"],Terraform:["tf","tfvars","terragrunt"],Tex:["tex"],Text:["txt"],Textile:["textile"],Toml:["toml"],TSX:["tsx"],Turtle:["ttl"],Twig:["twig|swig"],Typescript:["ts|mts|cts|typescript|str"],Vala:["vala"],VBScript:["vbs|vb"],Velocity:["vm"],Verilog:["v|vh|sv|svh"],VHDL:["vhd|vhdl"],Visualforce:["vfp|component|page"],Wollok:["wlk|wpgm|wtest"],XML:["xml|rdf|rss|wsdl|xslt|atom|mathml|mml|xul|xbl|xaml"],XQuery:["xq"],YAML:["yaml|yml"],Zeek:["zeek|bro"]},S={ObjectiveC:"Objective-C",CSharp:"C#",golang:"Go",C_Cpp:"C and C++",Csound_Document:"Csound Document",Csound_Orchestra:"Csound",Csound_Score:"Csound Score",coffee:"CoffeeScript",HTML_Ruby:"HTML (Ruby)",HTML_Elixir:"HTML (Elixir)",FTL:"FreeMarker",PHP_Laravel_blade:"PHP (Blade Template)",Perl6:"Perl 6",AutoHotKey:"AutoHotkey / AutoIt"},y={};for(var T in C){var P=C[T],$=(S[T]||T).replace(/_/g," "),O=T.toLowerCase(),M=new L(O,$,P[0]);y[O]=M,A.push(M)}H.exports={getModeForPath:function k(x){for(var v=y.text,h=x.split(/[\/\\]/).pop(),u=0;u<A.length;u++)if(A[u].supportsFile(h)){v=A[u];break}return v},modes:A,modesByName:y}}),ace.define("ace/ext/prompt",["require","exports","module","ace/config","ace/range","ace/lib/dom","ace/autocomplete","ace/autocomplete/popup","ace/autocomplete/popup","ace/undomanager","ace/tokenizer","ace/ext/menu_tools/overlay_page","ace/ext/modelist"],function(b,E,H){"use strict";var M,A=b("../config").nls,k=b("../range").Range,L=b("../lib/dom"),C=b("../autocomplete").FilteredList,S=b("../autocomplete/popup").AcePopup,y=b("../autocomplete/popup").$singleLineEditor,T=b("../undomanager").UndoManager,P=b("../tokenizer").Tokenizer,$=b("./menu_tools/overlay_page").overlayPage,O=b("./modelist");function x(v,h,u,s){if("object"==typeof h)return x(v,"",h,u);if(M){var c=M;if(v=c.editor,c.close(),c.name&&c.name==u.name)return}if(u.$type)return x[u.$type](v,s);var n=y();n.session.setUndoManager(new T);var e=L.buildDom(["div",{class:"ace_prompt_container"+(u.hasDescription?" input-box-with-description":"")}]),t=$(v,e,f);if(e.appendChild(n.container),v&&(v.cmdLine=n,n.setOption("fontSize",v.getOption("fontSize"))),h&&n.setValue(h,1),u.selection&&n.selection.setRange({start:n.session.doc.indexToPosition(u.selection[0]),end:n.session.doc.indexToPosition(u.selection[1])}),u.getCompletions){var i=new S;i.renderer.setStyle("ace_autocomplete_inline"),i.container.style.display="block",i.container.style.maxWidth="600px",i.container.style.width="100%",i.container.style.marginTop="3px",i.renderer.setScrollMargin(2,2,0,0),i.autoSelect=!1,i.renderer.$maxLines=15,i.setRow(-1),i.on("click",function(d){var m=i.getData(i.getRow());m.error||(n.setValue(m.value||m.name||m),l(),d.stop())}),e.appendChild(i.container),p()}if(u.$rules){var o=new P(u.$rules);n.session.bgTokenizer.setTokenizer(o)}if(u.placeholder&&n.setOption("placeholder",u.placeholder),u.hasDescription){var r=L.buildDom(["div",{class:"ace_prompt_text_container"}]);L.buildDom(u.prompt||"Press 'Enter' to confirm or 'Escape' to cancel",r),e.appendChild(r)}function l(){var d;d=i&&i.getCursorPosition().row>0?g():n.getValue();var m=i?i.getData(i.getRow()):d;m&&!m.error&&(f(),u.onAccept&&u.onAccept({value:d,item:m},n))}t.setIgnoreFocusOut(u.ignoreFocusOut);var a={Enter:l,"Esc|Shift-Esc":function(){u.onCancel&&u.onCancel(n.getValue(),n),f()}};function f(){t.close(),s&&s(),M=null}function p(){if(u.getCompletions){var d;u.getPrefix&&(d=u.getPrefix(n));var m=u.getCompletions(n);i.setData(m,d),i.resize(!0)}}function g(){var d=i.getData(i.getRow());if(d&&!d.error)return d.value||d.caption||d}i&&Object.assign(a,{Up:function(d){i.goTo("up"),g()},Down:function(d){i.goTo("down"),g()},"Ctrl-Up|Ctrl-Home":function(d){i.goTo("start"),g()},"Ctrl-Down|Ctrl-End":function(d){i.goTo("end"),g()},Tab:function(d){i.goTo("down"),g()},PageUp:function(d){i.gotoPageUp(),g()},PageDown:function(d){i.gotoPageDown(),g()}}),n.commands.bindKeys(a),n.on("input",function(){u.onInput&&u.onInput(),p()}),n.resize(!0),i&&i.resize(!0),n.focus(),M={close:f,name:u.name,editor:v}}x.gotoLine=function(v,h){x(v,":"+function u(s){return Array.isArray(s)||(s=[s]),s.map(function(c){var n=c.isBackwards?c.start:c.end,e=c.isBackwards?c.end:c.start,i=e.row+1+":"+e.column;return e.row==n.row?e.column!=n.column&&(i+=">:"+n.column):i+=">"+(n.row+1)+":"+n.column,i}).reverse().join(", ")}(v.selection.toJSON()),{name:"gotoLine",selection:[1,Number.MAX_VALUE],onAccept:function(s){var c=s.value,n=x.gotoLine._history;n||(x.gotoLine._history=n=[]),-1!=n.indexOf(c)&&n.splice(n.indexOf(c),1),n.unshift(c),n.length>20&&(n.length=20);var e=v.getCursorPosition(),t=[];c.replace(/^:/,"").split(/,/).map(function(o){var r=o.split(/([<>:+-]|c?\d+)|[^c\d<>:+-]+/).filter(Boolean),l=0;function a(){var p=r[l++];if(p){if("c"==p[0]){var g=parseInt(p.slice(1))||0;return v.session.doc.indexToPosition(g)}var d=e.row,m=0;return/\d/.test(p)&&(d=parseInt(p)-1,p=r[l++]),":"==p&&(p=r[l++],/\d/.test(p)&&(m=parseInt(p)||0)),{row:d,column:m}}}e=a();var f=k.fromPoints(e,e);">"==r[l]?(l++,f.end=a()):"<"==r[l]&&(l++,f.start=a()),t.unshift(f)}),v.selection.fromJSON(t);var i=v.renderer.scrollTop;v.renderer.scrollSelectionIntoView(v.selection.anchor,v.selection.cursor,.5),v.renderer.animateScrolling(i)},history:function(){return x.gotoLine._history?x.gotoLine._history:[]},getCompletions:function(s){var c=s.getValue(),n=c.replace(/^:/,"").split(":"),e=Math.min(parseInt(n[0])||1,v.session.getLength())-1;return[c+"  "+v.session.getLine(e)].concat(this.history())},$rules:{start:[{regex:/\d+/,token:"string"},{regex:/[:,><+\-c]/,token:"keyword"}]}})},x.commands=function(v,h){function u(e){return(e||"").replace(/^./,function(t){return t.toUpperCase(t)}).replace(/[a-z][A-Z]/g,function(t){return t[0]+" "+t[1].toLowerCase(t)})}var n=function s(e){var t=[],i={};return v.keyBinding.$handlers.forEach(function(o){var r=o.platform,l=o.byName;for(var a in l){var f=l[a].bindKey;"string"!=typeof f&&(f=f&&f[r]||"");var p=l[a],g=p.description||u(p.name);Array.isArray(p)||(p=[p]),p.forEach(function(d){"string"!=typeof d&&(d=d.name),e.find(function(w){return w===d})||(i[d]?i[d].key+="|"+f:(i[d]={key:f,command:d,description:g},t.push(i[d])))})}}),t}(["insertstring","inserttext","setIndentation","paste"]);n=n.map(function(e){return{value:e.description,meta:e.key,command:e.command}}),x(v,"",{name:"commands",selection:[0,Number.MAX_VALUE],maxHistoryCount:5,onAccept:function(e){if(e.item){var t=e.item.command;this.addToHistory(e.item),v.execCommand(t)}},addToHistory:function(e){var t=this.history();t.unshift(e),delete e.message;for(var i=1;i<t.length;i++)if(t[i].command==e.command){t.splice(i,1);break}this.maxHistoryCount>0&&t.length>this.maxHistoryCount&&t.splice(t.length-1,1),x.commands.history=t},history:function(){return x.commands.history||[]},getPrefix:function(e){var t=e.getCursorPosition();return e.getValue().substring(0,t.column)},getCompletions:function(e){function t(f,p){var g=JSON.parse(JSON.stringify(f));return new C(g).filterCompletions(g,p)}var o=this.getPrefix(e),r=t(this.history(),o),l=function i(f,p){if(!p||!p.length)return f;var g=[];p.forEach(function(m){g.push(m.command)});var d=[];return f.forEach(function(m){-1===g.indexOf(m.command)&&d.push(m)}),d}(n,r);l=t(l,o),r.length&&l.length&&(r[0].message=A("Recently used"),l[0].message=A("Other commands"));var a=r.concat(l);return a.length>0?a:[{value:A("No matching commands"),error:1}]}})},x.modes=function(v,h){var u=O.modes;u=u.map(function(s){return{value:s.caption,mode:s.name}}),x(v,"",{name:"modes",selection:[0,Number.MAX_VALUE],onAccept:function(s){s.item&&v.session.setMode("ace/mode/"+s.item.mode)},getPrefix:function(s){var c=s.getCursorPosition();return s.getValue().substring(0,c.column)},getCompletions:function(s){var n=this.getPrefix(s),e=function c(t,i){var o=JSON.parse(JSON.stringify(t));return new C(o).filterCompletions(o,i)}(u,n);return e.length>0?e:[{caption:"No mode matching",value:"No mode matching",error:1}]}})},L.importCssString(".ace_prompt_container {\n    max-width: 603px;\n    width: 100%;\n    margin: 20px auto;\n    padding: 3px;\n    background: white;\n    border-radius: 2px;\n    box-shadow: 0px 2px 3px 0px #555;\n}","promtp.css",!1),E.prompt=x}),ace.require(["ace/ext/prompt"],function(b){"object"==typeof module&&"object"==typeof exports&&module&&(module.exports=b)});