ace.define("ace/mode/ion_highlight_rules",["require","exports","module","ace/lib/oop","ace/mode/text_highlight_rules"],function(r,s,p){"use strict";var h=r("../lib/oop"),g=r("./text_highlight_rules").TextHighlightRules,c=function(){var i={token:this.createKeywordMapper({"constant.language.bool.ion":"TRUE|FALSE","constant.language.null.ion":"NULL.NULL|NULL.BOOL|NULL.INT|NULL.FLOAT|NULL.DECIMAL|NULL.TIMESTAMP|NULL.STRING|NULL.SYMBOL|NULL.BLOB|NULL.CLOB|NULL.STRUCT|NULL.LIST|NULL.SEXP|NULL"},"constant.other.symbol.identifier.ion",!0),regex:"\\b\\w+(?:\\.\\w+)?\\b"};this.$rules={start:[{include:"value"}],value:[{include:"whitespace"},{include:"comment"},{include:"annotation"},{include:"string"},{include:"number"},{include:"keywords"},{include:"symbol"},{include:"clob"},{include:"blob"},{include:"struct"},{include:"list"},{include:"sexp"}],sexp:[{token:"punctuation.definition.sexp.begin.ion",regex:"\\(",push:[{token:"punctuation.definition.sexp.end.ion",regex:"\\)",next:"pop"},{include:"comment"},{include:"value"},{token:"storage.type.symbol.operator.ion",regex:"[\\!\\#\\%\\&\\*\\+\\-\\./\\;\\<\\=\\>\\?\\@\\^\\`\\|\\~]+"}]}],comment:[{token:"comment.line.ion",regex:"//[^\\n]*"},{token:"comment.block.ion",regex:"/\\*",push:[{token:"comment.block.ion",regex:"[*]/",next:"pop"},{token:"comment.block.ion",regex:"[^*/]+"},{token:"comment.block.ion",regex:"[*/]+"}]}],list:[{token:"punctuation.definition.list.begin.ion",regex:"\\[",push:[{token:"punctuation.definition.list.end.ion",regex:"\\]",next:"pop"},{include:"comment"},{include:"value"},{token:"punctuation.definition.list.separator.ion",regex:","}]}],struct:[{token:"punctuation.definition.struct.begin.ion",regex:"\\{",push:[{token:"punctuation.definition.struct.end.ion",regex:"\\}",next:"pop"},{include:"comment"},{include:"value"},{token:"punctuation.definition.struct.separator.ion",regex:",|:"}]}],blob:[{token:["punctuation.definition.blob.begin.ion","string.other.blob.ion","punctuation.definition.blob.end.ion"],regex:'(\\{\\{)([^"]*)(\\}\\})'}],clob:[{token:["punctuation.definition.clob.begin.ion","string.other.clob.ion","punctuation.definition.clob.end.ion"],regex:'(\\{\\{)("[^"]*")(\\}\\})'}],symbol:[{token:"storage.type.symbol.quoted.ion",regex:"(['])((?:(?:\\\\')|(?:[^']))*?)(['])"},{token:"storage.type.symbol.identifier.ion",regex:"[\\$_a-zA-Z][\\$_a-zA-Z0-9]*"}],number:[{token:"constant.numeric.timestamp.ion",regex:"\\d{4}(?:-\\d{2})?(?:-\\d{2})?T(?:\\d{2}:\\d{2})(?::\\d{2})?(?:\\.\\d+)?(?:Z|[-+]\\d{2}:\\d{2})?"},{token:"constant.numeric.timestamp.ion",regex:"\\d{4}-\\d{2}-\\d{2}T?"},{token:"constant.numeric.integer.binary.ion",regex:"-?0[bB][01](?:_?[01])*"},{token:"constant.numeric.integer.hex.ion",regex:"-?0[xX][0-9a-fA-F](?:_?[0-9a-fA-F])*"},{token:"constant.numeric.float.ion",regex:"-?(?:0|[1-9](?:_?\\d)*)(?:\\.(?:\\d(?:_?\\d)*)?)?(?:[eE][+-]?\\d+)"},{token:"constant.numeric.float.ion",regex:"(?:[-+]inf)|(?:nan)"},{token:"constant.numeric.decimal.ion",regex:"-?(?:0|[1-9](?:_?\\d)*)(?:(?:(?:\\.(?:\\d(?:_?\\d)*)?)(?:[dD][+-]?\\d+)|\\.(?:\\d(?:_?\\d)*)?)|(?:[dD][+-]?\\d+))"},{token:"constant.numeric.integer.ion",regex:"-?(?:0|[1-9](?:_?\\d)*)"}],string:[{token:["punctuation.definition.string.begin.ion","string.quoted.double.ion","punctuation.definition.string.end.ion"],regex:'(["])((?:(?:\\\\")|(?:[^"]))*?)(["])'},{token:"punctuation.definition.string.begin.ion",regex:"'{3}",push:[{token:"punctuation.definition.string.end.ion",regex:"'{3}",next:"pop"},{token:"string.quoted.triple.ion",regex:"(?:\\\\'|[^'])+"},{token:"string.quoted.triple.ion",regex:"'"}]}],annotation:[{token:["variable.language.annotation.ion","punctuation.definition.annotation.ion"],regex:"('(?:[^']|\\\\\\\\|\\\\')*')\\s*(::)"},{token:["variable.language.annotation.ion","punctuation.definition.annotation.ion"],regex:"([\\$_a-zA-Z][\\$_a-zA-Z0-9]*)\\s*(::)"}],whitespace:[{token:"text.ion",regex:"\\s+"}]},this.$rules.keywords=[i],this.normalizeRules()};h.inherits(c,g),s.IonHighlightRules=c}),ace.define("ace/mode/matching_brace_outdent",["require","exports","module","ace/range"],function(r,s,p){"use strict";var h=r("../range").Range,g=function(){};(function(){this.checkOutdent=function(c,u){return!!/^\s+$/.test(c)&&/^\s*\}/.test(u)},this.autoOutdent=function(c,u){var n=c.getLine(u).match(/^(\s*\})/);if(!n)return 0;var t=n[1].length,o=c.findMatchingBracket({row:u,column:t});if(!o||o.row==u)return 0;var i=this.$getIndent(c.getLine(o.row));c.replace(new h(u,0,u,t-1),i)},this.$getIndent=function(c){return c.match(/^\s*/)[0]}}).call(g.prototype),s.MatchingBraceOutdent=g}),ace.define("ace/mode/folding/cstyle",["require","exports","module","ace/lib/oop","ace/range","ace/mode/folding/fold_mode"],function(r,s,p){"use strict";var h=r("../../lib/oop"),g=r("../../range").Range,c=r("./fold_mode").FoldMode,u=s.FoldMode=function(e){e&&(this.foldingStartMarker=new RegExp(this.foldingStartMarker.source.replace(/\|[^|]*?$/,"|"+e.start)),this.foldingStopMarker=new RegExp(this.foldingStopMarker.source.replace(/\|[^|]*?$/,"|"+e.end)))};h.inherits(u,c),function(){this.foldingStartMarker=/([\{\[\(])[^\}\]\)]*$|^\s*(\/\*)/,this.foldingStopMarker=/^[^\[\{\(]*([\}\]\)])|^[\s\*]*(\*\/)/,this.singleLineBlockCommentRe=/^\s*(\/\*).*\*\/\s*$/,this.tripleStarBlockCommentRe=/^\s*(\/\*\*\*).*\*\/\s*$/,this.startRegionRe=/^\s*(\/\*|\/\/)#?region\b/,this._getFoldWidgetBase=this.getFoldWidget,this.getFoldWidget=function(e,n,t){var o=e.getLine(t);if(this.singleLineBlockCommentRe.test(o)&&!this.startRegionRe.test(o)&&!this.tripleStarBlockCommentRe.test(o))return"";var i=this._getFoldWidgetBase(e,n,t);return!i&&this.startRegionRe.test(o)?"start":i},this.getFoldWidgetRange=function(e,n,t,o){var a,i=e.getLine(t);if(this.startRegionRe.test(i))return this.getCommentRegionBlock(e,i,t);if(a=i.match(this.foldingStartMarker)){var l=a.index;if(a[1])return this.openingBracketBlock(e,a[1],t,l);var d=e.getCommentFoldRange(t,l+a[0].length,1);return d&&!d.isMultiLine()&&(o?d=this.getSectionRange(e,t):"all"!=n&&(d=null)),d}return"markbegin"!==n&&(a=i.match(this.foldingStopMarker))?(l=a.index+a[0].length,a[1]?this.closingBracketBlock(e,a[1],t,l):e.getCommentFoldRange(t,l,-1)):void 0},this.getSectionRange=function(e,n){for(var t=e.getLine(n),o=t.search(/\S/),i=n,l=t.length,d=n+=1,a=e.getLength();++n<a;){var f=(t=e.getLine(n)).search(/\S/);if(-1!==f){if(o>f)break;var m=this.getFoldWidgetRange(e,"all",n);if(m){if(m.start.row<=i)break;if(m.isMultiLine())n=m.end.row;else if(o==f)break}d=n}}return new g(i,l,d,e.getLine(d).length)},this.getCommentRegionBlock=function(e,n,t){for(var o=n.search(/\s*$/),i=e.getLength(),l=t,d=/^\s*(?:\/\*|\/\/|--)#?(end)?region\b/,a=1;++t<i;){n=e.getLine(t);var f=d.exec(n);if(f&&(f[1]?a--:a++,!a))break}if(t>l)return new g(l,o,t,n.length)}}.call(u.prototype)}),ace.define("ace/mode/ion",["require","exports","module","ace/lib/oop","ace/mode/text","ace/mode/ion_highlight_rules","ace/mode/matching_brace_outdent","ace/mode/behaviour/cstyle","ace/mode/folding/cstyle"],function(r,s,p){"use strict";var h=r("../lib/oop"),g=r("./text").Mode,c=r("./ion_highlight_rules").IonHighlightRules,u=r("./matching_brace_outdent").MatchingBraceOutdent,e=r("./behaviour/cstyle").CstyleBehaviour,n=r("./folding/cstyle").FoldMode,t=function(){this.HighlightRules=c,this.$outdent=new u,this.$behaviour=new e,this.foldingRules=new n};h.inherits(t,g),function(){this.lineCommentStart="//",this.blockComment={start:"/*",end:"*/"},this.getNextLineIndent=function(o,i,l){var d=this.$getIndent(i);return"start"==o&&i.match(/^.*[\{\(\[]\s*$/)&&(d+=l),d},this.checkOutdent=function(o,i,l){return this.$outdent.checkOutdent(i,l)},this.autoOutdent=function(o,i,l){this.$outdent.autoOutdent(i,l)},this.$id="ace/mode/ion"}.call(t.prototype),s.Mode=t}),ace.require(["ace/mode/ion"],function(r){"object"==typeof module&&"object"==typeof exports&&module&&(module.exports=r)});