ace.define("ace/mode/sh_highlight_rules",["require","exports","module","ace/lib/oop","ace/mode/text_highlight_rules"],function(a,u,b){"use strict";var v=a("../lib/oop"),d=a("./text_highlight_rules").TextHighlightRules,p=u.reservedKeywords="!|{|}|case|do|done|elif|else|esac|fi|for|if|in|then|until|while|&|;|export|local|read|typeset|unset|elif|select|set|function|declare|readonly",c=u.languageConstructs="[|]|alias|bg|bind|break|builtin|cd|command|compgen|complete|continue|dirs|disown|echo|enable|eval|exec|exit|fc|fg|getopts|hash|help|history|jobs|kill|let|logout|popd|printf|pushd|pwd|return|set|shift|shopt|source|suspend|test|times|trap|type|ulimit|umask|unalias|wait",e=function(){var n=this.createKeywordMapper({keyword:p,"support.function.builtin":c,"invalid.deprecated":"debugger"},"identifier");this.$rules={start:[{token:"constant",regex:/\\./},{token:["text","comment"],regex:/(^|\s)(#.*)$/},{token:"string.start",regex:'"',push:[{token:"constant.language.escape",regex:/\\(?:[$`"\\]|$)/},{include:"variables"},{token:"keyword.operator",regex:/`/},{token:"string.end",regex:'"',next:"pop"},{defaultToken:"string"}]},{token:"string",regex:"\\$'",push:[{token:"constant.language.escape",regex:/\\(?:[abeEfnrtv\\'"]|x[a-fA-F\d]{1,2}|u[a-fA-F\d]{4}([a-fA-F\d]{4})?|c.|\d{1,3})/},{token:"string",regex:"'",next:"pop"},{defaultToken:"string"}]},{regex:"<<<",token:"keyword.operator"},{stateName:"heredoc",regex:"(<<-?)(\\s*)(['\"`]?)([\\w\\-]+)(['\"`]?)",onMatch:function(k,m,f){var _="-"==k[2]?"indentedHeredoc":"heredoc",x=k.split(this.splitRegex);return f.push(_,x[4]),[{type:"constant",value:x[1]},{type:"text",value:x[2]},{type:"string",value:x[3]},{type:"support.class",value:x[4]},{type:"string",value:x[5]}]},rules:{heredoc:[{onMatch:function(k,m,f){return k===f[1]?(f.shift(),f.shift(),this.next=f[0]||"start","support.class"):(this.next="","string")},regex:".*$",next:"start"}],indentedHeredoc:[{token:"string",regex:"^\t+"},{onMatch:function(k,m,f){return k===f[1]?(f.shift(),f.shift(),this.next=f[0]||"start","support.class"):(this.next="","string")},regex:".*$",next:"start"}]}},{regex:"$",token:"empty",next:function(k,m){return"heredoc"===m[0]||"indentedHeredoc"===m[0]?m[0]:k}},{token:["keyword","text","text","text","variable"],regex:/(declare|local|readonly)(\s+)(?:(-[fixar]+)(\s+))?([a-zA-Z_][a-zA-Z0-9_]*\b)/},{token:"variable.language",regex:"(?:\\$(?:SHLVL|\\$|\\!|\\?))"},{token:"variable",regex:"(?:[a-zA-Z_][a-zA-Z0-9_]*(?==))"},{include:"variables"},{token:"support.function",regex:"(?:[a-zA-Z_][a-zA-Z0-9_]*\\s*\\(\\))"},{token:"support.function",regex:"(?:&(?:\\d+))"},{token:"string",start:"'",end:"'"},{token:"constant.numeric",regex:"(?:(?:(?:(?:(?:(?:\\d+)?(?:\\.\\d+))|(?:(?:\\d+)\\.))|(?:\\d+)))|(?:(?:(?:\\d+)?(?:\\.\\d+))|(?:(?:\\d+)\\.)))"},{token:"constant.numeric",regex:"(?:(?:[1-9]\\d*)|(?:0))\\b"},{token:n,regex:"[a-zA-Z_][a-zA-Z0-9_]*\\b"},{token:"keyword.operator",regex:"\\+|\\-|\\*|\\*\\*|\\/|\\/\\/|~|<|>|<=|=>|=|!=|[%&|`]"},{token:"punctuation.operator",regex:";"},{token:"paren.lparen",regex:"[\\[\\(\\{]"},{token:"paren.rparen",regex:"[\\]]"},{token:"paren.rparen",regex:"[\\)\\}]",next:"pop"}],variables:[{token:"variable",regex:/(\$)(\w+)/},{token:["variable","paren.lparen"],regex:/(\$)(\()/,push:"start"},{token:["variable","paren.lparen","keyword.operator","variable","keyword.operator"],regex:/(\$)(\{)([#!]?)(\w+|[*@#?\-$!0_])(:[?+\-=]?|##?|%%?|,,?\/|\^\^?)?/,push:"start"},{token:"variable",regex:/\$[*@#?\-$!0_]/},{token:["variable","paren.lparen"],regex:/(\$)(\{)/,push:"start"}]},this.normalizeRules()};v.inherits(e,d),u.ShHighlightRules=e}),ace.define("ace/mode/folding/cstyle",["require","exports","module","ace/lib/oop","ace/range","ace/mode/folding/fold_mode"],function(a,u,b){"use strict";var v=a("../../lib/oop"),d=a("../../range").Range,p=a("./fold_mode").FoldMode,c=u.FoldMode=function(e){e&&(this.foldingStartMarker=new RegExp(this.foldingStartMarker.source.replace(/\|[^|]*?$/,"|"+e.start)),this.foldingStopMarker=new RegExp(this.foldingStopMarker.source.replace(/\|[^|]*?$/,"|"+e.end)))};v.inherits(c,p),function(){this.foldingStartMarker=/([\{\[\(])[^\}\]\)]*$|^\s*(\/\*)/,this.foldingStopMarker=/^[^\[\{\(]*([\}\]\)])|^[\s\*]*(\*\/)/,this.singleLineBlockCommentRe=/^\s*(\/\*).*\*\/\s*$/,this.tripleStarBlockCommentRe=/^\s*(\/\*\*\*).*\*\/\s*$/,this.startRegionRe=/^\s*(\/\*|\/\/)#?region\b/,this._getFoldWidgetBase=this.getFoldWidget,this.getFoldWidget=function(e,n,r){var g=e.getLine(r);if(this.singleLineBlockCommentRe.test(g)&&!this.startRegionRe.test(g)&&!this.tripleStarBlockCommentRe.test(g))return"";var o=this._getFoldWidgetBase(e,n,r);return!o&&this.startRegionRe.test(g)?"start":o},this.getFoldWidgetRange=function(e,n,r,g){var t,o=e.getLine(r);if(this.startRegionRe.test(o))return this.getCommentRegionBlock(e,o,r);if(t=o.match(this.foldingStartMarker)){var l=t.index;if(t[1])return this.openingBracketBlock(e,t[1],r,l);var i=e.getCommentFoldRange(r,l+t[0].length,1);return i&&!i.isMultiLine()&&(g?i=this.getSectionRange(e,r):"all"!=n&&(i=null)),i}return"markbegin"!==n&&(t=o.match(this.foldingStopMarker))?(l=t.index+t[0].length,t[1]?this.closingBracketBlock(e,t[1],r,l):e.getCommentFoldRange(r,l,-1)):void 0},this.getSectionRange=function(e,n){for(var r=e.getLine(n),g=r.search(/\S/),o=n,l=r.length,i=n+=1,t=e.getLength();++n<t;){var s=(r=e.getLine(n)).search(/\S/);if(-1!==s){if(g>s)break;var h=this.getFoldWidgetRange(e,"all",n);if(h){if(h.start.row<=o)break;if(h.isMultiLine())n=h.end.row;else if(g==s)break}i=n}}return new d(o,l,i,e.getLine(i).length)},this.getCommentRegionBlock=function(e,n,r){for(var g=n.search(/\s*$/),o=e.getLength(),l=r,i=/^\s*(?:\/\*|\/\/|--)#?(end)?region\b/,t=1;++r<o;){n=e.getLine(r);var s=i.exec(n);if(s&&(s[1]?t--:t++,!t))break}if(r>l)return new d(l,g,r,n.length)}}.call(c.prototype)}),ace.define("ace/mode/sh",["require","exports","module","ace/lib/oop","ace/mode/text","ace/mode/sh_highlight_rules","ace/range","ace/mode/folding/cstyle","ace/mode/behaviour/cstyle"],function(a,u,b){"use strict";var v=a("../lib/oop"),d=a("./text").Mode,p=a("./sh_highlight_rules").ShHighlightRules,c=a("../range").Range,e=a("./folding/cstyle").FoldMode,n=a("./behaviour/cstyle").CstyleBehaviour,r=function(){this.HighlightRules=p,this.foldingRules=new e,this.$behaviour=new n};v.inherits(r,d),function(){this.lineCommentStart="#",this.getNextLineIndent=function(o,l,i){var t=this.$getIndent(l),h=this.getTokenizer().getLineTokens(l,o).tokens;return h.length&&"comment"==h[h.length-1].type||"start"==o&&l.match(/^.*[\{\(\[:]\s*$/)&&(t+=i),t};var g={pass:1,return:1,raise:1,break:1,continue:1};this.checkOutdent=function(o,l,i){if("\r\n"!==i&&"\r"!==i&&"\n"!==i)return!1;var t=this.getTokenizer().getLineTokens(l.trim(),o).tokens;if(!t)return!1;do{var s=t.pop()}while(s&&("comment"==s.type||"text"==s.type&&s.value.match(/^\s+$/)));return!!s&&"keyword"==s.type&&g[s.value]},this.autoOutdent=function(o,l,i){var t=this.$getIndent(l.getLine(i+=1)),s=l.getTabString();t.slice(-s.length)==s&&l.remove(new c(i,t.length-s.length,i,t.length))},this.$id="ace/mode/sh",this.snippetFileId="ace/snippets/sh"}.call(r.prototype),u.Mode=r}),ace.define("ace/mode/dockerfile_highlight_rules",["require","exports","module","ace/lib/oop","ace/mode/sh_highlight_rules"],function(a,u,b){"use strict";var v=a("../lib/oop"),d=a("./sh_highlight_rules").ShHighlightRules,p=function(){d.call(this);for(var c=this.$rules.start,e=0;e<c.length;e++)if("variable.language"==c[e].token){c.splice(e,0,{token:"constant.language",regex:"(?:^(?:FROM|MAINTAINER|RUN|CMD|EXPOSE|ENV|ADD|ENTRYPOINT|VOLUME|USER|WORKDIR|ONBUILD|COPY|LABEL)\\b)",caseInsensitive:!0});break}};v.inherits(p,d),u.DockerfileHighlightRules=p}),ace.define("ace/mode/dockerfile",["require","exports","module","ace/lib/oop","ace/mode/sh","ace/mode/dockerfile_highlight_rules","ace/mode/folding/cstyle"],function(a,u,b){"use strict";var v=a("../lib/oop"),d=a("./sh").Mode,p=a("./dockerfile_highlight_rules").DockerfileHighlightRules,c=a("./folding/cstyle").FoldMode,e=function(){d.call(this),this.HighlightRules=p,this.foldingRules=new c};v.inherits(e,d),function(){this.$id="ace/mode/dockerfile"}.call(e.prototype),u.Mode=e}),ace.require(["ace/mode/dockerfile"],function(a){"object"==typeof module&&"object"==typeof exports&&module&&(module.exports=a)});