ace.define("ace/snippets",["require","exports","module","ace/lib/dom","ace/lib/oop","ace/lib/event_emitter","ace/lib/lang","ace/range","ace/range_list","ace/keyboard/hash_handler","ace/tokenizer","ace/clipboard","ace/editor"],function(T,m,j){"use strict";var F=T("./lib/dom"),H=T("./lib/oop"),U=T("./lib/event_emitter").EventEmitter,A=T("./lib/lang"),R=T("./range").Range,S=T("./range_list").RangeList,$=T("./keyboard/hash_handler").HashHandler,L=T("./tokenizer").Tokenizer,N=T("./clipboard"),C={CURRENT_WORD:function(e){return e.session.getTextRange(e.session.getWordRange())},SELECTION:function(e,t,r){var i=e.session.getTextRange();return r?i.replace(/\n\r?([ \t]*\S)/g,"\n"+r+"$1"):i},CURRENT_LINE:function(e){return e.session.getLine(e.getCursorPosition().row)},PREV_LINE:function(e){return e.session.getLine(e.getCursorPosition().row-1)},LINE_INDEX:function(e){return e.getCursorPosition().row},LINE_NUMBER:function(e){return e.getCursorPosition().row+1},SOFT_TABS:function(e){return e.session.getUseSoftTabs()?"YES":"NO"},TAB_SIZE:function(e){return e.session.getTabSize()},CLIPBOARD:function(e){return N.getText&&N.getText()},FILENAME:function(e){return/[^/\\]*$/.exec(this.FILEPATH(e))[0]},FILENAME_BASE:function(e){return/[^/\\]*$/.exec(this.FILEPATH(e))[0].replace(/\.[^.]*$/,"")},DIRECTORY:function(e){return this.FILEPATH(e).replace(/[^/\\]*$/,"")},FILEPATH:function(e){return"/not implemented.txt"},WORKSPACE_NAME:function(){return"Unknown"},FULLNAME:function(){return"Unknown"},BLOCK_COMMENT_START:function(e){var t=e.session.$mode||{};return t.blockComment&&t.blockComment.start||""},BLOCK_COMMENT_END:function(e){var t=e.session.$mode||{};return t.blockComment&&t.blockComment.end||""},LINE_COMMENT:function(e){return(e.session.$mode||{}).lineCommentStart||""},CURRENT_YEAR:E.bind(null,{year:"numeric"}),CURRENT_YEAR_SHORT:E.bind(null,{year:"2-digit"}),CURRENT_MONTH:E.bind(null,{month:"numeric"}),CURRENT_MONTH_NAME:E.bind(null,{month:"long"}),CURRENT_MONTH_NAME_SHORT:E.bind(null,{month:"short"}),CURRENT_DATE:E.bind(null,{day:"2-digit"}),CURRENT_DAY_NAME:E.bind(null,{weekday:"long"}),CURRENT_DAY_NAME_SHORT:E.bind(null,{weekday:"short"}),CURRENT_HOUR:E.bind(null,{hour:"2-digit",hour12:!1}),CURRENT_MINUTE:E.bind(null,{minute:"2-digit"}),CURRENT_SECOND:E.bind(null,{second:"2-digit"})};function E(e){var t=(new Date).toLocaleString("en-us",e);return 1==t.length?"0"+t:t}C.SELECTED_TEXT=C.SELECTION;var w=function(){this.snippetMap={},this.snippetNameMap={}};(function(){H.implement(this,U),this.getTokenizer=function(){return w.$tokenizer||this.createTokenizer()},this.createTokenizer=function(){function e(i){return i=i.substr(1),/^\d+$/.test(i)?[{tabstopId:parseInt(i,10)}]:[{text:i}]}function t(i){return"(?:[^\\\\"+i+"]|\\\\.)"}var r={regex:"/("+t("/")+"+)/",onMatch:function(i,o,s){var n=s[0];return n.fmtString=!0,n.guard=i.slice(1,-1),n.flag="",""},next:"formatString"};return w.$tokenizer=new L({start:[{regex:/\\./,onMatch:function(i,o,s){var n=i[1];return("}"==n&&s.length||-1!="`$\\".indexOf(n))&&(i=n),[i]}},{regex:/}/,onMatch:function(i,o,s){return[s.length?s.shift():i]}},{regex:/\$(?:\d+|\w+)/,onMatch:e},{regex:/\$\{[\dA-Z_a-z]+/,onMatch:function(i,o,s){var n=e(i.substr(1));return s.unshift(n[0]),n},next:"snippetVar"},{regex:/\n/,token:"newline",merge:!1}],snippetVar:[{regex:"\\|"+t("\\|")+"*\\|",onMatch:function(i,o,s){var n=i.slice(1,-1).replace(/\\[,|\\]|,/g,function(f){return 2==f.length?f[1]:"\0"}).split("\0").map(function(f){return{value:f}});return s[0].choices=n,[n[0]]},next:"start"},r,{regex:"([^:}\\\\]|\\\\.)*:?",token:"",next:"start"}],formatString:[{regex:/:/,onMatch:function(i,o,s){return s.length&&s[0].expectElse?(s[0].expectElse=!1,s[0].ifEnd={elseEnd:s[0]},[s[0].ifEnd]):":"}},{regex:/\\./,onMatch:function(i,o,s){var n=i[1];return"}"==n&&s.length||-1!="`$\\".indexOf(n)?i=n:"n"==n?i="\n":"t"==n?i="\t":-1!="ulULE".indexOf(n)&&(i={changeCase:n,local:n>"a"}),[i]}},{regex:"/\\w*}",onMatch:function(i,o,s){var n=s.shift();return n&&(n.flag=i.slice(1,-1)),this.next=n&&n.tabstopId?"start":"",[n||i]},next:"start"},{regex:/\$(?:\d+|\w+)/,onMatch:function(i,o,s){return[{text:i.slice(1)}]}},{regex:/\${\w+/,onMatch:function(i,o,s){var n={text:i.slice(2)};return s.unshift(n),[n]},next:"formatStringVar"},{regex:/\n/,token:"newline",merge:!1},{regex:/}/,onMatch:function(i,o,s){var n=s.shift();return this.next=n&&n.tabstopId?"start":"",[n||i]},next:"start"}],formatStringVar:[{regex:/:\/\w+}/,onMatch:function(i,o,s){return s[0].formatFunction=i.slice(2,-1),[s.shift()]},next:"formatString"},r,{regex:/:[\?\-+]?/,onMatch:function(i,o,s){"+"==i[1]&&(s[0].ifEnd=s[0]),"?"==i[1]&&(s[0].expectElse=!0)},next:"formatString"},{regex:"([^:}\\\\]|\\\\.)*:?",token:"",next:"formatString"}]})},this.tokenizeTmSnippet=function(e,t){return this.getTokenizer().getLineTokens(e,t).tokens.map(function(r){return r.value||r})},this.getVariableValue=function(e,t,r){if(/^\d+$/.test(t))return(this.variables.__||{})[t]||"";if(/^[A-Z]\d+$/.test(t))return(this.variables[t[0]+"__"]||{})[t.substr(1)]||"";if(t=t.replace(/^TM_/,""),!this.variables.hasOwnProperty(t))return"";var i=this.variables[t];return"function"==typeof i&&(i=this.variables[t](e,t,r)),null==i?"":i},this.variables=C,this.tmStrFormat=function(e,t,r){if(!t.fmt)return e;var o=t.guard;o=new RegExp(o,(t.flag||"").replace(/[^gim]/g,""));var s="string"==typeof t.fmt?this.tokenizeTmSnippet(t.fmt,"formatString"):t.fmt,n=this,f=e.replace(o,function(){var a=n.variables.__;n.variables.__=[].slice.call(arguments);for(var h=n.resolveVariables(s,r),l="E",g=0;g<h.length;g++){var v=h[g];if("object"==typeof v)if(h[g]="",v.changeCase&&v.local){var b=h[g+1];b&&"string"==typeof b&&(h[g]="u"==v.changeCase?b[0].toUpperCase():b[0].toLowerCase(),h[g+1]=b.substr(1))}else v.changeCase&&(l=v.changeCase);else"U"==l?h[g]=v.toUpperCase():"L"==l&&(h[g]=v.toLowerCase())}return n.variables.__=a,h.join("")});return f},this.tmFormatFunction=function(e,t,r){return"upcase"==t.formatFunction?e.toUpperCase():"downcase"==t.formatFunction?e.toLowerCase():e},this.resolveVariables=function(e,t){for(var r=[],i="",o=!0,s=0;s<e.length;s++){var n=e[s];if("string"!=typeof n){if(n){if(o=!1,n.fmtString){var f=e.indexOf(n,s+1);-1==f&&(f=e.length),n.fmt=e.slice(s+1,f),s=f}if(n.text){var a=this.getVariableValue(t,n.text,i)+"";n.fmtString&&(a=this.tmStrFormat(a,n,t)),n.formatFunction&&(a=this.tmFormatFunction(a,n,t)),a&&!n.ifEnd?(r.push(a),h(n)):!a&&n.ifEnd&&h(n.ifEnd)}else n.elseEnd?h(n.elseEnd):(null!=n.tabstopId||null!=n.changeCase)&&r.push(n)}}else r.push(n),"\n"==n?(o=!0,i=""):o&&(i=/^\t*/.exec(n)[0],o=/\S/.test(n))}function h(l){var g=e.indexOf(l,s+1);-1!=g&&(s=g)}return r},this.insertSnippetForSelection=function(e,t){var r=e.getCursorPosition(),i=e.session.getLine(r.row),o=e.session.getTabString(),s=i.match(/^\s*/)[0];r.column<s.length&&(s=s.slice(0,r.column)),t=t.replace(/\r/g,"");var n=this.tokenizeTmSnippet(t);n=(n=this.resolveVariables(n,e)).map(function(d){return"\n"==d?d+s:"string"==typeof d?d.replace(/\t/g,o):d});var f=[];n.forEach(function(d,M){if("object"==typeof d){var y=d.tabstopId,_=f[y];if(_||((_=f[y]=[]).index=y,_.value="",_.parents={}),-1===_.indexOf(d)){d.choices&&!_.choices&&(_.choices=d.choices),_.push(d);var I=n.indexOf(d,M+1);if(-1!==I){var P=n.slice(M+1,I);P.some(function(G){return"object"==typeof G})&&!_.value?_.value=P:P.length&&(!_.value||"string"!=typeof _.value)&&(_.value=P.join(""))}}}}),f.forEach(function(d){d.length=0});var a={};function h(d){for(var M=[],y=0;y<d.length;y++){var _=d[y];if("object"==typeof _){if(a[_.tabstopId])continue;_=M[d.lastIndexOf(_,y-1)]||{tabstopId:_.tabstopId}}M[y]=_}return M}for(var l=0;l<n.length;l++){var g=n[l];if("object"==typeof g){var v=g.tabstopId,b=f[v],D=n.indexOf(g,l+1);if(a[v]){a[v]===g&&(delete a[v],Object.keys(a).forEach(function(d){b.parents[d]=!0}));continue}a[v]=g;var k=b.value;"string"!=typeof k?k=h(k):g.fmt&&(k=this.tmStrFormat(k,g,e)),n.splice.apply(n,[l+1,Math.max(0,D-l)].concat(k,g)),-1===b.indexOf(g)&&b.push(g)}}var V=0,O=0,z="";n.forEach(function(d){if("string"==typeof d){var M=d.split("\n");M.length>1?(O=M[M.length-1].length,V+=M.length-1):O+=d.length,z+=d}else d&&(d.start?d.end={row:V,column:O}:d.start={row:V,column:O})});var B=e.getSelectionRange(),K=e.session.replace(B,z);new c(e).addTabstops(f,B.start,K,e.inVirtualSelectionMode&&e.selection.index)},this.insertSnippet=function(e,t){var r=this;if(e.inVirtualSelectionMode)return r.insertSnippetForSelection(e,t);e.forEachSelection(function(){r.insertSnippetForSelection(e,t)},null,{keepOrder:!0}),e.tabstopManager&&e.tabstopManager.tabNext()},this.$getScope=function(e){var t=e.session.$mode.$id||"";if("html"===(t=t.split("/").pop())||"php"===t){"php"===t&&!e.session.$mode.inlinePhp&&(t="html");var r=e.getCursorPosition(),i=e.session.getState(r.row);"object"==typeof i&&(i=i[0]),i.substring&&("js-"==i.substring(0,3)?t="javascript":"css-"==i.substring(0,4)?t="css":"php-"==i.substring(0,4)&&(t="php"))}return t},this.getActiveScopes=function(e){var t=this.$getScope(e),r=[t],i=this.snippetMap;return i[t]&&i[t].includeScopes&&r.push.apply(r,i[t].includeScopes),r.push("_"),r},this.expandWithTab=function(e,t){var r=this,i=e.forEachSelection(function(){return r.expandSnippetForSelection(e,t)},null,{keepOrder:!0});return i&&e.tabstopManager&&e.tabstopManager.tabNext(),i},this.expandSnippetForSelection=function(e,t){var f,r=e.getCursorPosition(),i=e.session.getLine(r.row),o=i.substring(0,r.column),s=i.substr(r.column),n=this.snippetMap;return this.getActiveScopes(e).some(function(a){var h=n[a];return h&&(f=this.findMatchingSnippet(h,o,s)),!!f},this),!!f&&(t&&t.dryRun||(e.session.doc.removeInLine(r.row,r.column-f.replaceBefore.length,r.column+f.replaceAfter.length),this.variables.M__=f.matchBefore,this.variables.T__=f.matchAfter,this.insertSnippetForSelection(e,f.content),this.variables.M__=this.variables.T__=null),!0)},this.findMatchingSnippet=function(e,t,r){for(var i=e.length;i--;){var o=e[i];if((!o.startRe||o.startRe.test(t))&&(!o.endRe||o.endRe.test(r))&&(o.startRe||o.endRe))return o.matchBefore=o.startRe?o.startRe.exec(t):[""],o.matchAfter=o.endRe?o.endRe.exec(r):[""],o.replaceBefore=o.triggerRe?o.triggerRe.exec(t)[0]:"",o.replaceAfter=o.endTriggerRe?o.endTriggerRe.exec(r)[0]:"",o}},this.snippetMap={},this.snippetNameMap={},this.register=function(e,t){var r=this.snippetMap,i=this.snippetNameMap,o=this;function s(a){return a&&!/^\^?\(.*\)\$?$|^\\b$/.test(a)&&(a="(?:"+a+")"),a||""}function n(a,h,l){return a=s(a),h=s(h),l?(a=h+a)&&"$"!=a[a.length-1]&&(a+="$"):(a+=h)&&"^"!=a[0]&&(a="^"+a),new RegExp(a)}function f(a){a.scope||(a.scope=t||"_"),r[t=a.scope]||(r[t]=[],i[t]={});var h=i[t];if(a.name){var l=h[a.name];l&&o.unregister(l),h[a.name]=a}r[t].push(a),a.prefix&&(a.tabTrigger=a.prefix),!a.content&&a.body&&(a.content=Array.isArray(a.body)?a.body.join("\n"):a.body),a.tabTrigger&&!a.trigger&&(!a.guard&&/^\w/.test(a.tabTrigger)&&(a.guard="\\b"),a.trigger=A.escapeRegExp(a.tabTrigger)),(a.trigger||a.guard||a.endTrigger||a.endGuard)&&(a.startRe=n(a.trigger,a.guard,!0),a.triggerRe=new RegExp(a.trigger),a.endRe=n(a.endTrigger,a.endGuard,!0),a.endTriggerRe=new RegExp(a.endTrigger))}e||(e=[]),Array.isArray(e)?e.forEach(f):Object.keys(e).forEach(function(a){f(e[a])}),this._signal("registerSnippets",{scope:t})},this.unregister=function(e,t){var r=this.snippetMap,i=this.snippetNameMap;function o(s){var n=i[s.scope||t];if(n&&n[s.name]){delete n[s.name];var f=r[s.scope||t],a=f&&f.indexOf(s);a>=0&&f.splice(a,1)}}e.content?o(e):Array.isArray(e)&&e.forEach(o)},this.parseSnippetFile=function(e){e=e.replace(/\r/g,"");for(var o,t=[],r={},i=/^#.*|^({[\s\S]*})\s*$|^(\S+) (.*)$|^((?:\n*\t.*)+)/gm;o=i.exec(e);){if(o[1])try{r=JSON.parse(o[1]),t.push(r)}catch(a){}if(o[4])r.content=o[4].replace(/^\t/gm,""),t.push(r),r={};else{var s=o[2],n=o[3];if("regex"==s){var f=/\/((?:[^\/\\]|\\.)*)|$/g;r.guard=f.exec(n)[1],r.trigger=f.exec(n)[1],r.endTrigger=f.exec(n)[1],r.endGuard=f.exec(n)[1]}else"snippet"==s?(r.tabTrigger=n.match(/^\S*/)[0],r.name||(r.name=n)):s&&(r[s]=n)}}return t},this.getSnippetByName=function(e,t){var i,r=this.snippetNameMap;return this.getActiveScopes(t).some(function(o){var s=r[o];return s&&(i=s[e]),!!i},this),i}}).call(w.prototype);var c=function(e){if(e.tabstopManager)return e.tabstopManager;e.tabstopManager=this,this.$onChange=this.onChange.bind(this),this.$onChangeSelection=A.delayedCall(this.onChangeSelection.bind(this)).schedule,this.$onChangeSession=this.onChangeSession.bind(this),this.$onAfterExec=this.onAfterExec.bind(this),this.attach(e)};(function(){this.attach=function(e){this.index=0,this.ranges=[],this.tabstops=[],this.$openTabstops=null,this.selectedTabstop=null,this.editor=e,this.editor.on("change",this.$onChange),this.editor.on("changeSelection",this.$onChangeSelection),this.editor.on("changeSession",this.$onChangeSession),this.editor.commands.on("afterExec",this.$onAfterExec),this.editor.keyBinding.addKeyboardHandler(this.keyboardHandler)},this.detach=function(){this.tabstops.forEach(this.removeTabstopMarkers,this),this.ranges=null,this.tabstops=null,this.selectedTabstop=null,this.editor.removeListener("change",this.$onChange),this.editor.removeListener("changeSelection",this.$onChangeSelection),this.editor.removeListener("changeSession",this.$onChangeSession),this.editor.commands.removeListener("afterExec",this.$onAfterExec),this.editor.keyBinding.removeKeyboardHandler(this.keyboardHandler),this.editor.tabstopManager=null,this.editor=null},this.onChange=function(e){for(var t="r"==e.action[0],r=this.selectedTabstop||{},i=r.parents||{},o=(this.tabstops||[]).slice(),s=0;s<o.length;s++){var n=o[s];if(n.rangeList.$bias=n==r||i[n.index]?0:1,"remove"==e.action&&n!==r){var a=n.parents&&n.parents[r.index],h=n.rangeList.pointIndex(e.start,a);h=h<0?-h-1:h+1;for(var l=n.rangeList.pointIndex(e.end,a),g=n.rangeList.ranges.slice(h,l=l<0?-l-1:l-1),v=0;v<g.length;v++)this.removeRange(g[v])}n.rangeList.$onChange(e)}var b=this.editor.session;!this.$inChange&&t&&1==b.getLength()&&!b.getValue()&&this.detach()},this.updateLinkedFields=function(){var e=this.selectedTabstop;if(e&&e.hasLinkedRanges&&e.firstNonLinked){this.$inChange=!0;for(var t=this.editor.session,r=t.getTextRange(e.firstNonLinked),i=0;i<e.length;i++){var o=e[i];if(o.linked){var n=m.snippetManager.tmStrFormat(r,o.original,this.editor);t.replace(o,n)}}this.$inChange=!1}},this.onAfterExec=function(e){e.command&&!e.command.readOnly&&this.updateLinkedFields()},this.onChangeSelection=function(){if(this.editor){for(var e=this.editor.selection.lead,t=this.editor.selection.anchor,r=this.editor.selection.isEmpty(),i=0;i<this.ranges.length;i++)if(!this.ranges[i].linked){var o=this.ranges[i].contains(e.row,e.column),s=r||this.ranges[i].contains(t.row,t.column);if(o&&s)return}this.detach()}},this.onChangeSession=function(){this.detach()},this.tabNext=function(e){var t=this.tabstops.length,r=this.index+(e||1);(r=Math.min(Math.max(r,1),t))==t&&(r=0),this.selectTabstop(r),0===r&&this.detach()},this.selectTabstop=function(e){this.$openTabstops=null;var t=this.tabstops[this.index];if(t&&this.addTabstopMarkers(t),this.index=e,(t=this.tabstops[this.index])&&t.length){this.selectedTabstop=t;var r=t.firstNonLinked||t;if(t.choices&&(r.cursor=r.start),this.editor.inVirtualSelectionMode)this.editor.selection.fromOrientedRange(r);else{var i=this.editor.multiSelect;i.toSingleRange(r);for(var o=0;o<t.length;o++)t.hasLinkedRanges&&t[o].linked||i.addRange(t[o].clone(),!0)}this.editor.keyBinding.addKeyboardHandler(this.keyboardHandler),this.selectedTabstop&&this.selectedTabstop.choices&&this.editor.execCommand("startAutocomplete",{matches:this.selectedTabstop.choices})}},this.addTabstops=function(e,t,r){var i=this.useLink||!this.editor.getOption("enableMultiselect");if(this.$openTabstops||(this.$openTabstops=[]),!e[0]){var o=R.fromPoints(r,r);p(o.start,t),p(o.end,t),e[0]=[o],e[0].index=0}var n=[this.index+1,0],f=this.ranges;e.forEach(function(a,h){for(var l=this.$openTabstops[h]||a,g=0;g<a.length;g++){var v=a[g],b=R.fromPoints(v.start,v.end||v.start);u(b.start,t),u(b.end,t),b.original=v,b.tabstop=l,f.push(b),l!=a?l.unshift(b):l[g]=b,v.fmtString||l.firstNonLinked&&i?(b.linked=!0,l.hasLinkedRanges=!0):l.firstNonLinked||(l.firstNonLinked=b)}l.firstNonLinked||(l.hasLinkedRanges=!1),l===a&&(n.push(l),this.$openTabstops[h]=l),this.addTabstopMarkers(l),l.rangeList=l.rangeList||new S,l.rangeList.$bias=0,l.rangeList.addList(l)},this),n.length>2&&(this.tabstops.length&&n.push(n.splice(2,1)[0]),this.tabstops.splice.apply(this.tabstops,n))},this.addTabstopMarkers=function(e){var t=this.editor.session;e.forEach(function(r){r.markerId||(r.markerId=t.addMarker(r,"ace_snippet-marker","text"))})},this.removeTabstopMarkers=function(e){var t=this.editor.session;e.forEach(function(r){t.removeMarker(r.markerId),r.markerId=null})},this.removeRange=function(e){var t=e.tabstop.indexOf(e);-1!=t&&e.tabstop.splice(t,1),-1!=(t=this.ranges.indexOf(e))&&this.ranges.splice(t,1),-1!=(t=e.tabstop.rangeList.ranges.indexOf(e))&&e.tabstop.splice(t,1),this.editor.session.removeMarker(e.markerId),e.tabstop.length||(-1!=(t=this.tabstops.indexOf(e.tabstop))&&this.tabstops.splice(t,1),this.tabstops.length||this.detach())},this.keyboardHandler=new $,this.keyboardHandler.bindKeys({Tab:function(e){m.snippetManager&&m.snippetManager.expandWithTab(e)||(e.tabstopManager.tabNext(1),e.renderer.scrollCursorIntoView())},"Shift-Tab":function(e){e.tabstopManager.tabNext(-1),e.renderer.scrollCursorIntoView()},Esc:function(e){e.tabstopManager.detach()}})}).call(c.prototype);var u=function(e,t){0==e.row&&(e.column+=t.column),e.row+=t.row},p=function(e,t){e.row==t.row&&(e.column-=t.column),e.row-=t.row};F.importCssString(".ace_snippet-marker {    -moz-box-sizing: border-box;    box-sizing: border-box;    background: rgba(194, 193, 208, 0.09);    border: 1px dotted rgba(211, 208, 235, 0.62);    position: absolute;}","snippets.css",!1),m.snippetManager=new w;var x=T("./editor").Editor;(function(){this.insertSnippet=function(e,t){return m.snippetManager.insertSnippet(this,e,t)},this.expandSnippet=function(e){return m.snippetManager.expandWithTab(this,e)}}).call(x.prototype)}),ace.define("ace/ext/emmet",["require","exports","module","ace/keyboard/hash_handler","ace/editor","ace/snippets","ace/range","ace/config","resources","resources","tabStops","resources","utils","actions"],function(T,m,j){"use strict";var S,$,F=T("../keyboard/hash_handler").HashHandler,H=T("../editor").Editor,U=T("../snippets").snippetManager,A=T("../range").Range,R=T("../config");function L(){}L.prototype={setupContext:function(c){this.ace=c,this.indentation=c.session.getTabString(),S||(S=window.emmet),(S.resources||S.require("resources")).setVariable("indentation",this.indentation),this.$syntax=null,this.$syntax=this.getSyntax()},getSelectionRange:function(){var c=this.ace.getSelectionRange(),u=this.ace.session.doc;return{start:u.positionToIndex(c.start),end:u.positionToIndex(c.end)}},createSelection:function(c,u){var p=this.ace.session.doc;this.ace.selection.setRange({start:p.indexToPosition(c),end:p.indexToPosition(u)})},getCurrentLineRange:function(){var c=this.ace,u=c.getCursorPosition().row,p=c.session.getLine(u).length,x=c.session.doc.positionToIndex({row:u,column:0});return{start:x,end:x+p}},getCaretPos:function(){var c=this.ace.getCursorPosition();return this.ace.session.doc.positionToIndex(c)},setCaretPos:function(c){var u=this.ace.session.doc.indexToPosition(c);this.ace.selection.moveToPosition(u)},getCurrentLine:function(){var c=this.ace.getCursorPosition().row;return this.ace.session.getLine(c)},replaceContent:function(c,u,p,x){null==p&&(p=null==u?this.getContent().length:u),null==u&&(u=0);var e=this.ace,t=e.session.doc,r=A.fromPoints(t.indexToPosition(u),t.indexToPosition(p));e.session.remove(r),r.end=r.start,c=this.$updateTabstops(c),U.insertSnippet(e,c)},getContent:function(){return this.ace.getValue()},getSyntax:function(){if(this.$syntax)return this.$syntax;var c=this.ace.session.$modeId.split("/").pop();if("html"==c||"php"==c){var u=this.ace.getCursorPosition(),p=this.ace.session.getState(u.row);"string"!=typeof p&&(p=p[0]),p&&((p=p.split("-")).length>1?c=p[0]:"php"==c&&(c="html"))}return c},getProfileName:function(){var c=S.resources||S.require("resources");switch(this.getSyntax()){case"css":return"css";case"xml":case"xsl":return"xml";case"html":var u=c.getVariable("profile");return u||(u=-1!=this.ace.session.getLines(0,2).join("").search(/<!DOCTYPE[^>]+XHTML/i)?"xhtml":"html"),u;default:var p=this.ace.session.$mode;return p.emmetConfig&&p.emmetConfig.profile||"xhtml"}},prompt:function(c){return prompt(c)},getSelection:function(){return this.ace.session.getTextRange()},getFilePath:function(){return""},$updateTabstops:function(c){var p=0,x=null,e=S.tabStops||S.require("tabStops"),r=(S.resources||S.require("resources")).getVocabulary("user"),i={tabstop:function(s){var n=parseInt(s.group,10),f=0===n;f?n=++p:n+=1e3;var a=s.placeholder;a&&(a=e.processText(a,i));var h="${"+n+(a?":"+a:"")+"}";return f&&(x=[s.start,h]),h},escape:function(s){return"$"==s?"\\$":"\\"==s?"\\\\":s}};return c=e.processText(c,i),r.variables.insert_final_tabstop&&!/\$\{0\}$/.test(c)?c+="${0}":x&&(c=(S.utils?S.utils.common:S.require("utils")).replaceSubstring(c,"${0}",x[0],x[1])),c}};var N={expand_abbreviation:{mac:"ctrl+alt+e",win:"alt+e"},match_pair_outward:{mac:"ctrl+d",win:"ctrl+,"},match_pair_inward:{mac:"ctrl+j",win:"ctrl+shift+0"},matching_pair:{mac:"ctrl+alt+j",win:"alt+j"},next_edit_point:"alt+right",prev_edit_point:"alt+left",toggle_comment:{mac:"command+/",win:"ctrl+/"},split_join_tag:{mac:"shift+command+'",win:"shift+ctrl+`"},remove_tag:{mac:"command+'",win:"shift+ctrl+;"},evaluate_math_expression:{mac:"shift+command+y",win:"shift+ctrl+y"},increment_number_by_1:"ctrl+up",decrement_number_by_1:"ctrl+down",increment_number_by_01:"alt+up",decrement_number_by_01:"alt+down",increment_number_by_10:{mac:"alt+command+up",win:"shift+alt+up"},decrement_number_by_10:{mac:"alt+command+down",win:"shift+alt+down"},select_next_item:{mac:"shift+command+.",win:"shift+ctrl+."},select_previous_item:{mac:"shift+command+,",win:"shift+ctrl+,"},reflect_css_value:{mac:"shift+command+r",win:"shift+ctrl+r"},encode_decode_data_url:{mac:"shift+ctrl+d",win:"ctrl+'"},expand_abbreviation_with_tab:"Tab",wrap_with_abbreviation:{mac:"shift+ctrl+a",win:"shift+ctrl+a"}},C=new L;for(var E in m.commands=new F,m.runEmmetCommand=function c(u){if("expand_abbreviation_with_tab"==this.action){if(!u.selection.isEmpty())return!1;var p=u.selection.lead,x=u.session.getTokenAt(p.row,p.column);if(x&&/\btag\b/.test(x.type))return!1}try{C.setupContext(u);var e=S.actions||S.require("actions");if("wrap_with_abbreviation"==this.action)return setTimeout(function(){e.run("wrap_with_abbreviation",C)},0);var t=e.run(this.action,C)}catch(i){if(!S){var r=m.load(c.bind(this,u));return"expand_abbreviation_with_tab"!=this.action&&r}u._signal("changeStatus","string"==typeof i?i:i.message),R.warn(i),t=!1}return t},N)m.commands.addCommand({name:"emmet:"+E,action:E,bindKey:N[E],exec:m.runEmmetCommand,multiSelectAction:"forEach"});m.updateCommands=function(c,u){u?c.keyBinding.addKeyboardHandler(m.commands):c.keyBinding.removeKeyboardHandler(m.commands)},m.isSupportedMode=function(c){return!!c&&(!!c.emmetConfig||/css|less|scss|sass|stylus|html|php|twig|ejs|handlebars/.test(c.$id||c))},m.isAvailable=function(c,u){if(/(evaluate_math_expression|expand_abbreviation)$/.test(u))return!0;var p=c.session.$mode,x=m.isSupportedMode(p);if(x&&p.$modes)try{C.setupContext(c),/js|php/.test(C.getSyntax())&&(x=!1)}catch(e){}return x};var w=function(c,u){var p=u;if(p){var x=m.isSupportedMode(p.session.$mode);!1===c.enableEmmet&&(x=!1),x&&m.load(),m.updateCommands(p,x)}};m.load=function(c){return"string"!=typeof $?(R.warn("script for emmet-core is not loaded"),!1):(R.loadModule($,function(){$=null,c&&c()}),!0)},m.AceEmmetEditor=L,R.defineOptions(H.prototype,"editor",{enableEmmet:{set:function(c){this[c?"on":"removeListener"]("changeMode",w),w({enableEmmet:!!c},this)},value:!0}}),m.setCore=function(c){"string"==typeof c?$=c:S=c}}),ace.require(["ace/ext/emmet"],function(T){"object"==typeof module&&"object"==typeof exports&&module&&(module.exports=T)});