/*
 * Decompiled with CFR 0.152.
 */
package com.chutneytesting.tools;

import com.chutneytesting.tools.UncheckedException;
import java.util.function.Function;
import java.util.function.Predicate;

@FunctionalInterface
public interface ThrowingPredicate<T, E extends Exception> {
    public boolean test(T var1) throws E;

    public static <T, E extends Exception> Predicate<T> toUnchecked(ThrowingPredicate<T, E> throwingFunction) throws UncheckedException {
        return ThrowingPredicate.silence(throwingFunction, e -> {
            throw UncheckedException.throwUncheckedException(e);
        });
    }

    public static <T, E extends Exception> Predicate<T> silence(ThrowingPredicate<T, E> throwingFunction, Function<Exception, Boolean> exceptionHandler) {
        return t -> {
            try {
                return throwingFunction.test(t);
            }
            catch (Exception e) {
                return (Boolean)exceptionHandler.apply(e);
            }
        };
    }
}

