/*
 * Decompiled with CFR 0.152.
 */
package com.chutneytesting.tools.orient;

import java.util.Optional;

public final class ComposableIdUtils {
    public static String toFrontId(String id) {
        if (ComposableIdUtils.isComposableDomainId(Optional.ofNullable(id).orElse(""))) {
            return id.replace("#", "").replace(":", "-");
        }
        return id;
    }

    public static String fromFrontId(String id) {
        return ComposableIdUtils.fromFrontId(Optional.ofNullable(id));
    }

    public static String fromFrontId(Optional<String> id) {
        return id.map(s -> {
            if (ComposableIdUtils.isComposableFrontId(s)) {
                return "#" + s.replace("-", ":");
            }
            return s;
        }).orElse("");
    }

    public static boolean isComposableFrontId(String frontId) {
        return frontId.contains("-");
    }

    public static boolean isComposableDomainId(String testCaseId) {
        return testCaseId.contains("#") && testCaseId.contains(":");
    }
}

