/*
 * Decompiled with CFR 0.152.
 */
package com.chutneytesting.task.spi.time;

import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;

public enum DurationUnit {
    NANOS(TimeUnit.NANOSECONDS, 1.0E-5, "ns"),
    MICROS(TimeUnit.MICROSECONDS, 0.001, "\u00b5s", "\u03bcs"),
    MILLIS(TimeUnit.MILLISECONDS, 1.0, "ms"),
    SECONDS(TimeUnit.SECONDS, 1000.0, "s", "sec"),
    MINUTES(TimeUnit.MINUTES, 60000.0, "m", "min"),
    HOURS(TimeUnit.HOURS, 3600000.0, "h", "hour", "hours", "hour(s)"),
    DAYS(TimeUnit.DAYS, 8.64E7, "d", "day", "days", "day(s)");

    public final TimeUnit timeUnit;
    final double toMilliFactor;
    final Set<String> labels;
    final String mostRelevantLabel;

    private DurationUnit(TimeUnit timeUnit, double toMilliFactor, String ... labels) {
        this.timeUnit = timeUnit;
        this.toMilliFactor = toMilliFactor;
        this.labels = new HashSet<String>(Arrays.asList(labels));
        this.mostRelevantLabel = labels[labels.length - 1];
    }

    public static DurationUnit parse(String label) {
        String unitText = label.trim().toLowerCase();
        return Arrays.stream(DurationUnit.values()).filter(d -> d.labels.contains(unitText)).findFirst().orElseThrow(() -> new IllegalArgumentException("Unknown time unit " + label + "; expected values : " + DurationUnit.regex()));
    }

    public String toString() {
        return this.mostRelevantLabel;
    }

    public static String regex() {
        List allLabels = Arrays.stream(DurationUnit.values()).flatMap(durationUnit -> durationUnit.labels.stream()).collect(Collectors.toList());
        return "(" + String.join((CharSequence)"|", allLabels) + ")";
    }
}

