/*
 * Decompiled with CFR 0.152.
 */
package com.chutneytesting.task.sql.core;

import com.chutneytesting.task.sql.core.Cell;
import com.chutneytesting.task.sql.core.Column;
import com.chutneytesting.task.sql.core.NonOptimizedQueryException;
import com.chutneytesting.task.sql.core.Records;
import com.chutneytesting.task.sql.core.Row;
import com.chutneytesting.tools.ChutneyMemoryInfo;
import com.chutneytesting.tools.NotEnoughMemoryException;
import com.zaxxer.hikari.HikariDataSource;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.Duration;
import java.time.Period;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.apache.commons.lang3.ClassUtils;

public class SqlClient {
    private final HikariDataSource dataSource;
    private final int maxFetchSize;

    public SqlClient(HikariDataSource dataSource, int maxFetchSize) {
        this.dataSource = dataSource;
        this.maxFetchSize = maxFetchSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Records execute(String query) throws SQLException {
        Records records;
        Connection connection = null;
        try {
            connection = this.dataSource.getConnection();
            try (Statement statement = connection.createStatement();){
                statement.setFetchSize(this.maxFetchSize);
                statement.execute(query);
                records = StatementConverter.createRecords(statement);
            }
        }
        finally {
            this.silentClose(connection);
        }
        return records;
    }

    public void closeDatasource() {
        this.dataSource.close();
    }

    public Records emptyRecords() {
        return new Records(0, Collections.emptyList(), Collections.emptyList());
    }

    private void silentClose(Connection connection) {
        if (connection != null) {
            try {
                connection.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private static class StatementConverter {
        private StatementConverter() {
        }

        private static Records createRecords(Statement statement) throws SQLException {
            int affectedRows = statement.getUpdateCount();
            List<Column> columns = Collections.emptyList();
            List<Row> rows = Collections.emptyList();
            if (StatementConverter.isSelectQuery(affectedRows)) {
                try (ResultSet rs = statement.getResultSet();){
                    ResultSetMetaData md = rs.getMetaData();
                    columns = StatementConverter.createHeaders(md, md.getColumnCount());
                    rows = StatementConverter.createRows(rs, columns, md.getColumnCount());
                }
            }
            return new Records(affectedRows, columns, rows);
        }

        private static boolean isSelectQuery(int affectedRows) {
            return affectedRows == -1;
        }

        private static List<Column> createHeaders(ResultSetMetaData md, int columnCount) throws SQLException {
            ArrayList<Column> headers = new ArrayList<Column>(columnCount);
            int j = 0;
            for (int i = 1; i <= columnCount; ++i) {
                headers.add(new Column(md.getColumnLabel(i), j++));
            }
            return headers;
        }

        private static List<Row> createRows(ResultSet rs, List<Column> columns, int columnCount) throws SQLException {
            ArrayList<Row> rows = new ArrayList<Row>();
            int j = 0;
            while (rs.next()) {
                if (j++ > 100000) {
                    throw new NonOptimizedQueryException();
                }
                if (!ChutneyMemoryInfo.hasEnoughAvailableMemory()) {
                    throw new NotEnoughMemoryException(ChutneyMemoryInfo.usedMemory(), ChutneyMemoryInfo.maxMemory(), "Query fetched " + rows.size() + " rows");
                }
                ArrayList<Cell> cells = new ArrayList<Cell>(columnCount);
                int columnIndex = 0;
                for (int i = 1; i <= columnCount; ++i) {
                    cells.add(new Cell(columns.get(columnIndex++), StatementConverter.boxed(rs, i)));
                }
                rows.add(new Row(cells));
            }
            return rows;
        }

        private static Object boxed(ResultSet rs, int i) throws SQLException {
            Class type;
            Object o = rs.getObject(i);
            Class clazz = type = o == null ? Object.class : o.getClass();
            if (ClassUtils.isPrimitiveOrWrapper(type) || StatementConverter.isJDBCNumericType(type) || StatementConverter.isJDBCDateType(type)) {
                return o;
            }
            return Optional.ofNullable(rs.getString(i)).orElse("null");
        }

        private static boolean isJDBCNumericType(Class<?> type) {
            return type.equals(BigDecimal.class) || type.equals(Byte.class) || type.equals(Short.class) || type.equals(Integer.class) || type.equals(Float.class) || type.equals(Double.class);
        }

        private static boolean isJDBCDateType(Class<?> type) {
            return type.equals(Date.class) || type.equals(Time.class) || type.equals(Timestamp.class) || type.equals(Period.class) || type.equals(Duration.class);
        }
    }
}

