/*
 * Decompiled with CFR 0.152.
 */
package com.chutneytesting.task.selenium;

import com.chutneytesting.task.selenium.SeleniumFindBehavior;
import com.chutneytesting.task.selenium.SeleniumTask;
import com.chutneytesting.task.spi.TaskExecutionResult;
import com.chutneytesting.task.spi.injectable.Input;
import com.chutneytesting.task.spi.injectable.Logger;
import java.util.Optional;
import org.openqa.selenium.JavascriptExecutor;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;

public class SeleniumGetTextTask
extends SeleniumTask
implements SeleniumFindBehavior {
    private static final String SELENIUM_OUTPUTS_KEY = "outputGetText";
    private final String selector;
    private final String by;
    private final Integer wait;

    public SeleniumGetTextTask(Logger logger, @Input(value="web-driver") WebDriver webDriver, @Input(value="selector") String selector, @Input(value="by") String by, @Input(value="wait") Integer wait) {
        super(logger, webDriver);
        this.selector = selector;
        this.by = by;
        this.wait = wait;
    }

    @Override
    public TaskExecutionResult executeSeleniumTask() {
        Optional webElement = this.findElement(this.logger, this.webDriver, this.selector, this.by, this.wait);
        if (webElement.isPresent()) {
            this.logger.info("Get text from element : " + webElement.get());
            ((JavascriptExecutor)this.webDriver).executeScript("arguments[0].style.background='yellow'", new Object[]{webElement.get()});
            if (!((WebElement)webElement.get()).getText().isEmpty()) {
                return TaskExecutionResult.ok((String)SELENIUM_OUTPUTS_KEY, (Object)((WebElement)webElement.get()).getText());
            }
            return TaskExecutionResult.ok((String)SELENIUM_OUTPUTS_KEY, (Object)((WebElement)webElement.get()).getAttribute("value"));
        }
        this.takeScreenShot();
        this.logger.error("Cannot retrieve element to get text from.");
        return TaskExecutionResult.ko();
    }
}

