/*
 * Decompiled with CFR 0.152.
 */
package com.chutneytesting.task.http.domain;

import com.chutneytesting.task.common.SecurityUtils;
import com.chutneytesting.task.http.domain.HttpClient;
import com.chutneytesting.task.spi.injectable.Logger;
import com.chutneytesting.task.spi.injectable.Target;
import java.net.MalformedURLException;
import java.net.ProxySelector;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.security.GeneralSecurityException;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Stream;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import org.apache.http.HttpHost;
import org.apache.http.conn.routing.HttpRoutePlanner;
import org.apache.http.conn.socket.LayeredConnectionSocketFactory;
import org.apache.http.conn.ssl.NoopHostnameVerifier;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.DefaultProxyRoutePlanner;
import org.apache.http.impl.conn.SystemDefaultRoutePlanner;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.http.client.ClientHttpResponse;
import org.springframework.http.client.HttpComponentsClientHttpRequestFactory;
import org.springframework.http.client.support.BasicAuthenticationInterceptor;
import org.springframework.web.client.DefaultResponseErrorHandler;
import org.springframework.web.client.ResponseErrorHandler;
import org.springframework.web.client.RestTemplate;

public class HttpClientFactory {
    private static final String PROXY_PROPERTY = "proxy";

    public HttpClient create(Logger logger, Target target, Class<String> responseType, int timeout) {
        RestTemplate restTemplate = HttpClientFactory.buildRestTemplate(logger, target, timeout);
        return (httpMethod, resource, input) -> restTemplate.exchange(target.uri().toString() + resource, httpMethod, input, responseType, new Object[0]);
    }

    private static RestTemplate buildRestTemplate(Logger logger, Target target, int timeout) {
        SSLContext sslContext;
        try {
            sslContext = SecurityUtils.buildSslContext(target).build();
        }
        catch (GeneralSecurityException e) {
            throw new IllegalArgumentException(e.getMessage(), e);
        }
        SSLConnectionSocketFactory socketFactory = new SSLConnectionSocketFactory(sslContext, (HostnameVerifier)NoopHostnameVerifier.INSTANCE);
        HttpClientBuilder httpClient = HttpClients.custom().setSSLSocketFactory((LayeredConnectionSocketFactory)socketFactory);
        Optional<HttpRoutePlanner> httpRoutePlanner = HttpClientFactory.getProxyConfiguration(logger, target);
        httpRoutePlanner.ifPresent(arg_0 -> ((HttpClientBuilder)httpClient).setRoutePlanner(arg_0));
        HttpComponentsClientHttpRequestFactory requestFactory = new HttpComponentsClientHttpRequestFactory((org.apache.http.client.HttpClient)httpClient.build());
        requestFactory.setReadTimeout(timeout);
        requestFactory.setConnectTimeout(timeout);
        RestTemplate restTemplate = new RestTemplate((ClientHttpRequestFactory)requestFactory);
        HttpClientFactory.configureBasicAuth(target, restTemplate);
        HttpClientFactory.removeErrorHandler(restTemplate);
        return restTemplate;
    }

    private static Optional<HttpRoutePlanner> getProxyConfiguration(Logger logger, Target target) {
        if (HttpClientFactory.isTargetProxySet(target)) {
            try {
                String proxy = (String)target.property(PROXY_PROPERTY).orElseThrow();
                URL url = new URL(proxy);
                String host = url.getHost();
                String scheme = url.getProtocol();
                int port = Optional.ofNullable(url.getPort()).orElse(3128);
                HttpHost httpProxy = new HttpHost(host, port, scheme);
                logger.info("Proxy used: [" + httpProxy + "]");
                return Optional.of(new DefaultProxyRoutePlanner(httpProxy));
            }
            catch (MalformedURLException e) {
                logger.error("Malformed proxy url [" + (String)target.property(PROXY_PROPERTY).get() + "]" + e.getMessage());
                return Optional.empty();
            }
        }
        if (HttpClientFactory.isSystemProxySet().booleanValue()) {
            return Optional.of(new SystemDefaultRoutePlanner(ProxySelector.getDefault()));
        }
        return Optional.empty();
    }

    private static boolean isTargetProxySet(Target target) {
        return target.property(PROXY_PROPERTY).isPresent();
    }

    private static void removeErrorHandler(RestTemplate restTemplate) {
        restTemplate.setErrorHandler((ResponseErrorHandler)new NoOpResponseErrorHandler());
    }

    private static void configureBasicAuth(Target target, RestTemplate restTemplate) {
        if (target.user().isPresent()) {
            String user = (String)target.user().get();
            String password = target.userPassword().orElse("");
            restTemplate.getInterceptors().add(new BasicAuthenticationInterceptor(user, password, StandardCharsets.UTF_8));
        }
    }

    private static Boolean isSystemProxySet() {
        return Stream.of("http.proxyHost", "https.proxyHost").map(System::getProperty).anyMatch(Objects::nonNull);
    }

    private static class NoOpResponseErrorHandler
    extends DefaultResponseErrorHandler {
        private NoOpResponseErrorHandler() {
        }

        public void handleError(ClientHttpResponse response) {
        }
    }
}

