/*
 * Decompiled with CFR 0.152.
 */
package com.chutneytesting.task.assertion;

import com.chutneytesting.task.assertion.placeholder.PlaceholderAsserter;
import com.chutneytesting.task.assertion.placeholder.PlaceholderAsserterUtils;
import com.chutneytesting.task.spi.Task;
import com.chutneytesting.task.spi.TaskExecutionResult;
import com.chutneytesting.task.spi.injectable.Input;
import com.chutneytesting.task.spi.injectable.Logger;
import com.chutneytesting.task.spi.validation.TaskValidatorsUtils;
import com.chutneytesting.task.spi.validation.Validator;
import com.jayway.jsonpath.Configuration;
import com.jayway.jsonpath.DocumentContext;
import com.jayway.jsonpath.InvalidJsonException;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.Option;
import com.jayway.jsonpath.Predicate;
import com.jayway.jsonpath.ReadContext;
import java.math.BigDecimal;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class JsonAssertTask
implements Task {
    private final Logger logger;
    private final String document;
    private final Map<String, Object> mapExpectedResults;

    public JsonAssertTask(Logger logger, @Input(value="document") String document, @Input(value="expected") Map<String, Object> mapExpectedResults) {
        this.logger = logger;
        this.document = document;
        this.mapExpectedResults = mapExpectedResults;
    }

    public List<String> validateInputs() {
        return Validator.getErrorsFrom((Validator[])new Validator[]{TaskValidatorsUtils.notBlankStringValidation((String)this.document, (String)"document"), TaskValidatorsUtils.notEmptyMapValidation(this.mapExpectedResults, (String)"expected")});
    }

    public TaskExecutionResult execute() {
        try {
            DocumentContext json = JsonPath.parse((String)this.document, (Configuration)Configuration.defaultConfiguration().addOptions(new Option[]{Option.SUPPRESS_EXCEPTIONS}));
            boolean matchesOk = this.mapExpectedResults.entrySet().stream().allMatch(arg_0 -> this.lambda$execute$0((ReadContext)json, arg_0));
            if (!matchesOk) {
                return TaskExecutionResult.ko();
            }
            return TaskExecutionResult.ok();
        }
        catch (InvalidJsonException e) {
            this.logger.error("JSON parsing failed::: " + e.getMessage() + "\n" + e.getJson());
            return TaskExecutionResult.ko();
        }
    }

    private /* synthetic */ boolean lambda$execute$0(ReadContext json, Map.Entry entry) {
        boolean result;
        String path = (String)entry.getKey();
        Object expected = entry.getValue();
        Object actualValue = json.read(path, new Predicate[0]);
        Optional<PlaceholderAsserter> asserts = PlaceholderAsserterUtils.getAsserterMatching(expected);
        if (asserts.isPresent()) {
            result = asserts.get().assertValue(this.logger, actualValue, expected);
        } else if (actualValue == null) {
            this.logger.error("Path [" + path + "] not found");
            result = false;
        } else if (expected instanceof Number || actualValue instanceof Number) {
            result = new BigDecimal(expected.toString()).compareTo(new BigDecimal(actualValue.toString())) == 0;
        } else {
            result = expected.equals(actualValue);
            if (!result && (result = expected.toString().equals(actualValue.toString()))) {
                this.logger.info("Comparing object is false, but comparing toString() of this object is true");
            }
        }
        if (!result) {
            this.logger.error("On path [" + path + "], found [" + actualValue + "], expected was [" + expected + "]");
        }
        return result;
    }
}

