/*
 * Decompiled with CFR 0.152.
 */
package com.chutneytesting.task.assertion;

import com.chutneytesting.task.spi.Task;
import com.chutneytesting.task.spi.TaskExecutionResult;
import com.chutneytesting.task.spi.injectable.Input;
import com.chutneytesting.task.spi.injectable.Logger;
import com.chutneytesting.task.spi.validation.TaskValidatorsUtils;
import com.chutneytesting.task.spi.validation.Validator;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class AssertTask
implements Task {
    private final Logger logger;
    private final List<Map<String, Boolean>> asserts;

    public AssertTask(Logger logger, @Input(value="asserts") List<Map<String, Boolean>> asserts) {
        this.logger = logger;
        this.asserts = Optional.ofNullable(asserts).orElse(Collections.emptyList());
    }

    public List<String> validateInputs() {
        return Validator.getErrorsFrom((Validator[])new Validator[]{TaskValidatorsUtils.notEmptyListValidation(this.asserts, (String)"asserts")});
    }

    public TaskExecutionResult execute() {
        boolean result = this.asserts.stream().allMatch(l -> l.entrySet().stream().map(e -> {
            if ("assert-true".equals(e.getKey())) {
                if (((Boolean)e.getValue()).booleanValue()) {
                    this.logger.info("assert ok");
                    return true;
                }
                return false;
            }
            this.logger.error("Unknown assert type [" + (String)e.getKey() + "]");
            return Boolean.FALSE;
        }).allMatch(r -> r));
        return result ? TaskExecutionResult.ok() : TaskExecutionResult.ko();
    }
}

