/*
 * Decompiled with CFR 0.152.
 */
package com.chutneytesting.task.selenium;

import com.chutneytesting.task.selenium.SeleniumDriverInitTask;
import com.chutneytesting.task.spi.FinallyAction;
import com.chutneytesting.task.spi.Task;
import com.chutneytesting.task.spi.TaskExecutionResult;
import com.chutneytesting.task.spi.injectable.FinallyActionRegistry;
import com.chutneytesting.task.spi.injectable.Input;
import com.chutneytesting.task.spi.injectable.Logger;
import java.net.MalformedURLException;
import java.net.URL;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.Optional;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.chrome.ChromeOptions;
import org.openqa.selenium.firefox.FirefoxDriverLogLevel;
import org.openqa.selenium.firefox.FirefoxOptions;
import org.openqa.selenium.remote.RemoteWebDriver;

public class SeleniumRemoteDriverInitTask
implements Task {
    private final FinallyActionRegistry finallyActionRegistry;
    private final Logger logger;
    private final String hubUrl;
    private final String browser;

    public SeleniumRemoteDriverInitTask(Logger logger, FinallyActionRegistry finallyActionRegistry, @Input(value="hub") String hubUrl, @Input(value="browser") String browser) {
        this.finallyActionRegistry = finallyActionRegistry;
        this.logger = logger;
        this.hubUrl = hubUrl;
        this.browser = browser;
    }

    public TaskExecutionResult execute() {
        WebDriver webDriver;
        switch (Optional.ofNullable(this.browser).orElse("")) {
            case "chrome": {
                webDriver = this.createChromeRemoteWebDriver();
                break;
            }
            case "internet explorer": {
                webDriver = this.createInternetExplorerRemoteWebDriver();
                break;
            }
            default: {
                webDriver = this.createFirefoxRemoteWebDriver();
            }
        }
        if (webDriver != null) {
            this.configureWebDriver(webDriver);
            this.logger.info("RemoteWebDriver created : " + webDriver);
            this.createQuitFinallyAction(webDriver);
            return TaskExecutionResult.ok(SeleniumDriverInitTask.toOutputs(webDriver));
        }
        this.logger.error("RemoteWebDriver creation failed.");
        return TaskExecutionResult.ko();
    }

    private void createQuitFinallyAction(WebDriver webDriver) {
        this.finallyActionRegistry.registerFinallyAction(FinallyAction.Builder.forAction((String)"selenium-quit", SeleniumRemoteDriverInitTask.class).withInput("web-driver", (Object)webDriver).build());
        this.logger.info("Quit finally action registered");
    }

    WebDriver createChromeRemoteWebDriver() {
        ChromeOptions chromeOptions = new ChromeOptions();
        chromeOptions.addArguments(new String[]{"start-maximized"});
        chromeOptions.setCapability("goog:chromeOptions", (Object)chromeOptions);
        return this.createRemoteWebDriver((Capabilities)chromeOptions);
    }

    WebDriver createInternetExplorerRemoteWebDriver() {
        return this.createRemoteWebDriver((Capabilities)SeleniumDriverInitTask.setIeOptions());
    }

    WebDriver createFirefoxRemoteWebDriver() {
        FirefoxOptions firefoxOptions = new FirefoxOptions();
        firefoxOptions.setHeadless(false);
        firefoxOptions.setLogLevel(FirefoxDriverLogLevel.FATAL);
        return this.createRemoteWebDriver((Capabilities)firefoxOptions);
    }

    private WebDriver createRemoteWebDriver(Capabilities capabilities) {
        try {
            return new RemoteWebDriver(new URL(this.hubUrl), capabilities);
        }
        catch (MalformedURLException e) {
            throw new IllegalStateException(e.getMessage());
        }
    }

    void configureWebDriver(WebDriver webDriver) {
        try {
            webDriver.manage().timeouts().implicitlyWait(Duration.of(0L, ChronoUnit.SECONDS));
        }
        catch (Exception e) {
            this.logger.error("Default configuration of the remote webDriver failed");
        }
    }
}

