/*
 * Decompiled with CFR 0.152.
 */
package com.chutneytesting.task.http.domain;

import com.chutneytesting.task.common.SecurityUtils;
import com.chutneytesting.task.http.domain.HttpClient;
import com.chutneytesting.task.spi.injectable.Target;
import java.net.ProxySelector;
import java.nio.charset.StandardCharsets;
import java.security.GeneralSecurityException;
import java.util.Objects;
import java.util.stream.Stream;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import org.apache.http.conn.routing.HttpRoutePlanner;
import org.apache.http.conn.socket.LayeredConnectionSocketFactory;
import org.apache.http.conn.ssl.NoopHostnameVerifier;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.SystemDefaultRoutePlanner;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.http.client.ClientHttpResponse;
import org.springframework.http.client.HttpComponentsClientHttpRequestFactory;
import org.springframework.http.client.support.BasicAuthenticationInterceptor;
import org.springframework.web.client.DefaultResponseErrorHandler;
import org.springframework.web.client.ResponseErrorHandler;
import org.springframework.web.client.RestTemplate;

public class HttpClientFactory {
    public HttpClient create(Target target, ParameterizedTypeReference<String> responseType, int timeout) {
        RestTemplate restTemplate = HttpClientFactory.buildRestTemplate(target, timeout);
        return (httpMethod, resource, input) -> restTemplate.exchange(target.uri().toString() + resource, httpMethod, input, responseType, new Object[0]);
    }

    public HttpClient create(Target target, Class<String> responseType, int timeout) {
        RestTemplate restTemplate = HttpClientFactory.buildRestTemplate(target, timeout);
        return (httpMethod, resource, input) -> restTemplate.exchange(target.uri().toString() + resource, httpMethod, input, responseType, new Object[0]);
    }

    private static RestTemplate buildRestTemplate(Target target, int timeout) {
        SSLContext sslContext;
        try {
            sslContext = SecurityUtils.buildSslContext(target).build();
        }
        catch (GeneralSecurityException e) {
            throw new IllegalArgumentException(e.getMessage(), e);
        }
        SSLConnectionSocketFactory socketFactory = new SSLConnectionSocketFactory(sslContext, (HostnameVerifier)NoopHostnameVerifier.INSTANCE);
        HttpClientBuilder httpClient = HttpClients.custom().setSSLSocketFactory((LayeredConnectionSocketFactory)socketFactory);
        if (HttpClientFactory.isSystemProxySet().booleanValue()) {
            httpClient.setRoutePlanner((HttpRoutePlanner)new SystemDefaultRoutePlanner(ProxySelector.getDefault()));
        }
        HttpComponentsClientHttpRequestFactory requestFactory = new HttpComponentsClientHttpRequestFactory((org.apache.http.client.HttpClient)httpClient.build());
        requestFactory.setReadTimeout(timeout);
        requestFactory.setConnectTimeout(timeout);
        RestTemplate restTemplate = new RestTemplate((ClientHttpRequestFactory)requestFactory);
        HttpClientFactory.configureBasicAuth(target, restTemplate);
        HttpClientFactory.removeErrorHandler(restTemplate);
        return restTemplate;
    }

    private static void removeErrorHandler(RestTemplate restTemplate) {
        restTemplate.setErrorHandler((ResponseErrorHandler)new NoOpResponseErrorHandler());
    }

    private static void configureBasicAuth(Target target, RestTemplate restTemplate) {
        if (target.user().isPresent()) {
            String user = (String)target.user().get();
            String password = target.userPassword().orElse("");
            restTemplate.getInterceptors().add(new BasicAuthenticationInterceptor(user, password, StandardCharsets.UTF_8));
        }
    }

    private static Boolean isSystemProxySet() {
        return Stream.of("http.proxyHost", "https.proxyHost").map(System::getProperty).anyMatch(Objects::nonNull);
    }

    private static class NoOpResponseErrorHandler
    extends DefaultResponseErrorHandler {
        private NoOpResponseErrorHandler() {
        }

        public void handleError(ClientHttpResponse response) {
        }
    }
}

