/*
 * Decompiled with CFR 0.152.
 */
package com.chutneytesting.task.ssh.sshj;

import com.chutneytesting.task.spi.injectable.Logger;
import com.chutneytesting.task.ssh.Connection;
import com.chutneytesting.task.ssh.sshj.Command;
import com.chutneytesting.task.ssh.sshj.CommandResult;
import com.chutneytesting.task.ssh.sshj.SshClient;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.PublicKey;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;
import net.schmizz.sshj.SSHClient;
import net.schmizz.sshj.common.IOUtils;
import net.schmizz.sshj.common.LoggerFactory;
import net.schmizz.sshj.common.StreamCopier;
import net.schmizz.sshj.connection.channel.direct.Session;
import net.schmizz.sshj.transport.TransportException;
import net.schmizz.sshj.transport.verification.HostKeyVerifier;
import net.schmizz.sshj.userauth.UserAuthException;
import net.schmizz.sshj.userauth.keyprovider.KeyProvider;
import org.apache.commons.lang3.StringUtils;

public class SshJClient
implements SshClient {
    private final Connection connection;
    private final Logger logger;
    private final boolean shell;

    @Deprecated
    public SshJClient(Connection connection, Logger logger) {
        this(connection, false, logger);
    }

    public SshJClient(Connection connection, boolean shell, Logger logger) {
        this.connection = connection;
        this.logger = logger;
        this.shell = shell;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CommandResult execute(Command command) throws IOException {
        SSHClient sshClient = new SSHClient();
        this.connect(sshClient, this.connection);
        try {
            this.authenticate(sshClient, this.connection);
            CommandResult commandResult = this.executeCommand(sshClient, command);
            return commandResult;
        }
        finally {
            sshClient.disconnect();
        }
    }

    private void connect(SSHClient client, Connection connection) throws IOException {
        client.addHostKeyVerifier(new HostKeyVerifier(){

            public boolean verify(String hostname, int port, PublicKey key) {
                return true;
            }

            public List<String> findExistingAlgorithms(String hostname, int port) {
                return Collections.emptyList();
            }
        });
        client.connect(connection.serverHost, connection.serverPort);
    }

    private void authenticate(SSHClient client, Connection connection) throws IOException {
        if (StringUtils.isBlank((CharSequence)connection.privateKey)) {
            this.logger.info("Authentication via username/password as " + connection.username);
            this.loginWithPassword(client, connection.username, connection.password);
        } else {
            this.logger.info("Authentication via private key as " + connection.username);
            this.loginWithPrivateKey(client, connection.username, connection.privateKey, connection.passphrase);
        }
    }

    private void loginWithPassword(SSHClient client, String username, String password) throws UserAuthException, TransportException {
        client.authPassword(username, password);
    }

    private void loginWithPrivateKey(SSHClient client, String username, String privateKey, String passphrase) throws IOException {
        KeyProvider keyProvider = client.loadKeys(privateKey, passphrase);
        client.authPublickey(username, new KeyProvider[]{keyProvider});
    }

    private CommandResult executeCommand(SSHClient sshClient, Command command) throws IOException {
        try (Session session = sshClient.startSession();){
            if (this.shell) {
                CommandResult commandResult = this.shellCommand(command, session);
                return commandResult;
            }
            CommandResult commandResult = this.execCommand(command, session);
            return commandResult;
        }
    }

    private CommandResult shellCommand(Command command, Session session) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        ByteArrayOutputStream err = new ByteArrayOutputStream();
        session.allocateDefaultPTY();
        Session.Shell shell = session.startShell();
        new StreamCopier(shell.getInputStream(), (OutputStream)out, LoggerFactory.DEFAULT).bufSize(shell.getLocalMaxPacketSize()).spawn("out");
        new StreamCopier(shell.getErrorStream(), (OutputStream)err, LoggerFactory.DEFAULT).bufSize(shell.getLocalMaxPacketSize()).spawn("err");
        OutputStream shellOut = shell.getOutputStream();
        shellOut.write(command.command.getBytes());
        shellOut.flush();
        while (shell.getInputStream().available() > 0 && shell.getErrorStream().available() > 0) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        return new CommandResult(command, err.size() > 0 ? -1 : 0, out.toString(), err.toString());
    }

    private CommandResult execCommand(Command command, Session session) throws IOException {
        Session.Command sshJCommand = session.exec(command.command);
        sshJCommand.join(command.timeout.toMilliseconds(), TimeUnit.MILLISECONDS);
        try (InputStream is = sshJCommand.getInputStream();){
            CommandResult commandResult;
            block12: {
                InputStream es = sshJCommand.getErrorStream();
                try {
                    commandResult = new CommandResult(command, sshJCommand.getExitStatus(), this.readInputStream(is), this.readInputStream(es));
                    if (es == null) break block12;
                }
                catch (Throwable throwable) {
                    if (es != null) {
                        try {
                            es.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                es.close();
            }
            return commandResult;
        }
    }

    private String readInputStream(InputStream inputStream) throws IOException {
        return IOUtils.readFully((InputStream)inputStream).toString().replaceAll("\r", "");
    }
}

