/*
 * Decompiled with CFR 0.152.
 */
package com.chutneytesting.task.ssh.sshd;

import com.chutneytesting.task.ssh.sshd.SshServerMock;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.nio.charset.Charset;
import java.util.Optional;
import java.util.concurrent.Executors;
import org.apache.commons.io.IOUtils;
import org.apache.sshd.server.Environment;
import org.apache.sshd.server.ExitCallback;
import org.apache.sshd.server.channel.ChannelSession;
import org.apache.sshd.server.session.ServerSession;
import org.apache.sshd.server.session.ServerSessionAware;

public class Command
implements org.apache.sshd.server.command.Command,
ServerSessionAware,
Runnable {
    private final SshServerMock sshServerMock;
    private String command = null;
    private InputStream in;
    private OutputStream out;
    private OutputStream err;
    private ExitCallback callback;
    private ServerSession session;

    public Command(SshServerMock sshServerMock, String command) {
        this.sshServerMock = sshServerMock;
        this.command = command;
    }

    public Command(SshServerMock sshServerMock) {
        this.sshServerMock = sshServerMock;
    }

    public void setInputStream(InputStream in) {
        this.in = in;
    }

    public void setOutputStream(OutputStream out) {
        this.out = out;
    }

    public void setErrorStream(OutputStream err) {
        this.err = err;
    }

    public void setExitCallback(ExitCallback callback) {
        this.callback = callback;
    }

    public void start(ChannelSession channel, Environment env) throws IOException {
        Executors.newSingleThreadExecutor().submit(this);
    }

    public void destroy(ChannelSession channel) throws Exception {
    }

    public void setSession(ServerSession session) {
        this.session = session;
    }

    @Override
    public void run() {
        try {
            StringBuilder text = new StringBuilder();
            while (true) {
                if (this.command != null) {
                    text.append(this.command);
                    this.addCommandAndExit(text.toString());
                    return;
                }
                if (this.in.available() > 0) {
                    String t = IOUtils.toString((InputStream)this.in, (Charset)Charset.defaultCharset());
                    text.append(t);
                    continue;
                }
                if (text.toString().endsWith("exit")) {
                    this.addCommandAndExit(text.toString());
                    return;
                }
                Thread.sleep(1L);
            }
        }
        catch (Throwable t) {
            this.uncheckedWriteTo(this.err, t.getMessage().getBytes(), true);
            this.callback.onExit(-1, t.getMessage());
            return;
        }
    }

    private void addCommandAndExit(String command) {
        Optional<String> stubbedResult = this.sshServerMock.addCommand(command);
        stubbedResult.map(String::getBytes).ifPresent(b -> this.uncheckedWriteTo(this.out, (byte[])b, false));
        this.callback.onExit(0);
    }

    private void uncheckedWriteTo(OutputStream out, byte[] bytes, boolean flush) {
        try {
            out.write(bytes);
            if (flush) {
                out.flush();
            }
        }
        catch (IOException ioe) {
            throw new UncheckedIOException(ioe);
        }
    }
}

