/*
 * Decompiled with CFR 0.152.
 */
package com.chutneytesting.task.ssh;

import com.chutneytesting.task.spi.Task;
import com.chutneytesting.task.spi.TaskExecutionResult;
import com.chutneytesting.task.spi.injectable.Input;
import com.chutneytesting.task.spi.injectable.Logger;
import com.chutneytesting.task.spi.injectable.Target;
import com.chutneytesting.task.spi.validation.TaskValidatorsUtils;
import com.chutneytesting.task.spi.validation.Validator;
import com.chutneytesting.task.ssh.Connection;
import com.chutneytesting.task.ssh.sshj.CommandResult;
import com.chutneytesting.task.ssh.sshj.Commands;
import com.chutneytesting.task.ssh.sshj.SshJClient;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;

public class SshClientTask
implements Task {
    private final Target target;
    private final Logger logger;
    private final List<Object> commands;
    private final String channel;

    public SshClientTask(Target target, Logger logger, @Input(value="commands") List<Object> commands, @Input(value="channel") String channel) {
        this.target = target;
        this.logger = logger;
        this.commands = commands;
        this.channel = Optional.ofNullable(channel).orElse(CHANNEL.COMMAND.name());
    }

    public List<String> validateInputs() {
        Validator commandsValidator = TaskValidatorsUtils.notEmptyListValidation(this.commands, (String)"commands").validate(Commands::from, noException -> true, "Syntax is a List of String or a List of {command: \"xxx\", timeout:\"10 s\"} Json");
        return Validator.getErrorsFrom((Validator[])new Validator[]{TaskValidatorsUtils.targetValidation((Target)this.target), commandsValidator});
    }

    public TaskExecutionResult execute() {
        try {
            Connection connection = Connection.from(this.target);
            boolean isSshChannel = CHANNEL.SHELL.equals((Object)CHANNEL.from(this.channel));
            SshJClient sshClient = new SshJClient(connection, isSshChannel, this.logger);
            List<CommandResult> commandResults = Commands.from(this.commands).executeWith(sshClient);
            HashMap<String, List<CommandResult>> taskResult = new HashMap<String, List<CommandResult>>();
            taskResult.put("results", commandResults);
            return TaskExecutionResult.ok(taskResult);
        }
        catch (IOException e) {
            this.logger.error(e.getMessage());
            return TaskExecutionResult.ko();
        }
    }

    private static enum CHANNEL {
        COMMAND,
        SHELL;


        public static CHANNEL from(String channel) {
            for (CHANNEL value : CHANNEL.values()) {
                if (!value.name().equalsIgnoreCase(channel)) continue;
                return value;
            }
            return COMMAND;
        }
    }
}

