/*
 * Decompiled with CFR 0.152.
 */
package com.chutneytesting.task.ssh;

import com.chutneytesting.task.spi.injectable.SecurityInfo;
import com.chutneytesting.task.spi.injectable.Target;
import org.junit.platform.commons.util.StringUtils;

public class Connection {
    private static final String EMPTY = "";
    public final String serverHost;
    public final int serverPort;
    public final String username;
    public final String password;
    public final String privateKey;
    public final String passphrase;

    private Connection(String serverHost, int serverPort, String username, String password, String privateKey, String passphrase) {
        this.serverHost = serverHost;
        this.serverPort = serverPort;
        this.username = username;
        this.password = password;
        this.privateKey = privateKey;
        this.passphrase = passphrase;
    }

    public static Connection from(Target target) {
        Connection.guardClause(target);
        String host = target.host();
        int port = Connection.extractPort(target);
        String username = Connection.getUsername(target);
        String password = Connection.getPassword(target);
        String privateKey = Connection.getPrivateKey(target);
        String passphrase = Connection.getPassPhrase(target);
        return new Connection(host, port, username, password, privateKey, passphrase);
    }

    public boolean usePrivateKey() {
        return StringUtils.isNotBlank((String)this.privateKey);
    }

    private static void guardClause(Target target) {
        if (target.uri() == null) {
            throw new IllegalArgumentException("Target URL is undefined");
        }
        if (target.host() == null || target.host().isEmpty()) {
            throw new IllegalArgumentException("Target is badly defined");
        }
    }

    private static int extractPort(Target target) {
        int serverPort = target.port();
        return serverPort == -1 ? 22 : serverPort;
    }

    private static String getUsername(Target target) {
        if (target.properties().containsKey("username")) {
            return (String)target.properties().get("username");
        }
        if (target.security().credential().isPresent()) {
            return ((SecurityInfo.Credential)target.security().credential().get()).username();
        }
        return EMPTY;
    }

    private static String getPassword(Target target) {
        if (target.properties().containsKey("password")) {
            return (String)target.properties().get("password");
        }
        if (target.security().credential().isPresent()) {
            return ((SecurityInfo.Credential)target.security().credential().get()).password();
        }
        return EMPTY;
    }

    private static String getPrivateKey(Target target) {
        if (target.properties().containsKey("privateKey")) {
            return (String)target.properties().get("privateKey");
        }
        if (target.security().privateKey().isPresent()) {
            return (String)target.security().privateKey().get();
        }
        return EMPTY;
    }

    private static String getPassPhrase(Target target) {
        if (target.properties().containsKey("privateKeyPassphrase")) {
            return (String)target.properties().get("privateKeyPassphrase");
        }
        if (target.security().credential().isPresent()) {
            return ((SecurityInfo.Credential)target.security().credential().get()).password();
        }
        return EMPTY;
    }
}

