/*
 * Decompiled with CFR 0.152.
 */
package com.chutneytesting.task.radius;

import com.chutneytesting.task.radius.RadiusHelper;
import com.chutneytesting.task.spi.Task;
import com.chutneytesting.task.spi.TaskExecutionResult;
import com.chutneytesting.task.spi.injectable.Input;
import com.chutneytesting.task.spi.injectable.Logger;
import com.chutneytesting.task.spi.injectable.Target;
import com.chutneytesting.task.spi.validation.TaskValidatorsUtils;
import com.chutneytesting.task.spi.validation.Validator;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.tinyradius.packet.AccessRequest;
import org.tinyradius.packet.RadiusPacket;
import org.tinyradius.util.RadiusClient;
import org.tinyradius.util.RadiusException;

public class RadiusAuthenticateTask
implements Task {
    private final Logger logger;
    private final Target target;
    private final String protocol;
    private final String userName;
    private final String userPassword;
    private final Map<String, String> attributes;

    public RadiusAuthenticateTask(Logger logger, Target target, @Input(value="userName") String userName, @Input(value="userPassword") String userPassword, @Input(value="protocol") String protocol, @Input(value="attributes") Map<String, String> attributes) {
        this.logger = logger;
        this.target = target;
        this.userName = userName;
        this.userPassword = userPassword;
        this.protocol = RadiusHelper.getRadiusProtocol(protocol);
        this.attributes = Optional.ofNullable(attributes).orElse(Collections.emptyMap());
    }

    public List<String> validateInputs() {
        return Validator.getErrorsFrom((Validator[])new Validator[]{TaskValidatorsUtils.targetValidation((Target)this.target), RadiusHelper.radiusTargetPropertiesValidation(this.target), RadiusHelper.radiusTargetPortPropertiesValidation(this.target), TaskValidatorsUtils.notBlankStringValidation((String)this.userName, (String)"userName"), TaskValidatorsUtils.notBlankStringValidation((String)this.userPassword, (String)"userPassword")});
    }

    public TaskExecutionResult execute() {
        AccessRequest accessRequest = new AccessRequest(this.userName, this.userPassword);
        accessRequest.setAuthProtocol(this.protocol);
        this.attributes.forEach((arg_0, arg_1) -> ((AccessRequest)accessRequest).addAttribute(arg_0, arg_1));
        RadiusClient client = RadiusHelper.createRadiusClient(this.target);
        try {
            RadiusPacket response = client.authenticate(accessRequest);
            if (response == null) {
                this.logger.error("Authenticate failed. Response is null");
                return TaskExecutionResult.ko();
            }
            HashMap<String, RadiusPacket> outputs = new HashMap<String, RadiusPacket>();
            outputs.put("radiusResponse", response);
            this.logger.info("Access request for [" + this.userName + "] response type : " + response.getPacketTypeName());
            String ip = RadiusHelper.silentGetAttribute(response, "Framed-IP-Address");
            if (!ip.isBlank()) {
                this.logger.info("Response ip address " + ip);
            }
            return TaskExecutionResult.ok(outputs);
        }
        catch (IOException | RadiusException e) {
            this.logger.error(e);
            return TaskExecutionResult.ko();
        }
    }
}

