/*
 * Decompiled with CFR 0.152.
 */
package com.chutneytesting.task.micrometer;

import com.chutneytesting.task.micrometer.MicrometerTaskHelper;
import com.chutneytesting.task.spi.Task;
import com.chutneytesting.task.spi.TaskExecutionResult;
import com.chutneytesting.task.spi.injectable.Input;
import com.chutneytesting.task.spi.injectable.Logger;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Metrics;
import io.micrometer.core.instrument.Timer;
import java.util.Optional;

public class MicrometerTimerStartTask
implements Task {
    protected static final String OUTPUT_TIMER_SAMPLE = "micrometerTimerSample";
    private final Logger logger;
    private final MeterRegistry registry;

    public MicrometerTimerStartTask(Logger logger, @Input(value="registry") MeterRegistry registry) {
        this.logger = logger;
        this.registry = Optional.ofNullable(registry).orElse((MeterRegistry)Metrics.globalRegistry);
    }

    public TaskExecutionResult execute() {
        try {
            Timer.Sample sample = Timer.start((MeterRegistry)this.registry);
            this.logger.info("Timing sample started");
            return TaskExecutionResult.ok(MicrometerTaskHelper.toOutputs(OUTPUT_TIMER_SAMPLE, sample));
        }
        catch (Exception e) {
            this.logger.error((Throwable)e);
            return TaskExecutionResult.ko();
        }
    }
}

