/*
 * Decompiled with CFR 0.152.
 */
package com.chutneytesting.task.micrometer;

import com.chutneytesting.task.spi.injectable.Logger;
import com.chutneytesting.task.spi.time.Duration;
import com.chutneytesting.task.spi.validation.Validator;
import io.micrometer.core.instrument.Timer;
import java.time.temporal.ChronoUnit;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.stream.Stream;

final class MicrometerTaskHelper {
    MicrometerTaskHelper() {
    }

    static Validator<String> durationStringValidation(String timeout, String label) {
        return Validator.of((Object)timeout).validate(s -> s == null || Duration.parseToMs((String)s) >= Long.MIN_VALUE, noException -> true, label + " is not parsable");
    }

    static Validator<String> integerStringValidation(String toVerify, String inputLabel) {
        return Validator.of((Object)toVerify).validate(s -> s == null || Integer.parseInt(s) >= Integer.MIN_VALUE, noException -> true, inputLabel + " parsing");
    }

    static Validator<String> doubleStringValidation(String toVerify, String inputLabel) {
        return Validator.of((Object)toVerify).validate(s -> s == null || Double.parseDouble(s) >= Double.MIN_VALUE, noException -> true, inputLabel + " parsing");
    }

    static Integer parseIntOrNull(String str) {
        return MicrometerTaskHelper.parseMapOrNull(str, Integer::parseInt);
    }

    static Double parseDoubleOrNull(String str) {
        return MicrometerTaskHelper.parseMapOrNull(str, Double::parseDouble);
    }

    static java.time.Duration parseDurationOrNull(String str) {
        return MicrometerTaskHelper.parseMapOrNull(str, MicrometerTaskHelper::parseDuration);
    }

    static <T, U> T parseMapOrNull(U nullable, Function<U, T> mapfunction) {
        return Optional.ofNullable(nullable).map(mapfunction).orElse(null);
    }

    static Map<String, Object> toOutputs(String key, Object value) {
        if (value != null) {
            HashMap<String, Object> outputs = new HashMap<String, Object>();
            outputs.put(key, value);
            return outputs;
        }
        return Collections.emptyMap();
    }

    static double[] parsePercentilesList(String percentiles) {
        return MicrometerTaskHelper.splitStringList(percentiles).mapToDouble(Double::parseDouble).toArray();
    }

    static java.time.Duration[] parseSlaListToDurations(String sla) {
        return (java.time.Duration[])MicrometerTaskHelper.splitStringList(sla).map(java.time.Duration::parse).toArray(java.time.Duration[]::new);
    }

    static double[] parseSlaListToDoubles(String sla) {
        return MicrometerTaskHelper.splitStringList(sla).mapToDouble(Double::parseDouble).toArray();
    }

    static void logTimerState(Logger logger, Timer timer, TimeUnit timeunit) {
        logger.info("Timer current total time is " + timer.totalTime(timeunit) + " " + timeunit);
        logger.info("Timer current max time is " + timer.max(timeunit) + " " + timeunit);
        logger.info("Timer current mean time is " + timer.mean(timeunit) + " " + timeunit);
        logger.info("Timer current count is " + timer.count());
    }

    static Validator<String> percentilesListValidation(String percentilesList) {
        return Validator.of((Object)percentilesList).validate(s -> s == null || MicrometerTaskHelper.parsePercentilesList(s) != null, "Cannot parse percentils list");
    }

    static Validator<String> slaListToDoublesValidation(String sla) {
        return Validator.of((Object)sla).validate(s -> s == null || MicrometerTaskHelper.parseSlaListToDoubles(s) != null, "Cannot parse sla list");
    }

    static java.time.Duration parseDuration(String duration) {
        return java.time.Duration.of(Duration.parse((String)duration).toMilliseconds(), ChronoUnit.MILLIS);
    }

    private static Stream<String> splitStringList(String list) {
        return Arrays.stream(list.split(",")).map(String::trim);
    }
}

