/*
 * Decompiled with CFR 0.152.
 */
package com.chutneytesting.task.kafka;

import com.chutneytesting.task.kafka.ChutneyKafkaProducerFactory;
import com.chutneytesting.task.spi.Task;
import com.chutneytesting.task.spi.TaskExecutionResult;
import com.chutneytesting.task.spi.injectable.Input;
import com.chutneytesting.task.spi.injectable.Logger;
import com.chutneytesting.task.spi.injectable.Target;
import com.chutneytesting.task.spi.validation.TaskValidatorsUtils;
import com.chutneytesting.task.spi.validation.Validator;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.commons.exec.util.MapUtils;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.common.header.internals.RecordHeader;
import org.springframework.kafka.core.KafkaTemplate;

public class KafkaBasicPublishTask
implements Task {
    private final ChutneyKafkaProducerFactory producerFactory = new ChutneyKafkaProducerFactory();
    private final Target target;
    private final String topic;
    private final Map<String, String> headers;
    private final String payload;
    private final Map<String, String> properties;
    private final Logger logger;

    public KafkaBasicPublishTask(Target target, @Input(value="topic") String topic, @Input(value="headers") Map<String, String> headers, @Input(value="payload") String payload, @Input(value="properties") Map<String, String> properties, Logger logger) {
        this.target = target;
        this.topic = topic;
        this.headers = headers != null ? headers : Collections.emptyMap();
        this.payload = payload;
        this.properties = Optional.ofNullable(MapUtils.merge(Optional.ofNullable(target).map(Target::properties).orElse(Collections.emptyMap()), properties)).orElse(new HashMap());
        this.logger = logger;
    }

    public List<String> validateInputs() {
        return Validator.getErrorsFrom((Validator[])new Validator[]{TaskValidatorsUtils.notBlankStringValidation((String)this.topic, (String)"topic"), TaskValidatorsUtils.notBlankStringValidation((String)this.payload, (String)"payload"), TaskValidatorsUtils.targetValidation((Target)this.target)});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TaskExecutionResult execute() {
        try {
            List recordHeaders = this.headers.entrySet().stream().map(it -> new RecordHeader((String)it.getKey(), ((String)it.getValue()).getBytes())).collect(Collectors.toList());
            this.logger.info("sending message to topic=" + this.topic);
            ProducerRecord producerRecord = new ProducerRecord(this.topic, null, null, (Object)this.payload, recordHeaders);
            KafkaTemplate<String, String> kafkaTemplate = this.producerFactory.create(this.target, this.properties);
            kafkaTemplate.send(producerRecord).get(5L, TimeUnit.SECONDS);
            this.logger.info("Published Kafka Message on topic " + this.topic);
            TaskExecutionResult taskExecutionResult = TaskExecutionResult.ok(this.toOutputs(this.headers, this.payload));
            return taskExecutionResult;
        }
        catch (Exception e) {
            this.logger.error("An exception occurs when sending a message to Kafka server: " + e.getMessage());
            TaskExecutionResult taskExecutionResult = TaskExecutionResult.ko();
            return taskExecutionResult;
        }
        finally {
            try {
                this.producerFactory.destroy();
            }
            catch (Exception e) {
                this.logger.error((Throwable)e);
            }
        }
    }

    private Map<String, Object> toOutputs(Map<String, String> headers, String payload) {
        HashMap<String, Object> results = new HashMap<String, Object>();
        results.put("payload", payload);
        results.put("headers", headers.entrySet().stream().map(Object::toString).collect(Collectors.joining(";", "[", "]")));
        return results;
    }
}

