/*
 * Decompiled with CFR 0.152.
 */
package com.chutneytesting.task.jms;

import com.chutneytesting.task.spi.Task;
import com.chutneytesting.task.spi.TaskExecutionResult;
import com.chutneytesting.task.spi.injectable.Input;
import com.chutneytesting.task.spi.injectable.Logger;
import com.chutneytesting.task.spi.validation.Validator;
import java.util.List;
import java.util.Objects;
import org.apache.activemq.broker.BrokerService;

public class JmsBrokerStopTask
implements Task {
    private final Logger logger;
    private final BrokerService brokerService;

    public JmsBrokerStopTask(Logger logger, @Input(value="jms-broker-service") BrokerService brokerService) {
        this.logger = logger;
        this.brokerService = brokerService;
    }

    public List<String> validateInputs() {
        Validator jmsBrokerValidation = Validator.of((Object)this.brokerService).validate(Objects::nonNull, "No jms-broker-service provided");
        return Validator.getErrorsFrom((Validator[])new Validator[]{jmsBrokerValidation});
    }

    public TaskExecutionResult execute() {
        this.logger.info("Call jms broker shutdown");
        try {
            this.brokerService.stop();
            return TaskExecutionResult.ok();
        }
        catch (Exception e) {
            this.logger.error((Throwable)e);
            return TaskExecutionResult.ko();
        }
    }
}

