/*
 * Decompiled with CFR 0.152.
 */
package com.chutneytesting.task.assertion.utils;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.MapDifference;
import com.google.common.collect.Maps;
import java.util.List;
import java.util.Map;

public final class JsonUtils {
    private static final ObjectMapper om = new ObjectMapper();

    public static String jsonStringify(Object obj) {
        if (obj == null) {
            return null;
        }
        if (obj instanceof String) {
            return (String)obj;
        }
        try {
            return om.writeValueAsString(obj);
        }
        catch (JsonProcessingException e) {
            throw new IllegalStateException("Can't convert obj as json string: " + obj, e);
        }
    }

    public static boolean lenientEqual(Object read1, Object read2, Boolean leftContains) {
        if (read1 instanceof Map && read2 instanceof Map) {
            Map map1 = (Map)read1;
            Map map2 = (Map)read2;
            MapDifference diff = Maps.difference((Map)map1, (Map)map2);
            if (diff.areEqual()) {
                return true;
            }
            if ((leftContains == null || !leftContains.booleanValue()) && diff.entriesOnlyOnLeft().isEmpty()) {
                return diff.entriesDiffering().keySet().stream().map(k -> JsonUtils.lenientEqual(map1.get(k), map2.get(k), false)).reduce(Boolean::logicalAnd).orElse(true);
            }
            if ((leftContains == null || leftContains.booleanValue()) && diff.entriesOnlyOnRight().isEmpty()) {
                return diff.entriesDiffering().keySet().stream().map(k -> JsonUtils.lenientEqual(map1.get(k), map2.get(k), true)).reduce(Boolean::logicalAnd).orElse(true);
            }
            return false;
        }
        if (read1 instanceof List && read2 instanceof List) {
            List list1 = (List)read1;
            List list2 = (List)read2;
            return list1.size() == list2.size() && list1.containsAll(list2);
        }
        return read1.equals(read2);
    }
}

