/*
 * Decompiled with CFR 0.152.
 */
package com.chutneytesting.task.amqp;

import com.chutneytesting.task.spi.FinallyAction;
import com.chutneytesting.task.spi.Task;
import com.chutneytesting.task.spi.TaskExecutionResult;
import com.chutneytesting.task.spi.injectable.FinallyActionRegistry;
import com.chutneytesting.task.spi.injectable.Input;
import com.chutneytesting.task.spi.injectable.Logger;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.apache.qpid.server.SystemLauncher;
import org.springframework.core.io.ClassPathResource;

public class QpidServerStartTask
implements Task {
    private final Logger logger;
    private final FinallyActionRegistry finallyActionRegistry;
    private final String initialConfiguration;

    public QpidServerStartTask(Logger logger, FinallyActionRegistry finallyActionRegistry, @Input(value="init-config") String initialConfiguration) {
        this.logger = logger;
        this.finallyActionRegistry = finallyActionRegistry;
        this.initialConfiguration = Optional.ofNullable(initialConfiguration).orElseGet(this::defaultConfiguration);
    }

    public TaskExecutionResult execute() {
        try {
            SystemLauncher systemLauncher = new SystemLauncher();
            this.logger.info("Try to start qpid server");
            systemLauncher.startup(this.createSystemConfig());
            this.createQuitFinallyAction(systemLauncher);
            return TaskExecutionResult.ok(this.toOutputs(systemLauncher));
        }
        catch (Exception e) {
            this.logger.error((Throwable)e);
            return TaskExecutionResult.ko();
        }
    }

    private String defaultConfiguration() {
        try {
            return new ClassPathResource("com/chutneytesting/task/amqp/default_qpid.json").getURL().toExternalForm();
        }
        catch (IOException ioe) {
            throw new UncheckedIOException(ioe);
        }
    }

    private Map<String, Object> createSystemConfig() {
        HashMap<String, Object> attributes = new HashMap<String, Object>();
        attributes.put("type", "Memory");
        attributes.put("initialConfigurationLocation", this.initialConfiguration);
        attributes.put("startupLoggedToSystemOut", true);
        return attributes;
    }

    private Map<String, Object> toOutputs(SystemLauncher systemLauncher) {
        HashMap<String, Object> outputs = new HashMap<String, Object>();
        outputs.put("qpidLauncher", systemLauncher);
        return outputs;
    }

    private void createQuitFinallyAction(SystemLauncher systemLauncher) {
        this.finallyActionRegistry.registerFinallyAction(FinallyAction.Builder.forAction((String)"qpid-server-stop", QpidServerStartTask.class).withInput("qpid-launcher", (Object)systemLauncher).build());
        this.logger.info("QpidServerStop finally action registered");
    }
}

