/*
 * Decompiled with CFR 0.152.
 */
package com.chutneytesting.task.amqp;

import com.chutneytesting.task.amqp.ConnectionFactoryFactory;
import com.chutneytesting.task.spi.Task;
import com.chutneytesting.task.spi.TaskExecutionResult;
import com.chutneytesting.task.spi.injectable.Input;
import com.chutneytesting.task.spi.injectable.Logger;
import com.chutneytesting.task.spi.injectable.Target;
import com.chutneytesting.task.spi.validation.TaskValidatorsUtils;
import com.chutneytesting.task.spi.validation.Validator;
import com.rabbitmq.client.AMQP;
import com.rabbitmq.client.Channel;
import com.rabbitmq.client.Connection;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.TimeoutException;

public class AmqpCleanQueuesTask
implements Task {
    private final ConnectionFactoryFactory connectionFactoryFactory = new ConnectionFactoryFactory();
    private final Target target;
    private final List<String> queueNames;
    private final Logger logger;

    public AmqpCleanQueuesTask(Target target, @Input(value="queue-names") List<String> queueNames, Logger logger) {
        this.target = target;
        this.queueNames = Optional.ofNullable(queueNames).orElse(Collections.emptyList());
        this.logger = logger;
    }

    public List<String> validateInputs() {
        return Validator.getErrorsFrom((Validator[])new Validator[]{TaskValidatorsUtils.targetValidation((Target)this.target), TaskValidatorsUtils.notEmptyListValidation(this.queueNames, (String)"queueNames")});
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public TaskExecutionResult execute() {
        try (Connection connection = this.connectionFactoryFactory.create(this.target).newConnection();){
            TaskExecutionResult taskExecutionResult;
            block15: {
                Channel channel = connection.createChannel();
                try {
                    for (String queueName : this.queueNames) {
                        AMQP.Queue.PurgeOk purgeOk = channel.queuePurge(queueName);
                        this.logger.info("Purge queue " + queueName + ". " + purgeOk.getMessageCount() + " messages deleted");
                    }
                    taskExecutionResult = TaskExecutionResult.ok();
                    if (channel == null) break block15;
                }
                catch (Throwable throwable) {
                    if (channel != null) {
                        try {
                            channel.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                channel.close();
            }
            return taskExecutionResult;
        }
        catch (IOException | TimeoutException e) {
            this.logger.error("Unable to establish connection to RabbitMQ: " + e.getMessage());
            return TaskExecutionResult.ko();
        }
    }
}

