/*
 * Decompiled with CFR 0.152.
 */
package com.chutneytesting.task.amqp;

import com.chutneytesting.task.amqp.ConnectionFactoryFactory;
import com.chutneytesting.task.amqp.utils.AmqpUtils;
import com.chutneytesting.task.spi.Task;
import com.chutneytesting.task.spi.TaskExecutionResult;
import com.chutneytesting.task.spi.injectable.Input;
import com.chutneytesting.task.spi.injectable.Logger;
import com.chutneytesting.task.spi.injectable.Target;
import com.chutneytesting.task.spi.validation.TaskValidatorsUtils;
import com.chutneytesting.task.spi.validation.Validator;
import com.rabbitmq.client.Channel;
import com.rabbitmq.client.Connection;
import com.rabbitmq.client.GetResponse;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.TimeoutException;

public class AmqpBasicGetTask
implements Task {
    private final ConnectionFactoryFactory connectionFactoryFactory = new ConnectionFactoryFactory();
    private final Target target;
    private final String queueName;
    private final Logger logger;

    public AmqpBasicGetTask(Target target, @Input(value="queue-name") String queueName, Logger logger) {
        this.target = target;
        this.queueName = queueName;
        this.logger = logger;
    }

    public List<String> validateInputs() {
        return Validator.getErrorsFrom((Validator[])new Validator[]{TaskValidatorsUtils.notBlankStringValidation((String)this.queueName, (String)"queue-name"), TaskValidatorsUtils.targetValidation((Target)this.target)});
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public TaskExecutionResult execute() {
        try (Connection connection = this.connectionFactoryFactory.create(this.target).newConnection();){
            TaskExecutionResult taskExecutionResult;
            block18: {
                GetResponse getResponse;
                Channel channel;
                block16: {
                    TaskExecutionResult taskExecutionResult2;
                    block17: {
                        channel = connection.createChannel();
                        try {
                            getResponse = channel.basicGet(this.queueName, true);
                            if (getResponse != null) break block16;
                            this.logger.error("No message available");
                            taskExecutionResult2 = TaskExecutionResult.ko();
                            if (channel == null) break block17;
                        }
                        catch (Throwable throwable) {
                            if (channel != null) {
                                try {
                                    channel.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        channel.close();
                    }
                    return taskExecutionResult2;
                }
                this.logger.info("Got AMQP Message on " + this.queueName + " with deliveryTag: " + getResponse.getEnvelope().getDeliveryTag());
                HashMap<String, Object> results = new HashMap<String, Object>();
                results.put("message", getResponse);
                results.put("body", new String(getResponse.getBody()));
                results.put("headers", AmqpUtils.convertMapLongStringToString(getResponse.getProps().getHeaders()));
                taskExecutionResult = TaskExecutionResult.ok(results);
                if (channel == null) break block18;
                channel.close();
            }
            return taskExecutionResult;
        }
        catch (IOException | TimeoutException e) {
            this.logger.error("Unable to establish connection to RabbitMQ: " + e.getMessage());
            return TaskExecutionResult.ko();
        }
    }
}

