/*
 * Decompiled with CFR 0.152.
 */
package com.chutneytesting.execution.domain;

import com.chutneytesting.execution.domain.GwtScenarioMarshaller;
import com.chutneytesting.scenario.domain.gwt.GwtScenario;
import com.chutneytesting.scenario.domain.gwt.GwtTestCase;
import com.chutneytesting.server.core.domain.execution.ExecutionRequest;
import com.chutneytesting.server.core.domain.execution.processor.TestCasePreProcessor;
import com.chutneytesting.server.core.domain.globalvar.GlobalvarRepository;
import org.apache.commons.text.StringEscapeUtils;
import org.springframework.stereotype.Component;

@Component
public class GwtDataSetPreProcessor
implements TestCasePreProcessor<GwtTestCase> {
    private final GlobalvarRepository globalvarRepository;
    private final GwtScenarioMarshaller marshaller;

    public GwtDataSetPreProcessor(GwtScenarioMarshaller marshaller, GlobalvarRepository globalvarRepository) {
        this.marshaller = marshaller;
        this.globalvarRepository = globalvarRepository;
    }

    public GwtTestCase apply(ExecutionRequest executionRequest) {
        GwtTestCase testCase = (GwtTestCase)executionRequest.testCase;
        return GwtTestCase.builder().withMetadata(testCase.metadata).withScenario(this.replaceParams(testCase.scenario)).build();
    }

    private GwtScenario replaceParams(GwtScenario scenario) {
        String blob = this.marshaller.serialize(scenario);
        return this.marshaller.deserialize(scenario.title, scenario.description, this.replaceParams(this.globalvarRepository.getFlatMap(), blob, StringEscapeUtils::escapeJson));
    }
}

